/*---------------------------------------------------------------------------
HostListManager.h - Header file for HostListManager class.
-----------------------------------------------------------------------------*/
#import <objc/Object.h>

#define CFGVERSION 2		/* Verion number of configuration file */

#define HOSTENTRYLEN sizeof(struct hostEntry) /* Max hostname length */

#define MAXCOMARGS 50           /* Max # of command line arguments */

#define MAXIDLEN 8		/* Max length of a login ID */
#define MAXPOPLEN 15		/* Max length of a button name in popup list */

#define MINCOLS 10		/* Min # columns in Terminal/Stuart window */
#define MAXCOLS 220		/* Max # columns in Terminal/Stuart window */

#define MINLINES 1		/* Min # lines in Terminal/Stuart window */
#define MAXLINES 90		/* Max # lines in Terminal/Stuart window */

#define MINFONTSIZE 8		/* Minimum font size  */
#define MAXFONTSIZE 24		/* Maximum font size  */

#define COURIER 1		/* Courier font */
#define OHLFS 2			/* Ohlfs font */

#define TERMINAL 1		/* Terminal application */
#define STUART 2		/* Stuart application */

#define TERMLAB   "Terminal Settings" /* Terminal box view label */
#define STUARTLAB "Stuart Settings"   /* Stuart box view label */

#define METAESC 27		/* Meta key value for escape */
#define SMETADEF 1		/* Stuart meta default radio tag */
#define TMETADEF 1		/* Terminal meta default radio tag */

#define SSTRICTEM 00001		/* Stuart Strict */
#define SKEYPAD   00002		/* Stuart Keypad */
#define SSCROLLBK 00004		/* Stuart Scrollback */
#define STRANSLAT 00010		/* Stuart Translate */
#define SREVERSE  00020		/* Stuart Reverse */
#define SKEYBDFOC 00040		/* Stuart KeyboardFocus */
#define STERMSPAC 00100		/* Stuart TerminalSpacing */
#define SMOUSEFOC 00200		/* Stuart MouseFocus */
#define SSOURCEDL 00400		/* Stuart SourceDotLogin */
#define STESTEXIT 01000		/* Stuart TestExit */

#define TTRANSLAT 00001		/* Terminal Translate */
#define TKEYPAD   00002		/* Terminal Keypad */
#define TSTRICTEM 00004		/* Terminal StrictEmulation */
#define TAUTOWRAP 00010		/* Terminal Autowrap */
#define TSCROLLBK 00020		/* Terminal Scrollback */
#define TAUTOFOCS 00040		/* Terminal AutoFocus */
#define TSOURCEDL 00100		/* Terminal SourceDotLogin */

#define RLOGIN 1		/* Remote login */
#define TELNET 2		/* Telnet */
#define TN3270 3		/* TN3270 */

#define DEFHEIGHT 55.0	        /* Default hosts window height */
#define MINHEIGHT 50.0	        /* Minimum hosts window height */
#define MAXHEIGHT 100.0         /* Maximum hosts window height */

#define DEFWIDTH 130.0		/* Default hosts window width */
#define MINWIDTH 90.0		/* Minimum hosts window width */
#define MAXWIDTH 200.0		/* Maximum hosts window width */

#define DEBUGOFF 0		/* Debug level off */
#define DEBUGLOW 1		/* Debug level low */
#define DEBUGHIGH 2		/* Debug level high */
#define DEBUGMAX 3		/* Debug level maximum */

#define MAXCONFIGLEN 128	/* Maximum config pathname length */
#define MAXRECLEN 512		/* Maximum config record length */

#define XDEFAULT 150		/* Default for configuration window X field */
#define YDEFAULT 820		/* Default for configuration window Y field */

/* Structure of each host entry */
struct hostEntry {		
   char popUpName[MAXPOPLEN+1];	/* Button name to appear in popup list */
   char hostName[MAXHOSTNAMELEN+1]; /* Real host name to connect to */
   char loginName[MAXIDLEN+1];	/* Remote login ID to use in connection */
   short int appType;		/* Application (e.g., Terminal, Stuart) */
   short int protocolType;	/* Type (e.g., rlogin, telnet) */
   short int locX;		/* Horizontal location for window */
   short int locY;		/* Vertical location for window */
   short int nCols;		/* Number of columns in window */
   short int nLines;		/* Number of lines in window */
   short int fontType;		/* Font type (e.g., courier, ohlfs) */
   short int fontSize;		/* Font size */
   short int autoStart;		/* Automatic launch flag */
   unsigned int flags;		/* Terminal or Stuart flags */
   short int meta;		/* Meta key value */
   struct hostEntry *nextHost;	/* Pointer to the next host entry */
   struct hostEntry *prevHost;	/* Pointer to the previous host entry */
};

/* Establish the interface definition and methods for this class */
@interface HostListManager:Object
{
   int debugLevel;		/* Debugging level */
   int nHosts;			/* Total number of hosts in list */
   struct hostEntry *begHost;	/* Pointer to beginning of host list */
}

+ new;
- (int)addHost:(const char *)buttonName
   fullHostName:(const char *)fullName
   loginName:(const char *)userId
   application:(short int)app   
   protocol:(short int)prot
   locX:(short int)x
   locY:(short int)y
   nLines:(short int)lines
   nCols:(short int)columns
   font:(short int)aFont
   fontSize:(short int)fontNum
   autoStart:(short int)autoLaunch
   flags:(unsigned int)flagValues
   meta:(short int)metaNum
   updateConfigFile:(short int)updConfigFile;
- (int)addLocalHost:sender;
- (int)changeHost:(const char *)buttonName
   fullHostName:(const char *)fullName
   loginName:(const char *)userId
   application:(short int)app
   protocol:(short int)prot
   locX:(short int)x
   locY:(short int)y
   nLines:(short int)lines
   nCols:(short int)columns
   font:(short int)aFont
   fontSize:(short int)fontNum
   autoStart:(short int)autoLaunch
   flags:(unsigned int)flagValues
   meta:(short int)metaNum;
- (int)deleteHost:(int)slotNum;
- errPrint:(char *)fieldName recNum:(int)recordNum;
- (int)getAppType:(int)slotNum;
- (int)getAutoStart:(int)slotNum;
- (char *)getButtonName:(int)slotNum;
- (int)getColumns:(int)slotNum;
- (const char *)getConfigFile:sender;
- (int)getDebugLevel:sender;
- (unsigned int)getFlags:(int)slotNum;
- (int)getFontType:(int)slotNum;
- (int)getFontSize:(int)slotNum;
- (char *)getFullHostName:(int)slotNum;
- (int)getHostSlotNum:(const char *)buttonName;
- (int)getLines:(int)slotNum;
- (int)getMeta:(int)slotNum;
- (int)getNumHosts:sender;
- (int)getProtocolType:(int)slotNum;
- (char *)getPopUpName:(int)slotNum;
- (char *)getUserID:(int)slotNum;
- (int)getX:(int)slotNum;
- (int)getY:(int)slotNum;
- initHLMObject:sender;
- (int)insert:(struct hostEntry *)hEntry;
- loadPopUpList:anObject;
- autoStart:sender;
- loginToHost:(const char *)buttonName activate:(BOOL)actWindow;
- (FILE *)openConfigFile:(const char *)mode;
- setConfigFile:(const char *)configFile;
- setDebugLevel:(short int)debugNum;
- setStuartDefault:aStuart default:(const char *)defaultV as:(const char *)asV;
- writeConfigFile:sender;

@end
