#include <c.h>
#include <libc.h>
#include <sys/ioctl.h>
#include <nextdev/video.h>

#define	BRIGHT_MAX 0x3d /* MIN & MAX from <next/scr.h> */
#define BRIGHT_DEF 0x1f
#define	BRIGHT_MIN 0x00

typedef enum { PROGRAM, VALUE, ARGC } ARGUMENTS;

void error(char *string)
{
    perror(string);
    exit(EXIT_FAILURE);
}

void main(int argc, char *argv[])
{
	int value, device;
	
	if(argc != ARGC) {
		(void) fprintf(stderr, "Usage:  %s value (%d <= value <= %d)\n",
			argv[PROGRAM], BRIGHT_MIN, BRIGHT_MAX);
		exit(EXIT_FAILURE);
		}

	if((device = open("/dev/vid0", O_RDWR, 0)) == CERROR) error("open");
	if(strncmp(argv[VALUE], "max", 3) == 0) value = BRIGHT_MAX;
	else if(strncmp(argv[VALUE], "min", 3) == 0) value = BRIGHT_MIN;
	else if(strncmp(argv[VALUE], "def", 3) == 0) value = BRIGHT_DEF;
	else value = atoi(argv[VALUE]);
	if(ioctl(device, DKIOCBRIGHT, &value) == CERROR) error("ioctl");
	if(close(device) == CERROR) error("close");

	exit(EXIT_SUCCESS);
}
