#import <objc/Object.h>
#import <string.h>
#import <appkit/nextstd.h>

@interface Filter:Object
{
// connectives
	id stateManager;
	id inspector;
	id menuList;
	id popupList;
	id nameCell;
	id optionCell;
// behaviors
	char *filterName;
	char *command;
	char *destination;
	char *menu;
	int inputFromStdin;
	int outputToStdout;
// states
	char *items;						// menu clone, for popuplist
	const char *selectedItem;
	char *pathname;					// filter file
	char assigned[256];
}

+ initialize;
- init;
- setStateManager: anObject;
- parameterChanged;
- nameChanged;
- (char *) filterName;
- (char *) command;
- (char *) destination;
- (int) inputFromStdin;
- (int) outputToStdout;
- (char *) menu;
- update;
- popupSelected: sender;
- (const char *) selectedItem;
- setNameCell: anObject;
- setOptionCell: anObject;
- (char *) assignVariable: (char *)iconPathList to: (char *)line;
- setPathname: (const char *) aString;
- (char *) pathname;
- read: (NXTypedStream *) ts;
- write: (NXTypedStream *) ts;
@end
