#import <appkit/appkit.h>
#import "StateManager.h"
#import "Filter.h"
#import "Script.h"
#import "FilterInspector.h"
#import "ScriptInspector.h"
#import "HelpManager.h"
#import "support.h"

@implementation HelpManager

- appDidInit: sender
{
	stateManager = sender;

	helpPopup = [[PopUpList alloc] init];
	[helpPopup addItem: "License"];
	[helpPopup addItem: "Introduction"];
	[helpPopup addItem: "Installation"];
	[helpPopup addItem: "Usage"];
	[helpPopup addItem: "Acknowledgments"];
	[helpPopup setTarget: self];
	[helpPopup setAction: @selector(popupSelected:)];
	[helpCategoryCell setIcon: "popup"];
	[helpCategoryCell setIconPosition: NX_ICONRIGHT];
	[helpCategoryCell setAltIcon: "popupH"];
	[helpCategoryCell setHighlightsBy: NX_NONE];
	[helpCategoryCell setAlignment: NX_LEFTALIGNED];
	[helpCategoryCell sendActionOn: NX_MOUSEDOWNMASK];
	[helpCategoryCell setTarget: helpPopup];
	[helpCategoryCell setAction: @selector(popUp:)];
	[helpCategoryCell setTitle: "License"];
	return self;
}

- activeChanged
{
	activeScript = [stateManager activeScript];
	return self;
}

- showText: (const char *) sectionName
{
	char *text;
	int size;
	NXStream *stream;

	text = getsectdata("HELP", sectionName, &size);
	if (text) {
		stream = NXOpenMemory(text, size, NX_READONLY);
		if (stream) {
			[[helpText docView] readRichText:stream];
		}
		NXClose(stream);
	}
}

// actions
- applicationHelp: sender
{
	[helpPanel makeKeyAndOrderFront: self];
	[self showText: "License"];
	return self;
}

- popupSelected: sender
{
	[self showText: [helpPopup selectedItem]];
	return self;
}

- setHelpPanel: anObject			{helpPanel = anObject; }
- setHelpText: anObject				{helpText = anObject; }
- setHelpCategoryButton: anObject
{
	helpCategoryButton = anObject;
	helpCategoryCell = [helpCategoryButton cell];
}
@end
