#import <appkit/Application.h>
#import <appkit/Cell.h>
#import <appkit/Form.h>
#import <appkit/Matrix.h>
#import <appkit/Window.h>
#import <appkit/OpenPanel.h>
#import "StateManager.h"
#import "Filter.h"
#import "Script.h"
#import "FilterInspector.h"
#import "ScriptInspector.h"
#import "HelpManager.h"
#import "support.h"

@implementation ScriptInspector

- appDidInit: sender
{
	stateManager = sender;
	return self;
}

// passing parameters
- activeChanged
{
	activeScript = [stateManager activeScript];
	[scriptNameForm setStringValue: [activeScript scriptName] at: 0];
	[confirmToggle selectCellWithTag: [activeScript confirm]];
	[errorTerminateToggle selectCellWithTag: [activeScript errorTerminate]];
	[foregroundToggle selectCellWithTag: [activeScript foreground]];
	[iconTypeToggle selectCellWithTag: [activeScript iconType]];
	[resultIconPathForm setStringValue: [activeScript resultIconPath] at: 0];
	[helpTextForm setStringValue: [activeScript helpText] at: 0];
	return self;
}

- (const char *) scriptName
{
	const char *p;
	p = [scriptNameForm stringValueAt: 0];
	return (p ? p : "");
}
- (int) confirm
{
	return [[confirmToggle selectedCell] tag];
}
- (int) errorTerminate
{
	return [[errorTerminateToggle selectedCell] tag];
}
- (int) foreground
{
	return [[foregroundToggle selectedCell] tag];
}
- (int) iconType
{
	return [[iconTypeToggle selectedCell] tag];
}
- (const char *) resultIconPath
{
	const char *p;
	p = [resultIconPathForm stringValueAt: 0];
	return (p ? p : "");
}
- (const char *) helpText
{
	const char *p;
	p = [helpTextForm stringValueAt: 0];
	return (p ? p : "");
}

// actions
- scriptOK: sender
{
	[activeScript parameterChanged];
	[self modified];
	[activeScript update];
	return self;
}

- help: sender
{
	NXRunAlertPanel("Script Help", [activeScript helpText], "OK", NULL, NULL);
	return self;
}

- modified
{
	[[activeScript window] setDocEdited: YES];
	return self;
}
- saved
{
	[[activeScript window] setDocEdited: NO];
	return self;
}

// glues
- setScriptNameForm: anObject		{scriptNameForm = anObject; } 
- setConfirmToggle: anObject		{confirmToggle = anObject; }
- setErrorTerminateToggle: anObject
								{errorTerminateToggle = anObject; }
- setForegroundToggle: anObject		{foregroundToggle = anObject; }
- setIconTypeToggle: anObject		{iconTypeToggle = anObject; }
- setResultIconPathForm: anObject	{resultIconPathForm = anObject; }
- setHelpTextForm: anObject			{helpTextForm = anObject; }

@end
