#include <ctype.h>		/* for isspace macro			*/
#include <stdio.h>		/* for hquota				*/
#include "tquote.h"
#include "scan.h"
#import <appkit/Application.h>

int iLine = 1;
int iFatals = 0;
char *pcFileName;

static int iCurChar = ' ';
VALUE VLValue;

/*
 * prepare to scan the named file
 */
int
ReScan(pcFile)
	char *pcFile;
{
	iLine = 1;
	pcFileName = pcFile;
	TQpcFileName = pcFile;
	if ((FILE *)0 == freopen(pcFile, "r", stdin)) {
		/* XXX Should create a dialog window here */
		fprintf(stderr, "%s: ", [NXApp appName]);
		perror(pcFile);
		return -1;
	}
	iCurChar = ' ';
	return 0;
}

/*
 * This is a simple scanner to scan the batch language.
 */
TOKEN
GetToken()
{
	for (;;) {
		/*
		 * eat spaces and tabs
		 */
		while (isspace(iCurChar) || ('\n' == iCurChar)) {
			if ('\n' == iCurChar) {
				++iLine;
			}
			iCurChar = getchar();
		}
		/*
		 * accept #-line comments
		 */
		if ('#' == iCurChar) {
			do {
				iCurChar = getchar();
			} while ('\n' != iCurChar && EOF != iCurChar);
			if ('\n' == iCurChar) {
				++iLine;
				iCurChar = getchar();
			}
			continue;
		}
		/*
		 * at end of file, keep returning T_EOF
		 */
		if (EOF == iCurChar) {
			return T_EOF;
		}
		/*
		 * scan simple tokens
		 */
		switch (iCurChar) {
		case ':':
			iCurChar = getchar();
			return T_BIND;
		case ',':
			iCurChar = getchar();
			return T_COMMA;
		case '(':
			iCurChar = getchar();
			return T_START;
		case ')':
			iCurChar = getchar();
			return T_END;
		case '\\':
			/*
			 * backslash newline outside of strings will just
			 * continue the line
			 */
			iCurChar = getchar();
			if ('\n' == iCurChar) {
				iCurChar = getchar();
				++iLine;
				continue;
			}
			ungetc(iCurChar, stdin);
			iCurChar = '\\';
			/*FALLTHROUGH*/
		default:
			break;
		}
		/*
		 * it must be a string
		 */
		VLValue.pc = TQScan(stdin, & iCurChar, STR_PREDICTED, STR_INCREMENT, (unsigned int *)0);
		return T_STRING;
	}
}

/*
 * make all error messages begin with a consistent format
 */
void
Error(iSeverity)
	int iSeverity;
{
	register char *pcSever;

	pcSever = "intern";
	switch (iSeverity) {
	case ER_WARNING:
		pcSever = "warning";
		break;
	case ER_FATAL:
		++iFatals;
		pcSever = "fatal";
		break;
	case ER_ABORT:
		pcSever = "abort";
		break;
	default:
		break;
	}
	/* XXX Should create dialog box here */
	fprintf(stderr, "%s: %s (line %d) %s: ", [NXApp appName], pcFileName, iLine, pcSever);
}
