/*
 * addfulltextindex  file.nxbf
 * Add an empty BTree called "FullTextIndex" to the file named on
 * the command line.  This can be used to repair the thesaurus
 * by doing
 * 
 *   addfulltextindex  /NextLibrary/References/Webster-Thesaurus/Thesaurus.nxbf
 *
 * Now that the thesaurus has a full text index, the NeXT libtext() routines
 * can be used on the thesaurus without crashing.
 *
 * to compile, cc -o addfulltextindex addfulltextindex.c -lbtree
 *
 * Steve Hayman
 * sahayman@cs.indiana.edu
 * May 13 1991
 * 
 */
//#include "websterd.h"
#import <stdio.h>
#import <objc/Object.h>
#import "/usr/local/include/btree/BTreeFile.h"
#import "/usr/local/include/btree/BTree.h"

main(argc, argv)
int argc;
char *argv[];
{
	
    id TBF;
    char **TB_contents;

    BTree *FullTextIndex;

    if ( argc != 2 ) {
	fprintf(stderr, "%s: Usage: %s file.nxbf\n", argv[0], argv[0]);
	exit(1);
    }

NX_DURING
    TBF = [BTreeFile
	openFile: argv[1]
	forWriting: 1 ];
NX_HANDLER
    /*
     * I don't really know how to handle this yet, or what facilities
     * libbtree.a provides for handling errors, or what the various
     * btree error codes mean.
     */
    fprintf(stderr, "%s: Exception occurred while trying to open %s\n",
	argv[0], argv[1] );
    fprintf(stderr, "%s: Exception Code: %d Data1: %s Data2: %s\n",
	argv[0],
	NXLocalHandler.code,
	NXLocalHandler.data1,
	NXLocalHandler.data2 );
    /*
     * I do know that you seem to get error 9011 if the dictionary
     * couldn't be locked
     */

    if ( NXLocalHandler.code == 9011 ) {
	fprintf(stderr, "%s: Perhaps the file couldn't be locked.  Kill Webster if it's running\n",
	    argv[0]);
    }
    exit(1);
NX_ENDHANDLER


    TB_contents = [TBF contents];

    while ( TB_contents && *TB_contents ) {
	if (strcmp(*TB_contents, "FullTextIndex") == 0 ) {
	    fprintf(stderr, "%s: %s already has a FullTextIndex.  No action taken\n",
		argv[0], argv[1]);
	    exit(1);
	}

	TB_contents++;
    }

    /*
     * ok here we go
     */
    FullTextIndex = [TBF createBTreeNamed: "FullTextIndex"];

    [FullTextIndex empty];

    [TBF save];
    exit(0);
}
