
/* Generated by Interface Builder */

#import "defs.h"
#import "Contour.h"
#import <appkit/Button.h>
#import <appkit/OpenPanel.h>
#import <appkit/Matrix.h>
#import <appkit/Cell.h>
#import <objc/Storage.h>
#import <math.h>
#import <strings.h>
#import <streams/streams.h>
#import <sys/types.h>
#import <sys/stat.h>

@implementation Contour

+ new
{
  self = [[super alloc] init];
  openPanel  = [OpenPanel new];
  switch2D3D = NO;
  moreThanOneFunction = YES;
  return self;
}

- set2DData:sender
{
  switch2D3D = YES;		/* 2D Data */
  moreThanOneFunction = YES;	/* Multiple Data */
  return self;
}
- set3DData:sender
{
  switch2D3D = NO;		/* 3D Data */
  moreThanOneFunction = YES;	/* Multiple Data */
  return self;
}
- set2DSingle:sender
{
  switch2D3D = YES;		/* 2D Data */
  moreThanOneFunction = NO;	/* Single Data */
  return self;
}
- set3DSingle:sender
{
  switch2D3D = NO;		/* 3D Data */
  moreThanOneFunction = NO;	/* Single Data */
  return self;
}

- (const char *)provideMainTitle   { return [mainTitle stringValueAt:0];    }

- (float)provideGridLineThickness { return [gridLineThickness floatValue]; }
- (float)provideContourLineThickness{return [contourLineThickness floatValue];}
- (NXCoord *)provideContourLevels:sender {  return contourLevels; }
- (int) provideGridLineColor        { return [gridLineColor selectedCol]; }
- (int) provideContourLineColor     { return [contourLineColor selectedCol]; }
- (int) provideContourNumber:sender { return contourNumber;}
- (int) provideViewingChoice:sender 
                   {return [viewingTransformations selectedRow]; }
- (int) provideFunctionChoice:sender
                   { return [functionMatrix selectedRow];}

- (function_part)provideFunction:sender { return functionH; }
- (grid_part)    provideGrid:sender     { return gridH; }


- (NXCoord)provideFsmach { return solnhunk.fsmach; }
- (NXCoord)provideAlpha  { return solnhunk.alpha; }
- (NXCoord)provideRe     { return solnhunk.re; }
- (NXCoord)provideTime   { return solnhunk.time; }

- (NXCoord)provideContourmin  {return [contourMin floatValueAt:0];}
- (NXCoord)provideContourmax  {return [contourMax floatValueAt:0];}
- (NXCoord)provideContourinc  {return [contourInc floatValueAt:0];}
- (NXCoord)provideFmin  {return [fMin floatValueAt:0];}
- (NXCoord)provideFmax  {return [fMax floatValueAt:0];}
- (NXCoord)provideXmin  {return [xMin floatValueAt:0];}
- (NXCoord)provideXmax  {return [xMax floatValueAt:0];}
- (NXCoord)provideYmin  {return [yMin floatValueAt:0];}
- (NXCoord)provideYmax  {return [yMax floatValueAt:0];}

- (BOOL) doAnimate
{  if ( [animate3DOnOff state] ) return YES;  else return NO; }

- (BOOL) doSetAspectRatio
{  if ( [setAspectRatio state] ) return NO;  else return YES; }

- (BOOL) do2D3D { return switch2D3D; }

- (BOOL) shouldChangeTitleFont
{  if ( [changeTitleFont state] ) return YES;   else return NO; }

- (BOOL) shouldChangeLabelFont
{  if ( [changeLabelFont state] ) return YES;   else return NO; }

- (BOOL) shouldShowXYLabels
{  if ( [xyLabelsOn state] ) return YES;   else return NO; }

- (BOOL) shouldShowUnitsLabel
{  if ( [unitsLabelOn state] ) return YES;   else return NO; }

- (BOOL) shouldShowContourValues
{  if ( [contourValuesOn state] ) return YES;   else return NO; }

- (BOOL) doZoom
{  if ( [zoomOnOff state] ) return YES;  else return NO; }

- (BOOL) doDrawFunction
{  if ( [drawFunction state] ) return YES;   else return NO; }

- (BOOL) doDrawGrid
{  if ( [drawGrid state] ) return YES;   else return NO; }

- (BOOL) doClearPlot
{  if ( [clearPlot state] ) return NO;   else return YES; }

- (BOOL) doSolidLines
{  if ( [solidContourLines state] ) return NO;   else return YES; }


- resetCmin:(NXCoord)aNum { [contourMin setFloatValue:aNum at:0]; 
			    return self; }
- resetCmax:(NXCoord)aNum { [contourMax setFloatValue:aNum at:0]; 
			    return self; }
- resetCinc:(NXCoord)aNum { [contourInc setFloatValue:aNum at:0]; 
			    return self; }
- resetFmin:(NXCoord)aNum { [fMin setFloatValue:aNum at:0]; return self; }
- resetFmax:(NXCoord)aNum { [fMax setFloatValue:aNum at:0]; return self; }
- resetXmin:(NXCoord)aNum { [xMin setFloatValue:aNum at:0]; return self; }
- resetXmax:(NXCoord)aNum { [xMax setFloatValue:aNum at:0]; return self; }
- resetYmin:(NXCoord)aNum { [yMin setFloatValue:aNum at:0]; return self; }
- resetYmax:(NXCoord)aNum { [yMax setFloatValue:aNum at:0]; return self; }

-resetMinMax:sender
{
  if([self doDrawGrid] && ![self doDrawFunction]){
    [self findGridMinAndMax];
    [self resetGridMinMax:self];
  }
  if([self doDrawFunction]){
    [self findFunctionGridMinAndMax];
    [self resetFunctionGridMinMax:self];
  }
  return self;
}


- resetGridMinMax:sender
{
  [self resetXmin:gridH.gridmin.x];
  [self resetYmin:gridH.gridmin.y];
  [self resetXmax:gridH.gridmax.x];
  [self resetYmax:gridH.gridmax.y];
  oldMin.x = gridH.gridmin.x;
  oldMin.y = gridH.gridmin.y;
  oldMax.x = gridH.gridmax.x;
  oldMax.y = gridH.gridmax.y;
  
  return self;
}

- resetFunctionGridMinMax:sender
{
  [self resetXmin:functionH.gridmin.x];
  [self resetYmin:functionH.gridmin.y];
  [self resetXmax:functionH.gridmax.x];
  [self resetYmax:functionH.gridmax.y];
  oldMin.x = functionH.gridmin.x;
  oldMin.y = functionH.gridmin.y;
  oldMax.x = functionH.gridmax.x;
  oldMax.y = functionH.gridmax.y;
  return self;
}

- resetFunctionMinMax:sender
{
  [self resetFmin:functionH.functionmin];
  [self resetFmax:functionH.functionmax];
  return self;
}

- resetGridSubsets:sender
{
  int i = 1;

    [jGridMax setIntValue:gridhunk.jmax at:0];
    [kGridMax setIntValue:gridhunk.kmax at:0];
    [lGridMax setIntValue:gridhunk.lmax at:0];
    [jGridMin setIntValue:i at:0];
    [kGridMin setIntValue:i at:0];
    [lGridMin setIntValue:i at:0];
    [jGridInc setIntValue:i at:0];
    [kGridInc setIntValue:i at:0];
    [lGridInc setIntValue:i at:0];

    return self;
}


- resetFunctionSubsets:sender
{
  int i = 1;
    [jFunctionMax setIntValue:solnhunk.jmax at:0];
    [kFunctionMax setIntValue:solnhunk.kmax at:0];
    [lFunctionMax setIntValue:solnhunk.lmax at:0];
    [jFunctionMin setIntValue:i at:0];
    [kFunctionMin setIntValue:i at:0];
    [lFunctionMin setIntValue:i at:0];
    [jFunctionInc setIntValue:i at:0];
    [kFunctionInc setIntValue:i at:0];
    [lFunctionInc setIntValue:i at:0];
    return self;
}


- resetAll:sender
{
  [self resetGridSubsets:self];
  [self resetFunctionSubsets:self];
  [self resetFunctionMinMax:self];
  stateChangeGrid = YES;
  stateChangeFunction = YES;
  return self;
}

- resetProjectionData:sender{  
  stateChangeGrid = YES;  
  stateChangeFunction = YES;  
  return self;
}

- resetGridData:sender{  
  [self resetGridSubsets:self];
  stateChangeGrid = YES;  
  return self;
}

- resetFunctionData:sender{  
  [self resetFunctionSubsets:self];
  stateChangeFunction = YES;  
  return self;
}

- drawPlotButton:(int)state
{
  if (state==0) {
    [plotButton highlight:NO];	/* will display normal title */
  }
  if (state==1) {
    [plotButton highlight:YES];	/* will display alternate title */
  }
  return self;
}


- makeContourLevels:sender
{
  float fmin,fmax,finc;
  int   ncont = 0,n;

  if( ![autoContours state] ){
    
    fmin  = [fMin floatValueAt:0];
    fmax  = [fMax floatValueAt:0];
    ncont = [numberContours intValueAt:0];
    
    if(ncont == 0){
      ncont = 1;
      [numberContours setIntValue:ncont at:0];
    }

    finc = (fmax-fmin)/20.;
    if(ncont != 1)finc = (fmax - fmin)/(ncont-1);
    if(ncont == 1)finc = 0.0;

    [self resetCmin:fmin];	/* send contour level info to panel */
    [self resetCmax:fmax];
    [self resetCinc:finc];

    contourNumber = ncont;
    free(contourLevels);
    contourLevels = (NXCoord *)malloc(ncont*sizeof(float));

    for (n=0; n < ncont; n++){
      contourLevels[n] = fmin + n*finc;
    }
  }
  
  else{

    fmin = [contourMin floatValueAt:0];
    fmax = [contourMax floatValueAt:0];
    finc = [contourInc floatValueAt:0];

    if(finc == 0.0 && (fmax != fmin) ){
      ncont = [numberContours intValueAt:0];
      finc = (fmax-fmin)/ncont;
      [self resetCinc:finc];
    }

    if(finc != 0)ncont = (int)(ABS(fmax - fmin)/ABS(finc));
    if(fmin + ncont*finc != fmax)ncont = ncont + 1;
    if(fmin == fmax)ncont = 1;

    contourNumber = ncont;
    free(contourLevels);
    contourLevels = (NXCoord *)malloc(ncont*sizeof(float));

    for (n=0; n < ncont; n++){
      contourLevels[n] = fmin + n*finc;
    }
    if(contourLevels[ncont-1] > fmax)contourLevels[ncont-1] = fmax;
  }
  
  return self;
}


- drawPlot:sender
{
  /* get new subsets and function for plotting */

  BOOL animate = [self doAnimate];
  BOOL b_2D = [self do2D3D];
  int planeChoice = [chooseFunctionPlane selectedRow];
  int i, i_0 = 0, i_m = 1, i_i = 1;

  /* error check */
  if(animate && ![self doDrawFunction])
    {NXBeep(); beepError = 1; return self; }

  if([self doDrawGrid] && gridH.jmax == 0)
    { NXBeep(); beepError = 2; return self; }

  if([self doDrawFunction] && functionH.jmax == 0)
    {NXBeep(); beepError = 3; return self; }

  /* save off old man/max */
  oldMin.x = [xMin floatValueAt:0];
  oldMax.x = [xMax floatValueAt:0];
  oldMin.y = [yMin floatValueAt:0];
  oldMax.y = [yMax floatValueAt:0];


  /*--------     load grid data   -----------*/
  if(gridhunk.jmax != 0) [self loadGrid:self];


  switch(planeChoice){
  case 0:
    i_0 = [jFunctionMin intValueAt:0]-1;
    i_i = [jFunctionInc intValueAt:0];
    i_m = [jFunctionMax intValueAt:0]-1;
    break;
  case 1:
    i_0 = [kFunctionMin intValueAt:0]-1;
    i_i = [kFunctionInc intValueAt:0];
    i_m = [kFunctionMax intValueAt:0]-1;
    break;
  case 2:
    i_0 = [lFunctionMin intValueAt:0]-1;
    i_i = [lFunctionInc intValueAt:0];
    i_m = [lFunctionMax intValueAt:0]-1;
    break;
  }

  if(!animate || b_2D){    i_i = 1;    i_m = i_0;   }

  for (i = i_0; i <= i_m; i+= i_i){

    if(animate){
      switch(planeChoice){
      case 0:
	[jFunctionMin setIntValue:i+1 at:0];
	break;
      case 1:
	[kFunctionMin setIntValue:i+1 at:0];
	break;
      case 2:
	[lFunctionMin setIntValue:i+1 at:0];
	break;
      }
    }

    if(solnhunk.jmax != 0){
      [self loadFunctionGrid:self];
      [self loadFunction:self];
      [self makeContourLevels:self];
    }
      
    if([self doDrawFunction] || [self doDrawGrid]){

      if([self checkMinMax] == 1){   /* check on min/max limits for errors */
	NXBeep(); beepError = 4; return self; }

      [self drawPlotButton:1];	/* display "Plotting" */
      [canvas display];
      [self drawPlotButton:0];	/* display "Plot" */
    }
    else{ NXBeep(); beepError = 22; return self; }
  }

  stateChangeGrid = NO;     /* reset stateChange so old min/max retained*/
  stateChangeFunction = NO;     /* reset stateChange so old min/max retained*/

  return self;
}


// Go through a particular datahunk and find values for datamin.x,
// datamax.x, datamin.y, datamax.y

  - findGridMinAndMax
{
  int j;

  gridH.gridmin.x = MAXFLOAT;	/* defined in /usr/include/math.h */
  gridH.gridmax.x = -MAXFLOAT;
  gridH.gridmin.y = MAXFLOAT;
  gridH.gridmax.y = -MAXFLOAT;

  for (j = 0; j < gridH.jmax*gridH.kmax; j++)  {
     gridH.gridmin.x = MIN(gridH.gridmin.x, gridH.x[j]);
     gridH.gridmax.x = MAX(gridH.gridmax.x, gridH.x[j]);
   }
  for (j = 0; j < gridH.jmax*gridH.kmax; j++)  {
     gridH.gridmin.y = MIN(gridH.gridmin.y, gridH.y[j]);
     gridH.gridmax.y = MAX(gridH.gridmax.y, gridH.y[j]);
   }
  return self;
}

  - findFunctionGridMinAndMax
{
  int j;

  functionH.gridmin.x = MAXFLOAT;	/* defined in /usr/include/math.h */
  functionH.gridmax.x = -MAXFLOAT;
  functionH.gridmin.y = MAXFLOAT;
  functionH.gridmax.y = -MAXFLOAT;

  for (j = 0; j < functionH.jmax*functionH.kmax; j++)  {
     functionH.gridmin.x = MIN(functionH.gridmin.x, functionH.x[j]);
     functionH.gridmax.x = MAX(functionH.gridmax.x, functionH.x[j]);
   }
  for (j = 0; j < functionH.jmax*functionH.kmax; j++)  {
     functionH.gridmin.y = MIN(functionH.gridmin.y, functionH.y[j]);
     functionH.gridmax.y = MAX(functionH.gridmax.y, functionH.y[j]);
   }
  return self;
}

  - findFunctionMinAndMax
{
  int j;

  functionH.functionmin = MAXFLOAT;	/* defined in /usr/include/math.h */
  functionH.functionmax = -MAXFLOAT;


  for (j = 0; j < functionH.jmax*functionH.kmax; j++)  {
     functionH.functionmin = MIN(functionH.functionmin, functionH.f[j]);
     functionH.functionmax = MAX(functionH.functionmax, functionH.f[j]);
   }
  return self;
}


// Use the OpenPanel object to get a filename
- openGrid:sender
{
//  char const  *fileTypes[2] = {"xy",0};  
  char const  *fileTypes[2] = {0,0};  
  char	fname[1024];
  
  [openPanel setTitle:"OPEN GRID FILE"];

  if ([openPanel runModalForTypes:fileTypes])  {
    strncpy(fname, [openPanel filename], 1024);
    [self openGridFile:fname];
  }
  return self;
}

// Use the OpenPanel object to get a filename
- openSolution:sender
{
//  char const  *fileTypes[2] = {"q",0};  
  char const  *fileTypes[2] = {0,0};  
  char	fname[1024];

  [openPanel setTitle:"OPEN DATA FILE"];

  if ([openPanel runModalForTypes:fileTypes])  {
    strncpy(fname, [openPanel filename], 1024);
    [self openSolnFile:fname];
  }
  return self;
}

- openGridFile:(char *)dataFile
{
    NXStream *dataStream;

    if ((dataStream = NXMapFile(dataFile, NX_READONLY)) == NULL)  {
      NXRunAlertPanel("Open", "Cannot open %s", "OK", NULL, NULL, dataFile);
      return self;
    }

    if ([self readGrid:dataStream :dataFile] == 0)  {
      NXRunAlertPanel("Read", "Couldn't read any data from %s", "OK",
		      NULL, NULL, dataFile);
      NXCloseMemory(dataStream, NX_FREEBUFFER);
      return self;
    }
    NXCloseMemory(dataStream, NX_FREEBUFFER);

    return self;
}
- openSolnFile:(char *)dataFile
{
    NXStream *dataStream;

    if ((dataStream = NXMapFile(dataFile, NX_READONLY)) == NULL)  {
      NXRunAlertPanel("Open", "Cannot open %s", "OK", NULL, NULL, dataFile);
      return self;
    }

    if ([self readSoln:dataStream :dataFile] == 0)  {
      NXRunAlertPanel("Read", "Couldn't read any data from %s", "OK",
		      NULL, NULL, dataFile);
      NXCloseMemory(dataStream, NX_FREEBUFFER);
      return self;
    }
    NXCloseMemory(dataStream, NX_FREEBUFFER);

    return self;
}



/* Allocate enough memory and read the data points */
- readGrid:(NXStream *)aDataStream :(char *)dataFile
{
  int j, numberofpoints;
  BOOL b_2D = [self do2D3D];
  int filesize,expected_filesize = 0, errorAlert = 0;
  struct stat filestat;

  /* set plot button title "Reading" */
  [plotButton setAltTitle:"Reading"];
  [plotButton highlight:YES];
  NXPing();			/* force plotButton redraw */

           NXRead(aDataStream, &gridhunk.jmax, sizeof(int));
           NXRead(aDataStream, &gridhunk.kmax, sizeof(int));
  if(!b_2D){ NXRead(aDataStream, &gridhunk.lmax, sizeof(int)); }
  else   {                      gridhunk.lmax = 1;           }
  
  numberofpoints = gridhunk.jmax*gridhunk.kmax*gridhunk.lmax;

  /*  check file size */
  stat(dataFile,&filestat);

  filesize = filestat.st_size;

  if(b_2D){

    expected_filesize = 
      2*sizeof(int) + 2*sizeof(float)*numberofpoints;

    if(filesize != expected_filesize){
      errorAlert = NXRunAlertPanel("Read Grid File", 
		      "Not a Valid 2D Grid File! %s", 
		      "Try Again?","Continue?","Abort?", dataFile);
      
      if(errorAlert  != NX_ALERTALTERNATE){
	gridhunk.jmax = 0;
	gridhunk.kmax = 0;
	gridhunk.lmax = 0;
      }
      if(errorAlert  == NX_ALERTOTHER){
	/* reset plot button */
	[plotButton setAltTitle:"Plotting"];
	[plotButton highlight:NO];
	return self;
      }
      if(errorAlert  == NX_ALERTDEFAULT){
	/* reset plot button */
	[plotButton setAltTitle:"Plotting"];
	[plotButton highlight:NO];
	[self openGrid:self];
	return self;
      }
    }
  }
  if(!b_2D){

    expected_filesize = 
      3*sizeof(int) + 3*sizeof(float)*numberofpoints;

    if(filesize != expected_filesize){
      errorAlert = NXRunAlertPanel("Read Grid File", 
		      "Not a Valid 3D Grid File! %s ", 
		      "Try Again?","Continue?","Abort?",dataFile);
      if(errorAlert  != NX_ALERTALTERNATE){
	gridhunk.jmax = 0;
	gridhunk.kmax = 0;
	gridhunk.lmax = 0;
      }
      if(errorAlert  == NX_ALERTOTHER){
	/* reset plot button */
	[plotButton setAltTitle:"Plotting"];
	[plotButton highlight:NO];
	return self;
      }
      if(errorAlert  == NX_ALERTDEFAULT){
	/* reset plot button */
	[plotButton setAltTitle:"Plotting"];
	[plotButton highlight:NO];
	[self openGrid:self];
	return self;
      }
    }
  }
  

  gridhunk.x = (NXCoord *)malloc(numberofpoints*sizeof(float));
  gridhunk.y = (NXCoord *)malloc(numberofpoints*sizeof(float));
  if(!b_2D){ gridhunk.z = (NXCoord *)malloc(numberofpoints*sizeof(float)); }

  NXRead(aDataStream, gridhunk.x, numberofpoints*sizeof(float));
  NXRead(aDataStream, gridhunk.y, numberofpoints*sizeof(float));
  if(!b_2D){NXRead(aDataStream, gridhunk.z, numberofpoints*sizeof(float)); }

  /* reset plot button */
  [plotButton setAltTitle:"Plotting"];
  [plotButton highlight:NO];

  [self resetGridSubsets:self];
 
  /* initialize gridH from gridhunk */
  /* Initialize as 2D xy plane (jk plane) */
  gridH.jmax = gridhunk.jmax;
  gridH.kmax = gridhunk.kmax;
  gridH.x = (NXCoord *)malloc(gridH.jmax*gridH.kmax*sizeof(float));
  gridH.y = (NXCoord *)malloc(gridH.jmax*gridH.kmax*sizeof(float));

  for (j = 0; j < gridhunk.jmax*gridhunk.kmax; j++){
    gridH.x[j] = gridhunk.x[j];
    gridH.y[j] = gridhunk.y[j];
  }
      
  [self findGridMinAndMax];


  /*  On initial read function-grid min/max set to be same as grid min/max */

  gridhunk.gridmin.x = gridH.gridmin.x;
  gridhunk.gridmin.y = gridH.gridmin.y;
  gridhunk.gridmax.x = gridH.gridmax.x;
  gridhunk.gridmax.y = gridH.gridmax.y;

  /*  set min/max forms */
  [self resetGridMinMax:self];
  stateChangeGrid = NO;
  return self;
}

// Allocate enough memory and read the data points
- readSoln:(NXStream *)aDataStream :(char *)dataFile
{
  float gamma = 1.4;
  int j, numberofpoints,i;
  BOOL b_2D = [self do2D3D];
  int filesize,expected_filesize = 0, errorAlert = 0;
  struct stat filestat;

  /* set plot button title "Reading" */
  [plotButton setAltTitle:"Reading"];
  [plotButton highlight:YES];
  NXPing();			/* force plotButton redraw */


  NXRead(aDataStream, &solnhunk.jmax, sizeof(int));
  NXRead(aDataStream, &solnhunk.kmax, sizeof(int));
  if(!b_2D){ NXRead(aDataStream, &solnhunk.lmax, sizeof(int)); }
  else{solnhunk.lmax = 1;}

  numberofpoints = solnhunk.jmax*solnhunk.kmax*solnhunk.lmax;


  /*  check file size */
  stat(dataFile,&filestat);

  filesize = filestat.st_size;

  if(b_2D){

    if(!moreThanOneFunction)expected_filesize = 
      2*sizeof(int) + sizeof(float)*numberofpoints;

    if(moreThanOneFunction)expected_filesize = 
      2*sizeof(int) + 4*sizeof(float) + 4*sizeof(float)*numberofpoints;

    if(filesize != expected_filesize){
      errorAlert = NXRunAlertPanel("Read Grid File Error", 
		      "Not a Valid 2D Data File! %s", 
		      "Try Again?","Continue","Abort?",dataFile);
      if(errorAlert  != NX_ALERTALTERNATE){
	solnhunk.jmax = 0;
	solnhunk.kmax = 0;
	solnhunk.lmax = 0;
      }
      if(errorAlert  == NX_ALERTOTHER){
	/* reset plot button */
	[plotButton setAltTitle:"Plotting"];
	[plotButton highlight:NO];
	return self;
      }
      if(errorAlert  == NX_ALERTDEFAULT){
	/* reset plot button */
	[plotButton setAltTitle:"Plotting"];
	[plotButton highlight:NO];
	[self openSolution:self];
	return self;
      }
    }
  }

  if(!b_2D){
    if(!moreThanOneFunction)expected_filesize = 
      3*sizeof(int) + sizeof(float)*numberofpoints;

    if(moreThanOneFunction)expected_filesize = 
      3*sizeof(int) + 4*sizeof(float) + 5*sizeof(float)*numberofpoints;

    if(filesize != expected_filesize){
      errorAlert = NXRunAlertPanel("Read Data File Error", 
		      "Not a Valid 3D Data File! %s", 
		      "Try Again?","Continue?","Abort?",dataFile);
      if(errorAlert  != NX_ALERTALTERNATE){
	solnhunk.jmax = 0;
	solnhunk.kmax = 0;
	solnhunk.lmax = 0;
      }
      if(errorAlert  == NX_ALERTOTHER){
	/* reset plot button */
	[plotButton setAltTitle:"Plotting"];
	[plotButton highlight:NO];
	return self;
      }
      if(errorAlert  == NX_ALERTDEFAULT){
	/* reset plot button */
	[plotButton setAltTitle:"Plotting"];
	[plotButton highlight:NO];
	[self openSolution:self];
	return self;
      }
    }
  }

  /*  checkpoint on data grid sizes against grid file*/
  if( (gridhunk.jmax != solnhunk.jmax) || (gridhunk.kmax != solnhunk.kmax)
     || (gridhunk.lmax != solnhunk.lmax) ){

    if(gridhunk.jmax == 0){
      errorAlert = NXRunAlertPanel("Read Data FileError", 
				   "Need to Read In A Grid First", 
				   "Try Again?","Continue?", "Abort?");
    }
    else{
      if(b_2D)errorAlert = 
	NXRunAlertPanel("Read Data FileError", 
			"Inconsistent Dimensions, you had %d %d\n File %s", 
			"Try Again?","Continue?", "Abort?",
			solnhunk.jmax,solnhunk.kmax,dataFile);
      if(!b_2D)errorAlert = 
	NXRunAlertPanel("Read Data FileError", 
			"Inconsistent Dimensions, you had %d %d %d\n File %s", 
			"Try Again?","Continue?", "Abort?",
			solnhunk.jmax,solnhunk.kmax,solnhunk.lmax,dataFile);
    }

    if(errorAlert  != NX_ALERTALTERNATE){
      solnhunk.jmax = 0;
      solnhunk.kmax = 0;
      solnhunk.lmax = 0;
    }
    if(errorAlert  == NX_ALERTOTHER){
      /* reset plot button */
      [plotButton setAltTitle:"Plotting"];
      [plotButton highlight:NO];
      return self;
    }
    if(errorAlert  == NX_ALERTDEFAULT){
      /* reset plot button */
      [plotButton setAltTitle:"Plotting"];
      [plotButton highlight:NO];
      [self openSolution:self];
      return self;
    }
  }

  if(moreThanOneFunction){
    NXRead(aDataStream, &solnhunk.fsmach, sizeof(float));
    NXRead(aDataStream, &solnhunk.alpha, sizeof(float));
    NXRead(aDataStream, &solnhunk.re, sizeof(float));
    NXRead(aDataStream, &solnhunk.time, sizeof(float));
  }

  solnhunk.rho    = (NXCoord *)malloc(numberofpoints*sizeof(float));
  if(moreThanOneFunction){
    solnhunk.rhou   = (NXCoord *)malloc(numberofpoints*sizeof(float));
    solnhunk.rhov   = (NXCoord *)malloc(numberofpoints*sizeof(float));
    if(!b_2D){solnhunk.rhow = (NXCoord *)malloc(numberofpoints*sizeof(float));}
    solnhunk.e           = (NXCoord *)malloc(numberofpoints*sizeof(float));
    solnhunk.pressure    = (NXCoord *)malloc(numberofpoints*sizeof(float));
    solnhunk.mach_number = (NXCoord *)malloc(numberofpoints*sizeof(float));
  }

  NXRead(aDataStream, solnhunk.rho,  numberofpoints*sizeof(float));
  if(moreThanOneFunction){
    NXRead(aDataStream, solnhunk.rhou, numberofpoints*sizeof(float));
    NXRead(aDataStream, solnhunk.rhov, numberofpoints*sizeof(float));
    if(!b_2D){NXRead(aDataStream, solnhunk.rhow, 
		     numberofpoints*sizeof(float));}
    NXRead(aDataStream, solnhunk.e,    numberofpoints*sizeof(float));
  }

  /*compute pressure and mach number here to speed up plotting */
  if(!b_2D){
    for(i=0; i < numberofpoints; i++){

      solnhunk.mach_number[i] = 
	 (solnhunk.rhou[i]*solnhunk.rhou[i] + 
	  solnhunk.rhov[i]*solnhunk.rhov[i] + 
	  solnhunk.rhow[i]*solnhunk.rhow[i]);

      solnhunk.pressure[i] = (gamma-1.0)*
	(solnhunk.e[i] - 0.5* solnhunk.mach_number[i]/solnhunk.rho[i]);

      solnhunk.mach_number[i] = 
	sqrt(solnhunk.mach_number[i] / 
	     (gamma * solnhunk.rho[i] * solnhunk.pressure[i]));

    }
  }
  else{
    for(i=0; i < numberofpoints; i++){

      solnhunk.mach_number[i] = 
	 (solnhunk.rhou[i]*solnhunk.rhou[i] + 
	  solnhunk.rhov[i]*solnhunk.rhov[i]);


      solnhunk.pressure[i] = (gamma-1.0)*
	(solnhunk.e[i] - 0.5* 
	 (solnhunk.rhou[i]*solnhunk.rhou[i] + 
	  solnhunk.rhov[i]*solnhunk.rhov[i])/solnhunk.rho[i]);

      solnhunk.mach_number[i] = 
	sqrt(solnhunk.mach_number[i] / 
	     (gamma * solnhunk.rho[i] * solnhunk.pressure[i]));

    }
  }


    /* reset plot button */
  [plotButton setAltTitle:"Plotting"];
  [plotButton highlight:NO];

  [self resetFunctionSubsets:self];

  /* initialize functionH from gridhunk */
  /* Initialize as 2D xy plane (jk plane) */
  functionH.jmax = solnhunk.jmax;
  functionH.kmax = solnhunk.kmax;
  functionH.x = 
    (NXCoord *)malloc(functionH.jmax*functionH.kmax*sizeof(float));
  functionH.y = 
    (NXCoord *)malloc(functionH.jmax*functionH.kmax*sizeof(float));
  functionH.f = 
    (NXCoord *)malloc(functionH.jmax*functionH.kmax*sizeof(float));

  for (j=0; j < solnhunk.jmax*solnhunk.kmax; j++){
    functionH.x[j] = gridhunk.x[j];
    functionH.y[j] = gridhunk.y[j];
    functionH.f[j] = solnhunk.rho[j];
  }

  [self findFunctionGridMinAndMax];
  [self resetFunctionGridMinMax:self];
  stateChangeFunction = NO;

  [self findFunctionMinAndMax];
  [self resetFunctionMinMax:self];
  
  return self;
}



- loadGrid:sender
{
  int  j, k, l, i, ii;
  int  jdim = solnhunk.jmax;
  int  kdim = solnhunk.kmax;
  int  jmax = solnhunk.jmax;
  int  kmax = solnhunk.kmax;
  int j_0,j_i,j_m,k_0,k_i,k_m,l_0,l_i,l_m;
  int planeChoice = [chooseGridPlane selectedRow];
  int viewChoice = [viewingTransformations selectedRow];
  BOOL b_2D = [self do2D3D];


  /* failsafe for 2d/3d */
  if(b_2D){
    if(viewChoice != 0){
      NXBeep(); beepError = 11;
      viewChoice = 0;
      [viewingTransformations selectCellAt:viewChoice:0];
    }
    if(planeChoice != 2){
      NXBeep(); beepError = 12;
      planeChoice = 2;
      [chooseGridPlane selectCellAt:planeChoice:0];
    }
  }


  /* shift indices down 1  */
  j_0 = [jGridMin intValueAt:0] - 1;
  j_i = [jGridInc intValueAt:0];
  j_m = [jGridMax intValueAt:0] - 1;

  k_0 = [kGridMin intValueAt:0] - 1;
  k_i = [kGridInc intValueAt:0];
  k_m = [kGridMax intValueAt:0] - 1;

  l_0 = [lGridMin intValueAt:0] - 1;
  l_i = [lGridInc intValueAt:0];
  l_m = [lGridMax intValueAt:0] - 1;
  

  /* failsafe, j or k can never be <=0 || >= max*/
  if(j_i <= 0 || j_i > gridhunk.jmax){
    NXBeep();  beepError = 20;
    j_i = 1;
    [jGridInc setIntValue:j_i at:0];
  }
  if(k_i <= 0 || k_i > gridhunk.kmax){
    NXBeep();  beepError = 20;
    k_i = 1;
    [kGridInc setIntValue:k_i at:0];
  }
  if(l_i <= 0 || l_i > gridhunk.lmax){
    NXBeep();  beepError = 20;
    l_i = 1;
    [lGridInc setIntValue:l_i at:0];
  }
  if(j_0 < 0 || j_0 > gridhunk.jmax-1){
    NXBeep();  beepError = 20;
    j_0 = 0;
    [jGridMin setIntValue:j_0+1 at:0];
  }
  if(k_0 < 0 || k_0 > gridhunk.kmax-1){
    NXBeep();  beepError = 20;
    k_0 = 0;
    [kGridMin setIntValue:k_0+1 at:0];
  }
  if(l_0 < 0 || l_0 > gridhunk.lmax-1){
    NXBeep();  beepError = 20;
    l_0 = 0;
    [lGridMin setIntValue:l_0+1 at:0];
  }
  if(j_m < 0 || j_m > gridhunk.jmax-1){
    NXBeep();  beepError = 20;
    j_m = gridhunk.jmax-1;
    [jGridMax setIntValue:j_m+1 at:0];
  }
  if(k_m < 0 || k_m > gridhunk.kmax-1){
    NXBeep();  beepError = 20;
    k_m = gridhunk.kmax-1;
    [kGridMax setIntValue:k_m+1 at:0];
  }
  if(l_m < 0 || l_m > gridhunk.lmax-1){
    NXBeep();  beepError = 20;
    l_m = gridhunk.lmax-1;
    [lGridMax setIntValue:l_m+1 at:0];
  }

  switch(planeChoice){

  case 0:
    jdim = (k_m - k_0)/k_i + 1;
    kdim = (l_m - l_0)/l_i + 1;
    j_m = j_0;
    [jGridMax setIntValue:j_m+1 at:0];
    j_i = 1;
    [jGridInc setIntValue:j_i at:0];
    break;
  case 1:
    jdim = (j_m - j_0)/j_i + 1;
    kdim = (l_m - l_0)/l_i + 1;
    k_m = k_0;
    [kGridMax setIntValue:k_m+1 at:0];
    k_i = 1;
    [kGridInc setIntValue:k_i at:0];
    break;
  case 2:
    jdim = (j_m - j_0)/j_i + 1;
    kdim = (k_m - k_0)/k_i + 1;
    l_m = l_0;
    [lGridMax setIntValue:l_m+1 at:0];
    l_i = 1;
    [lGridInc setIntValue:l_i at:0];
    break;
  }

  free((void *)gridH.x);
  free((void *)gridH.y);

  gridH.jmax = jdim;
  gridH.kmax = kdim;
  gridH.x = (NXCoord *)malloc(jdim*kdim*sizeof(float));
  gridH.y = (NXCoord *)malloc(jdim*kdim*sizeof(float));

  switch(viewChoice){

  case 0:
    ii = 0;
    for (l = l_0; l <= l_m; l= l + l_i){
      for (k = k_0; k <= k_m; k= k + k_i){
	for (j = j_0; j <= j_m; j = j + j_i){
	  i = l*jmax*kmax + k*jmax + j;
	  gridH.x[ii] = gridhunk.x[i];
	  gridH.y[ii] = gridhunk.y[i];
	  ii = ii+1;
	}
      }
    }
    break;

  case 1:

    ii = 0;
    for (l = l_0; l <= l_m; l= l + l_i){
      for (k = k_0; k <= k_m; k= k + k_i){
	for (j = j_0; j <= j_m; j = j + j_i){
	  i = l*jmax*kmax + k*jmax + j;
	  gridH.x[ii] = gridhunk.y[i];
	  gridH.y[ii] = gridhunk.z[i];
	  ii = ii+1;
	}
      }
    }
    break;

  case 2:

    ii = 0;
    for (l = l_0; l <= l_m; l= l + l_i){
      for (k = k_0; k <= k_m; k= k + k_i){
	for (j = j_0; j <= j_m; j = j + j_i){
	  i = l*jmax*kmax + k*jmax + j;
	  gridH.x[ii] = gridhunk.x[i];
	  gridH.y[ii] = gridhunk.z[i];
	  ii = ii+1;
	}
      }
    }
    break;

  case 3:

    ii = 0;
    for (l = l_0; l <= l_m; l= l + l_i){
      for (k = k_0; k <= k_m; k= k + k_i){
	for (j = j_0; j <= j_m; j = j + j_i){
	  switch(planeChoice){
	  case 2:
	    gridH.x[ii] = (float)j+1;
	    gridH.y[ii] = (float)k+1;
	    break;
	  case 0:
	    gridH.x[ii] = (float)k+1;
	    gridH.y[ii] = (float)l+1;
	    break;
	  case 1:
	    gridH.x[ii] = (float)j+1;
	    gridH.y[ii] = (float)l+1;
	    break;
	  }
	  ii = ii+1;
	}
      }
    }
    break;
  }

  [self findGridMinAndMax];
  if(stateChangeGrid && !stateChangeFunction)[self resetGridMinMax:self];

  return self;
}

- loadFunction:sender
{
  int  j, k, l, i, ii;
  int  jdim = solnhunk.jmax;
  int  kdim = solnhunk.kmax;
  int  jmax = solnhunk.jmax;
  int  kmax = solnhunk.kmax;
  int j_0,j_i,j_m,k_0,k_i,k_m,l_0,l_i,l_m;
  int planeChoice = [chooseFunctionPlane selectedRow];
  int viewChoice = [viewingTransformations selectedRow];
  int functionChoice = [functionMatrix selectedRow];

  BOOL b_2D = [self do2D3D];


  /* failsafes for 2d/3d multiple vrs single functions*/

  if(!moreThanOneFunction && functionChoice > 0){
    NXBeep();	beepError = 13;		/* audible alert */
    functionChoice = 0;
    [functionMatrix selectCellAt:functionChoice:0];
  }

  if(b_2D){
    if(functionChoice == 5 || functionChoice == 8){
      NXBeep();	beepError = 14;	/* audible alert */
      functionChoice = 0;
      [functionMatrix selectCellAt:functionChoice:0];
    }
    if(viewChoice != 0){
      NXBeep();  beepError = 15;
      viewChoice = 0;
      [viewingTransformations selectCellAt:viewChoice:0];
    }
    if(planeChoice != 2){
      NXBeep(); beepError = 16;
      planeChoice = 2;
      [chooseFunctionPlane selectCellAt:planeChoice:0];
    }
  }


  /* shift indices down 1  */
  j_0 = [jFunctionMin intValueAt:0] - 1;
  j_i = [jFunctionInc intValueAt:0];
  j_m = [jFunctionMax intValueAt:0] - 1;

  k_0 = [kFunctionMin intValueAt:0] - 1;
  k_i = [kFunctionInc intValueAt:0];
  k_m = [kFunctionMax intValueAt:0] - 1;

  l_0 = [lFunctionMin intValueAt:0] - 1;
  l_i = [lFunctionInc intValueAt:0];
  l_m = [lFunctionMax intValueAt:0] - 1;
  

  /* failsafe, j or k can never be <=0 || >= max*/
  if(j_i <= 0 || j_i > solnhunk.jmax){
    NXBeep();  beepError = 21;
    j_i = 1;
    [jFunctionInc setIntValue:j_i at:0];
  }
  if(k_i <= 0 || k_i > solnhunk.kmax){
    NXBeep();  beepError = 21;
    k_i = 1;
    [kFunctionInc setIntValue:k_i at:0];
  }
  if(l_i <= 0 || l_i > solnhunk.lmax){
    NXBeep();  beepError = 21;
    l_i = 1;
    [lFunctionInc setIntValue:l_i at:0];
  }
  if(j_0 < 0 || j_0 > solnhunk.jmax-1){
    NXBeep();  beepError = 21;
    j_0 = 0;
    [jFunctionMin setIntValue:j_0+1 at:0];
  }
  if(k_0 < 0 || k_0 > solnhunk.kmax-1){
    NXBeep();  beepError = 21;
    k_0 = 0;
    [kFunctionMin setIntValue:k_0+1 at:0];
  }
  if(l_0 < 0 || l_0 > solnhunk.lmax-1){
    NXBeep();  beepError = 21;
    l_0 = 0;
    [lFunctionMin setIntValue:l_0+1 at:0];
  }
  if(j_m < 0 || j_m > solnhunk.jmax-1){
    NXBeep();  beepError = 21;
    j_m = solnhunk.jmax-1;
    [jFunctionMax setIntValue:j_m+1 at:0];
  }
  if(k_m < 0 || k_m > solnhunk.kmax-1){
    NXBeep();  beepError = 21;
    k_m = solnhunk.kmax-1;
    [kFunctionMax setIntValue:k_m+1 at:0];
  }
  if(l_m < 0 || l_m > solnhunk.lmax-1){
    NXBeep();  beepError = 21;
    l_m = solnhunk.lmax-1;
    [lFunctionMax setIntValue:l_m+1 at:0];
  }

  switch(planeChoice){

  case 0:
    jdim = (k_m - k_0)/k_i + 1;
    kdim = (l_m - l_0)/l_i + 1;
    j_m = j_0;
    [jFunctionMax setIntValue:j_m+1 at:0];
    j_i = 1;
    [jFunctionInc setIntValue:j_i at:0];
    break;
  case 1:
    jdim = (j_m - j_0)/j_i + 1;
    kdim = (l_m - l_0)/l_i + 1;
    k_m = k_0;
    [kFunctionMax setIntValue:k_m+1 at:0];
    k_i = 1;
    [kFunctionInc setIntValue:k_i at:0];
    break;
  case 2:
    jdim = (j_m - j_0)/j_i + 1;
    kdim = (k_m - k_0)/k_i + 1;
    l_m = l_0;
    [lFunctionMax setIntValue:l_m+1 at:0];
    l_i = 1;
    [lFunctionInc setIntValue:l_i at:0];
    break;
  }

  free((void *)functionH.f);

  functionH.jmax = jdim;
  functionH.kmax = kdim;
  functionH.f =  (NXCoord *)malloc(jdim*kdim*sizeof(float));


  /* load up subset function for plotting */

  ii = 0;
    for (l = l_0; l <= l_m; l= l + l_i){
      for (k = k_0; k <= k_m; k= k + k_i){
	for (j = j_0; j <= j_m; j = j + j_i){
	  i = l*jmax*kmax + k*jmax + j;

	  switch(functionChoice){
	  case 0:
	    functionH.f[ii] = solnhunk.rho[i];
	    break;
	  case 1:
	    functionH.f[ii] = solnhunk.pressure[i];
	    break;
	  case 2:
	    functionH.f[ii] = solnhunk.mach_number[i];
	    break;
	  case 3:
	    functionH.f[ii] = solnhunk.rhou[i]/solnhunk.rho[i];
	    break;
	  case 4:
	    functionH.f[ii] = solnhunk.rhov[i]/solnhunk.rho[i];
	    break;
	  case 5:
	    functionH.f[ii] = solnhunk.rhow[i]/solnhunk.rho[i];
	    break;
	  case 6:
	    functionH.f[ii] = solnhunk.rhou[i];
	    break;
	  case 7:
	    functionH.f[ii] = solnhunk.rhov[i];
	    break;
	  case 8:
	    functionH.f[ii] = solnhunk.rhow[i];
	    break;
	  case 9:
	    functionH.f[ii] = solnhunk.e[i];
	    break;
	  }
	  ii = ii+1;
	}
      }
    }
  [self findFunctionMinAndMax];
  [self resetFunctionMinMax:self];  

  return self;
}

- loadFunctionGrid:sender
{
  int  j, k, l, i, ii;
  int  jdim = solnhunk.jmax;
  int  kdim = solnhunk.kmax;
  int  jmax = solnhunk.jmax;
  int  kmax = solnhunk.kmax;
  int j_0,j_i,j_m,k_0,k_i,k_m,l_0,l_i,l_m;
  int planeChoice = [chooseFunctionPlane selectedRow];
  int viewChoice = [viewingTransformations selectedRow];
  int functionChoice = [functionMatrix selectedRow];

  BOOL b_2D = [self do2D3D];


  /* failsafe for 2d/3d */
  if(b_2D){
    if(functionChoice == 5 || functionChoice == 8){
      NXBeep();	 beepError = 17;	/* audible alert */
      functionChoice = 0;
      [functionMatrix selectCellAt:functionChoice:0];
    }
    if(viewChoice != 0){
      NXBeep(); beepError = 18;
      viewChoice = 0;
      [viewingTransformations selectCellAt:viewChoice:0];
    }
    if(planeChoice != 2){
      NXBeep();  beepError = 19;
      planeChoice = 2;
      [chooseFunctionPlane selectCellAt:planeChoice:0];
    }
  }


  /* shift indices down 1  */
  j_0 = [jFunctionMin intValueAt:0] - 1;
  j_i = [jFunctionInc intValueAt:0];
  j_m = [jFunctionMax intValueAt:0] - 1;

  k_0 = [kFunctionMin intValueAt:0] - 1;
  k_i = [kFunctionInc intValueAt:0];
  k_m = [kFunctionMax intValueAt:0] - 1;

  l_0 = [lFunctionMin intValueAt:0] - 1;
  l_i = [lFunctionInc intValueAt:0];
  l_m = [lFunctionMax intValueAt:0] - 1;
  

  /* failsafe, j or k can never be <=0 || >= max*/
  if(j_i <= 0 || j_i > solnhunk.jmax){
    NXBeep();  beepError = 21;
    j_i = 1;
    [jFunctionInc setIntValue:j_i at:0];
  }
  if(k_i <= 0 || k_i > solnhunk.kmax){
    NXBeep();  beepError = 21;
    k_i = 1;
    [kFunctionInc setIntValue:k_i at:0];
  }
  if(l_i <= 0 || l_i > solnhunk.lmax){
    NXBeep();  beepError = 21;
    l_i = 1;
    [lFunctionInc setIntValue:l_i at:0];
  }
  if(j_0 < 0 || j_0 > solnhunk.jmax-1){
    NXBeep();  beepError = 21;
    j_0 = 0;
    [jFunctionMin setIntValue:j_0+1 at:0];
  }
  if(k_0 < 0 || k_0 > solnhunk.kmax-1){
    NXBeep();  beepError = 21;
    k_0 = 0;
    [kFunctionMin setIntValue:k_0+1 at:0];
  }
  if(l_0 < 0 || l_0 > solnhunk.lmax-1){
    NXBeep();  beepError = 21;
    l_0 = 0;
    [lFunctionMin setIntValue:l_0+1 at:0];
  }
  if(j_m < 0 || j_m > solnhunk.jmax-1){
    NXBeep();  beepError = 21;
    j_m = solnhunk.jmax-1;
    [jFunctionMax setIntValue:j_m+1 at:0];
  }
  if(k_m < 0 || k_m > solnhunk.kmax-1){
    NXBeep();  beepError = 21;
    k_m = solnhunk.kmax-1;
    [kFunctionMax setIntValue:k_m+1 at:0];
  }
  if(l_m < 0 || l_m > solnhunk.lmax-1){
    NXBeep();  beepError = 21;
    l_m = solnhunk.lmax-1;
    [lFunctionMax setIntValue:l_m+1 at:0];
  }

  switch(planeChoice){

  case 0:
    jdim = (k_m - k_0)/k_i + 1;
    kdim = (l_m - l_0)/l_i + 1;
    j_m = j_0;
    [jFunctionMax setIntValue:j_m+1 at:0];
    j_i = 1;
    [jFunctionInc setIntValue:j_i at:0];
    break;
  case 1:
    jdim = (j_m - j_0)/j_i + 1;
    kdim = (l_m - l_0)/l_i + 1;
    k_m = k_0;
    [kFunctionMax setIntValue:k_m+1 at:0];
    k_i = 1;
    [kFunctionInc setIntValue:k_i at:0];
    break;
  case 2:
    jdim = (j_m - j_0)/j_i + 1;
    kdim = (k_m - k_0)/k_i + 1;
    l_m = l_0;
    [lFunctionMax setIntValue:l_m+1 at:0];
    l_i = 1;
    [lFunctionInc setIntValue:l_i at:0];
    break;
  }

  free((void *)functionH.x);
  free((void *)functionH.y);

  functionH.jmax = jdim;
  functionH.kmax = kdim;
  functionH.x =  (NXCoord *)malloc(jdim*kdim*sizeof(float));
  functionH.y =  (NXCoord *)malloc(jdim*kdim*sizeof(float));


  /* load up subset function grid for plotting */
  
  /*  load up grid */
  switch(viewChoice){

  case 0:
    ii = 0;
    for (l = l_0; l <= l_m; l= l + l_i){
      for (k = k_0; k <= k_m; k= k + k_i){
	for (j = j_0; j <= j_m; j = j + j_i){
	  i = l*jmax*kmax + k*jmax + j;
	  functionH.x[ii] = gridhunk.x[i];
	  functionH.y[ii] = gridhunk.y[i];
	  ii = ii+1;
	}
      }
    }
    break;

  case 1:

    ii = 0;
    for (l = l_0; l <= l_m; l= l + l_i){
      for (k = k_0; k <= k_m; k= k + k_i){
	for (j = j_0; j <= j_m; j = j + j_i){
	  i = l*jmax*kmax + k*jmax + j;
	  functionH.x[ii] = gridhunk.y[i];
	  functionH.y[ii] = gridhunk.z[i];
	  ii = ii+1;
	}
      }
    }
    break;

  case 2:

    ii = 0;
    for (l = l_0; l <= l_m; l= l + l_i){
      for (k = k_0; k <= k_m; k= k + k_i){
	for (j = j_0; j <= j_m; j = j + j_i){
	  i = l*jmax*kmax + k*jmax + j;
	  functionH.x[ii] = gridhunk.x[i];
	  functionH.y[ii] = gridhunk.z[i];
	  ii = ii+1;
	}
      }
    }
    break;

  case 3:

    ii = 0;
    for (l = l_0; l <= l_m; l= l + l_i){
      for (k = k_0; k <= k_m; k= k + k_i){
	for (j = j_0; j <= j_m; j = j + j_i){
	  switch(planeChoice){
	  case 2:
	    functionH.x[ii] = (float)j+1;
	    functionH.y[ii] = (float)k+1;
	    break;
	  case 0:
	    functionH.x[ii] = (float)k+1;
	    functionH.y[ii] = (float)l+1;
	    break;
	  case 1:
	    functionH.x[ii] = (float)j+1;
	    functionH.y[ii] = (float)l+1;
	    break;
	  }
	  ii = ii+1;
	}
      }
    }
    break;
  }


  [self findFunctionGridMinAndMax];
  if(stateChangeFunction)[self resetFunctionGridMinMax:self];
  return self;
}

- whyTheBeep:sender
{
  switch(beepError){
  case 0:
    NXRunAlertPanel("The Beep Panel", 
      "BEEP BEEP, We All Need Some Info SomeTime\n Just Click Why The Beep? whenever you here BEEP\n                A Service Of NXcontour",
		    "OK",NULL,NULL);
    break;
  case 1:
    NXRunAlertPanel("The Beep Happened Because", 
		    "Can't animate without drawing function",
		    "OK",NULL,NULL);
    break;
  case 2:
    NXRunAlertPanel("The Beep Happened Because", 
		    "No grid available for plotting \n read in a Grid File",
		    "OK",NULL,NULL);
    break;
  case 3:
    NXRunAlertPanel("The Beep Happened Because", 
	    "No function available for plotting \n read in a Data File",
		    "OK",NULL,NULL);
    break;
  case 4:
    NXRunAlertPanel("The Beep Happened Because", 
		    "You Can't Plot With min = max \n Check min/max Subsets, Plane and Projection",
		    "OK",NULL,NULL);
    break;
  case 11:
    NXRunAlertPanel("The Beep Happened Because", 
	    "Viewing Choice Must Be XY for 2D Cases \n I Fixed It For You",
		    "OK",NULL,NULL);
    break;
  case 12:
    NXRunAlertPanel("The Beep Happened Because", 
	    "Plane Choice Must Be l for 2D Cases \n I Fixed It For You",
		    "OK",NULL,NULL);
    break;
  case 13:
    NXRunAlertPanel("The Beep Happened Because", 
   "For Single Function Cases You Can Only Plot Q1 \n I Fixed It For You",
		    "OK",NULL,NULL);
    break;
  case 14:
    NXRunAlertPanel("The Beep Happened Because", 
   "For 2D Cases You Can't Plot W or Q4 \n I Fixed It For You",
		    "OK",NULL,NULL);
    break;
  case 15:
    NXRunAlertPanel("The Beep Happened Because", 
	    "Viewing Choice Must Be XY for 2D Cases \n I Fixed It For You",
		    "OK",NULL,NULL);
    break;
  case 16:
    NXRunAlertPanel("The Beep Happened Because", 
	    "Plane Choice Must Be l for 2D Cases \n I Fixed It For You",
		    "OK",NULL,NULL);
    break;
  case 17:
    NXRunAlertPanel("The Beep Happened Because", 
   "For 2D Cases You Can't Plot W or Q4 \n I Fixed It For You",
		    "OK",NULL,NULL);
    break;
  case 18:
    NXRunAlertPanel("The Beep Happened Because", 
	    "Viewing Choice Must Be XY for 2D Cases \n I Fixed It For You",
		    "OK",NULL,NULL);
    break;
  case 19:
    NXRunAlertPanel("The Beep Happened Because", 
	    "Plane Choice Must Be l for 2D Cases \n I Fixed It For You",
		    "OK",NULL,NULL);
    break;
  case 20:
    NXRunAlertPanel("The Beep Happened Because", 
	    "Indices Out Of Range For Grid Subsets\n I Fixed It For You",
		    "OK",NULL,NULL);
    break;
  case 21:
    NXRunAlertPanel("The Beep Happened Because", 
	    "Indices Out Of Range For Function Subsets\n I Fixed It For You",
		    "OK",NULL,NULL);
    break;
  case 22:
    NXRunAlertPanel("The Beep Happened Because", 
	    "You Need To Choose Plot Grid or Plot Function\n GO FOR IT!",
		    "OK",NULL,NULL);
    break;
  }
  return self;
}

- (int)checkMinMax
{ 
  float xmin = [xMin floatValueAt:0];
  float ymin = [yMin floatValueAt:0];
  float xmax = [xMax floatValueAt:0];
  float ymax = [yMax floatValueAt:0];
  int error = 0;

  if(xmin == xmax){
    NXRunAlertPanel
      ("Min/Max Check", 
       "Plot Error xmin = xmax : Check min/max \n Subsets, Plane Choice and Projections", 
       "OK",NULL,NULL);
    error = 1;
  }
  if(ymin == ymax){
    NXRunAlertPanel
      ("Min/Max Check", 
       "Plot Error ymin = ymax : Check min/max \n Subsets, Plane Choice and Projections", 
       "OK",NULL,NULL);
    error = 1;
  }

  return error;
}

@end



