
/* Generated by Interface Builder */

#import "defs.h"
#import "ContourView.h"
#import <appkit/SavePanel.h>
extern int contour_(int *jdim, int *kdim, int *nj, int *nk, 
		    float *x, float *y, float *f, int *ncont, float *acont,
		    float *ppxunit, float *ppyunit, int *colorMap);

@implementation ContourView

- (BOOL) acceptsFirstMouse { return YES;}    /* grab that mouse down event! */

- clear:sender
{
  NXEraseRect(&bounds);
  return self;
}


- setDrawColor:(float) color
{
  PSsetgray(color);
  return self;
}

- drawSelf: (const NXRect *)rects :(int)rectCount
{
  BOOL functionDraw = [contourParam doDrawFunction];
  BOOL gridDraw     = [contourParam doDrawGrid];
  BOOL clearPlot    = [contourParam doClearPlot];
  float  cmin = [contourParam provideContourmin];
  float  cmax = [contourParam provideContourmax];
  float  cinc = [contourParam provideContourinc];
  float  xmin = [contourParam provideXmin];
  float  xmax = [contourParam provideXmax];
  float  ymin = [contourParam provideYmin];
  float  ymax = [contourParam provideYmax];
  const char * maintitle = [contourParam provideMainTitle];
  const char * functiontitle = "Density";
  const char * xtitle = "x";
  const char * ytitle = "y";
  char unitLabel[40];
  int functionChoice = [contourParam provideFunctionChoice:self];
  id titleFont, labelFont;
  float   xwid, yhgt=14.0;
  float pattern0[] = {};	/* solid      */
  int   viewChoice =   [contourParam provideViewingChoice:self];
  NXRect contourBox;

  if(clearPlot)[self clear:self];

  if ([contourParam shouldChangeTitleFont]) {
    newTitleFont =
      [theFontManager convertFont:[theFontManager selFont]];
  }
  yhgt = [newTitleFont pointSize];

  if (yhgt==0) {
    titleFont =
      [Font newFont:"Helvetica" size:14.0 style:0 matrix:NX_IDENTITYMATRIX];
    yhgt = 14.0;
  }
  else {
    titleFont = [Font newFont:[newTitleFont name] 
		   size:[newTitleFont pointSize]
		   style:[newTitleFont style]
		   matrix:NX_IDENTITYMATRIX];
  }

  [titleFont set];

  xwid = [titleFont getWidthOf:maintitle];

  PSmoveto(XOFFSET/4.0 + (bounds.size.width - xwid)/2.0, 
	   bounds.size.height - 2.0 - yhgt);
  PSshow((char *)maintitle);

  if([contourParam shouldShowXYLabels]){

    switch(functionChoice){
    case 0:
      functiontitle = "Density / Q1";
      break;
    case 1:
      functiontitle = "Pressure";
      break;
    case 2:
      functiontitle = "Mach Number";
      break;
    case 3:
      functiontitle = "U - Velocity";
      break;
    case 4:
      functiontitle = "V - Velocity";
      break;
    case 5:
      functiontitle = "W - Velocity";
      break;
    case 6:
      functiontitle = "Q2";
      break;
    case 7:
      functiontitle = "Q3";
      break;
    case 8:
      functiontitle = "Q4";
      break;
    case 9:
      functiontitle = "Energy / Q5";
      break;
    }

    xwid = [titleFont getWidthOf:functiontitle];

    PSmoveto(XOFFSET/4.0 + (bounds.size.width - xwid)/2.0, 
	     bounds.size.height - 4.0 - 2.*yhgt);
    PSshow((char *)functiontitle);


    switch(viewChoice){

    case 0:
      xtitle = "x";
      ytitle = "y";
      break;
    case 1:
      xtitle = "x";
      ytitle = "z";
      break;
    case 2:
      xtitle = "y";
      ytitle = "z";
      break;
    case 3:
      xtitle = "i";
      ytitle = "j";
      break;
    }

    xwid = [titleFont getWidthOf:xtitle];

    PSmoveto(XOFFSET/4.0 + (bounds.size.width - xwid)/2.0, 
	     (bounds.origin.y + 10.0));
    PSshow((char *)xtitle);

    xwid = [titleFont getWidthOf:ytitle];
    yhgt = 10.0;
    PSmoveto((bounds.origin.x + 10.0 + yhgt), 
	     YOFFSET/4.0 + (bounds.size.height - xwid)/2.0);

    PSgsave();
    PSrotate(90.0);
    PSshow((char *)ytitle);
    PSgrestore();
  }


  PSgsave();

  PStranslate(XOFFSET, YOFFSET);

  ppxunit = 0.9*(bounds.size.width-XOFFSET)/(xmax-xmin);
  ppyunit = 0.9*(bounds.size.height-YOFFSET)/(ymax-ymin);
  

  if([contourParam doSetAspectRatio]){
    if(ABS(xmax-xmin) >= ABS(ymax-ymin)){
      ppyunit = ppxunit; }  else{  ppxunit = ppyunit;  } }


  xmin = xmin*ppxunit;	/* drawing is all in pixel coordinates */
  xmax = xmax*ppxunit;
  ymin = ymin*ppyunit;
  ymax = ymax*ppyunit;


  PStranslate(-xmin, -ymin);
  
  if(clearPlot){
    PSsetlinewidth(0);
    [self setDrawColor:NX_BLACK];
    
    PSnewpath();		/* draw bounding box */
    PSmoveto(xmin, ymin);
    PSlineto(xmax, ymin);
    PSlineto(xmax, ymax);
    PSlineto(xmin, ymax);
    PSclosepath();
    PSstroke();			/* finish bounding box */

    if ([contourParam shouldChangeLabelFont]) {
      newLabelFont =
	[theFontManager convertFont:[theFontManager selFont]];
    }
    yhgt = [newLabelFont pointSize];

    if (yhgt==0) {
      labelFont =
	[Font newFont:"Courier" size:12.0 style:0 matrix:NX_IDENTITYMATRIX];
      yhgt = 12.0;
    }
    else {
      labelFont = [Font newFont:[newLabelFont name] 
		 size:[newLabelFont pointSize]
		 style:[newLabelFont style]
		 matrix:NX_IDENTITYMATRIX];
    }

    [labelFont set];

    /*  draw unit labels */
    if([contourParam shouldShowUnitsLabel]){

      PSmoveto(xmin, ymin - 4.0); /* xmin unit label */
      PSsetdash(pattern0, 0, 0.0);
      PSrlineto(0.0, 4.0);
      PSstroke();
      sprintf(unitLabel, "%10.4g", xmin/ppxunit);
      xwid = [labelFont getWidthOf:unitLabel];
      PSmoveto(xmin - xwid/2.0, ymin - yhgt - 5.0);
      PSshow(unitLabel);

      PSmoveto(xmax, ymin - 4.0); /* xmax unit label */
      PSsetdash(pattern0, 0, 0.0);
      PSrlineto(0.0, 4.0);
      PSstroke();
      sprintf(unitLabel, "%10.4g", xmax/ppxunit);
      xwid = [labelFont getWidthOf:unitLabel];
      PSmoveto(xmax - xwid/2.0, ymin - yhgt - 5.0);
      PSshow(unitLabel);

      PSmoveto(xmin - 4.0, ymin ); /* ymin unit label */
      PSsetdash(pattern0, 0, 0.0);
      PSrlineto(4.0, 0.0);
      PSstroke();
      sprintf(unitLabel, "%10.4g", ymin/ppyunit);
      xwid = [labelFont getWidthOf:unitLabel];
      PSmoveto(xmin - xwid - 10.0, ymin + 2.0 - yhgt/2.0);
      PSshow(unitLabel);

      PSmoveto(xmin - 4.0, ymax ); /* ymax unit label */
      PSsetdash(pattern0, 0, 0.0);
      PSrlineto(4.0, 0.0);
      PSstroke();
      sprintf(unitLabel, "%10.4g", ymax/ppyunit);
      xwid = [labelFont getWidthOf:unitLabel];
      PSmoveto(xmin - xwid - 10.0, ymax + 2.0 - yhgt/2.0);
      PSshow(unitLabel);

    }
  }
 
  /* MIN and MAX below in case xmin > xmax  and/or  ymin > ymax. */
  PSrectclip(MIN(xmin,xmax), MIN(ymin,ymax), ABS(xmax-xmin), ABS(ymax-ymin));
  
  if(gridDraw)[self gridAndDraw];
  if(functionDraw)[self contourAndDraw];
  
  PSgrestore();

  if(clearPlot){
    /*  draw contour labels */
    if([contourParam shouldShowContourValues]){

      if ([contourParam shouldChangeLabelFont]) {
	newLabelFont =
	  [theFontManager convertFont:[theFontManager selFont]];
      }
      yhgt = [newLabelFont pointSize];
      
      if (yhgt==0) {
	labelFont =
	  [Font newFont:"Courier" size:12.0 style:0 matrix:NX_IDENTITYMATRIX];
	yhgt = 12.0;
      }
      else {
	labelFont = [Font newFont:[newLabelFont name] 
		   size:[newLabelFont pointSize]
		   style:[newLabelFont style]
		   matrix:NX_IDENTITYMATRIX];
      }

      [labelFont set];
      sprintf(unitLabel, "Contour Min = %10.6g", cmin);
      xwid = [labelFont getWidthOf:unitLabel];

      contourBox.origin.x = bounds.size.width - xwid - 20.;
      contourBox.origin.y = bounds.size.height - 3.*yhgt - 66.;
      contourBox.size.height = 3.*yhgt + 13.;
      contourBox.size.width = xwid + 6.;
      NXEraseRect(&contourBox);	/* clear the box area */

      PSmoveto(bounds.size.width -xwid -18., bounds.size.height - yhgt - 55.0);
      PSshow(unitLabel);

      sprintf(unitLabel, "Contour Max = %10.6g", cmax);
      PSmoveto(bounds.size.width -xwid -18., bounds.size.height -2.*yhgt-58.0);
      PSshow(unitLabel);

      sprintf(unitLabel, "Contour Inc = %10.6g", cinc);
      PSmoveto(bounds.size.width -xwid -18., bounds.size.height -3.*yhgt-61.0);
      PSshow(unitLabel);
    }
  }


  return self;
}

- contourAndDraw
{
  int colorMap;
  int lineColor =  [contourParam provideContourLineColor];
  function_part function;	/* the struct of our function */
  int number_of_contours;	/* the number of contour levels */
  float *contour_levels;	/* the contour level values */

  function = [contourParam provideFunction:self]; /* get function */

  number_of_contours = [contourParam provideContourNumber:self];

  contour_levels = [contourParam provideContourLevels:self];

  if([contourParam doSolidLines])colorMap = 0;
  if(![contourParam doSolidLines])colorMap = 1;

  PSsetlinewidth([contourParam provideContourLineThickness]);

  switch(lineColor){
  case 0:  [self setDrawColor:NX_LTGRAY]; break;
  case 1:  [self setDrawColor:NX_DKGRAY]; break;
  case 2:  [self setDrawColor:NX_BLACK]; break;
  }

  contour_(&function.jmax, &function.kmax, &function.jmax,
	   &function.kmax, function.x, function.y, function.f, 
	   &number_of_contours, contour_levels, &ppxunit, &ppyunit, &colorMap);

  return self;
}

- gridAndDraw
{

  int i,j,k;
  int lineColor =  [contourParam provideGridLineColor];

  grid_part grid;	/* the struct of our function */

  grid = [contourParam provideGrid:self]; /* get grid */
  
  PSsetlinewidth([contourParam provideGridLineThickness]);
  
  switch(lineColor){
  case 0:  [self setDrawColor:NX_LTGRAY]; break;
  case 1:  [self setDrawColor:NX_DKGRAY]; break;
  case 2:  [self setDrawColor:NX_BLACK]; break;
  }

  /* j family */
  for (k=0; k < grid.kmax; k++){
    i = k*grid.jmax;
    PSnewpath();
    PSmoveto(grid.x[i]*ppxunit, grid.y[i]*ppyunit);
    for (j=1; j < grid.jmax; j++){
      i = k*grid.jmax + j;
      PSlineto(grid.x[i]*ppxunit, grid.y[i]*ppyunit);
    }
    PSstroke();
  }

  /* k family */
  for (j=0; j < grid.jmax; j++){
    PSnewpath();
    PSmoveto(grid.x[j]*ppxunit, grid.y[j]*ppyunit);
    for (k=1; k < grid.kmax; k++){
      i = k*grid.jmax + j;
      PSlineto(grid.x[i]*ppxunit, grid.y[i]*ppyunit);
    }
    PSstroke();
  }

  return self;
}

- doPrinting:sender
{

  [ [NXApp printInfo] setMarginLeft:72.0 right:72.0 top:72.0 bottom:72.0 ];

  if (bounds.size.height > bounds.size.width) { /* portrait mode */
    if (bounds.size.height/bounds.size.width > 9.0/6.5) {
      [ [NXApp printInfo] setScalingFactor: 9.0*72.0/bounds.size.height];
    }
    else {
      [ [NXApp printInfo] setScalingFactor: 6.5*72.0/bounds.size.width];
    }
    [ [NXApp printInfo] setOrientation:NX_PORTRAIT andAdjust:YES ];
  }
  else {			/* landscape mode */
    if (bounds.size.width/bounds.size.height > 9.0/6.5) {
      [ [NXApp printInfo] setScalingFactor: 9.0*72.0/bounds.size.width];
    }
    else {
      [ [NXApp printInfo] setScalingFactor: 6.5*72.0/bounds.size.height];
    }
    [ [NXApp printInfo] setOrientation:NX_LANDSCAPE andAdjust:YES ];
  }

  [self printPSCode:sender];
  return self;
}

- mouseDown:(NXEvent *)e{
/*
 * This code taken from the Mandelbrot example in /NextDeveloper (and modified).
 * We implement the mouseDown method so the user can sweep out a section of
 * the view and select that as the current window in which to view the curve(s).
 */

  int looping = YES;
  int oldMask;
  NXRect bbox;
  NXPoint startPoint, currPoint;
  float xmin, xmax, ymin, ymax;
  BOOL zooming = [contourParam doZoom];

  if (zooming) {

    xmin = [contourParam provideXmin] * ppxunit;
    xmax = [contourParam provideXmax] * ppxunit;
    ymin = [contourParam provideYmin] * ppyunit;
    ymax = [contourParam provideYmax] * ppyunit;
  
  
    oldMask =  [window addToEventMask:NX_MOUSEDRAGGEDMASK];
    startPoint = e->location;
    [self convertPoint:&startPoint fromView:nil];
    NXSetRect(&bbox,startPoint.x,startPoint.y,0.0,0.0);
    [self lockFocus];
    while (looping) {
      e=[NXApp getNextEvent:NX_MOUSEUPMASK | NX_MOUSEDRAGGEDMASK];
      currPoint = e->location;
      [self convertPoint:&currPoint fromView:nil];
      bbox.size.width = (currPoint.x - startPoint.x);
      bbox.size.height = (currPoint.y - startPoint.y);
      /* Normalize bbox to always have positive width and height */
      if (bbox.size.width < 0) {
	bbox.size.width = -bbox.size.width;
	bbox.origin.x   = startPoint.x - bbox.size.width;
      }
      if (bbox.size.height < 0) {
	bbox.size.height = -bbox.size.height;
	bbox.origin.y    = startPoint.y - bbox.size.height;
      }
      /*
       * constrain the box to have the aspect ratio of the view.  Choose
       * whichever dimension is closer to the desired result.
       */
      PSnewinstance();
      if (looping = (e->type == NX_MOUSEDRAGGED)) {
	PSsetinstance(YES);
	PSsetgray(NX_BLACK);
	NXFrameRect(&bbox);
	PSsetinstance(NO);
      }
    }

    [self unlockFocus];
    [window setEventMask:oldMask];

    if ((bbox.size.width > 0) && (bbox.size.height > 0)) {
      /* At this point, bbox is in window coordinates.  Convert to curve
       * coordinates based on this view's coordinates and the bounding box.
       */

      /* save old min/max */
      oldMin.x = xmin/ppxunit;
      oldMin.y = ymin/ppyunit;
      oldMax.x = xmax/ppxunit;
      oldMax.y = ymax/ppyunit;

      xmin = xmin + (bbox.origin.x - XOFFSET);
      xmax = xmin + bbox.size.width;
      ymin = ymin + (bbox.origin.y - YOFFSET);
      ymax = ymin + bbox.size.height;

      [contourParam resetXmin:xmin/ppxunit];
      [contourParam resetXmax:xmax/ppxunit];
      [contourParam resetYmin:ymin/ppyunit];
      [contourParam resetYmax:ymax/ppyunit];

      /*  Call [self display] to force current values of xmin/xmax/ymin/ymax
       *  to take effect (otherwise xmin, etc., get incremented too many times).
       */
      [contourParam drawPlotButton:1];
      [self display];
      [contourParam drawPlotButton:0];
    }
  }
  return self;
}


- previousView:sender
{
  NXPoint currentMin, currentMax;

  currentMin.x = [contourParam provideXmin];
  currentMax.x = [contourParam provideXmax];
  currentMin.y = [contourParam provideYmin];
  currentMax.y = [contourParam provideYmax];

  if((oldMin.x == 0.0 && oldMax.x == 0.0) || 
     (oldMin.y == 0.0 && oldMax.y == 0.0)){
    NXBeep();
    return self;
  }
  [contourParam resetXmin:oldMin.x];
  [contourParam resetYmin:oldMin.y];
  [contourParam resetXmax:oldMax.x];
  [contourParam resetYmax:oldMax.y];
  [contourParam drawPlotButton:1];	/* display "Plotting" */
  [self display];
  [contourParam drawPlotButton:0];	/* display "Plot" */

  oldMin = currentMin;
  oldMax = currentMax;

  return self;
}

- initFrame:(const NXRect *)frameRect
{
  [super initFrame:frameRect];
  /* a place to init stuff  thp 6/12/91 */
  return self;
}

- saveEPS:sender
{
    id savePanel = [SavePanel new];
    char  *eps_fileName;	// Name of the EPS file for output

    [savePanel setTitle:"SAVE EPS FILE"];
    [savePanel setRequiredFileType:"eps"];
    if ([savePanel runModal])  {
      eps_fileName = (char *)calloc(strlen([savePanel filename])+1, 
				    sizeof(char));
      strcpy(eps_fileName, [savePanel filename]);
      [self savePSCode:eps_fileName];
    }

    return self;
}

- savePSCode:(char *)aFile
{
    NXStream	*psStream;

    psStream = NXOpenMemory(NULL, 0, NX_WRITEONLY);
    if (!psStream)  {
      return self;
    }
    [self getBounds:&bounds];
    [self copyPSCodeInside:&bounds to:psStream];
	   
    NXFlush(psStream);
    NXSaveToFile(psStream, aFile);
    NXCloseMemory(psStream, NX_FREEBUFFER);

    return self;
}


@end
