
/* Generated by Interface Builder */

#import "FormatHandler.h"
#import "Plot.h"
#import "PlotView.h"
#import <appkit/OpenPanel.h>
#import <appkit/SavePanel.h>
#import <appkit/Panel.h>
#import <streams/streams.h>
#import <strings.h>

@implementation FormatHandler

- writeFormatData:(NXStream *)formatStream
{
  id  font;
  int ncurves = [plotParam nCurvesTotal], i;
  NXPoint   point;
  NXRect    windowframe;

  NXPrintf(formatStream, "xmin xmax xinc: %g %g %g\n", [plotParam provideXmin],
	   [plotParam provideXmax], [plotParam provideXinc]);
  NXPrintf(formatStream, "ymin ymax yinc: %g %g %g\n", [plotParam provideYmin],
	   [plotParam provideYmax], [plotParam provideYinc]);
  NXPrintf(formatStream, "xaxis: %s\n", [plotParam xaxisLog]? "log" : "linear");
  NXPrintf(formatStream, "yaxis: %s\n", [plotParam yaxisLog]? "log" : "linear");

  NXPrintf(formatStream, "Main title: %s\n", [plotParam provideMainTitle]);
  NXPrintf(formatStream, " Font and size: ");
  font = [canvas provideMainTitleFont];
  if (font == NULL)
    NXPrintf(formatStream, "Helvetica 14.0\n");
  else
    NXPrintf(formatStream, "%s %f\n", [font name], [font pointSize]);

  NXPrintf(formatStream, "X title: %s\n", [plotParam provideXTitle]);
  NXPrintf(formatStream, " Font and size: ");
  font = [canvas provideXTitleFont];
  if (font == NULL)
    NXPrintf(formatStream, "Helvetica 12.0\n");
  else
    NXPrintf(formatStream, "%s %f\n", [font name], [font pointSize]);

  NXPrintf(formatStream, "Y title: %s\n", [plotParam provideYTitle]);
  NXPrintf(formatStream, " Font and size: ");
  font = [canvas provideYTitleFont];
  if (font == NULL)
    NXPrintf(formatStream, "Helvetica 12.0\n");
  else
    NXPrintf(formatStream, "%s %f\n", [font name], [font pointSize]);

  NXPrintf(formatStream, "Legend on/off: %d\n", [plotParam shouldDrawLegend]);
  NXPrintf(formatStream, "Legend Box on/off: %d\n",
	   [plotParam shouldDrawLegendBox]);
  NXPrintf(formatStream, "Legend title: %s\n", [plotParam provideLegendTitle]);
  NXPrintf(formatStream, " Font and size: ");
  font = [canvas provideLegendTitleFont];
  if (font == NULL)
    NXPrintf(formatStream, "Helvetica 12.0\n");
  else
    NXPrintf(formatStream, "%s %f\n", [font name], [font pointSize]);

  NXPrintf(formatStream, "Legend font and size: ");
  font = [canvas provideLegendFont];
  if (font == NULL)
    NXPrintf(formatStream, "Helvetica 12.0\n");
  else
    NXPrintf(formatStream, "%s %f\n", [font name], [font pointSize]);

  NXPrintf(formatStream, "No. of curves: %d\n", ncurves);
  NXPrintf(formatStream, "Curve No.  Line type  Symbol type   Title\n");
  for (i = 0; i < ncurves; i++) {
    NXPrintf(formatStream, "%4d %8d %10d %18s\n", i+1,
	     [plotParam providelinestyle:i],
	     [plotParam providesymbolstyle:i],
	     [plotParam provideCurveTitle:i]);
  }

  NXPrintf(formatStream, "Line thickness: %d\n", [plotParam providelinethickness]);
  NXPrintf(formatStream, "Symbol size: %d\n", [plotParam providesymbolsize]);

  NXPrintf(formatStream, "Grid on/off: %d\n", [plotParam shouldDrawGrid]);
  NXPrintf(formatStream, "Border box thickness: %f\n",
	   [plotParam provideBorderBoxThickness]);
  NXPrintf(formatStream, "Axes on/off: %d\n", [plotParam shouldDrawAxes]);

  NXPrintf(formatStream, "Tic label font and size: ");
  font = [canvas provideTicLabelFont];
  if (font == NULL)
    NXPrintf(formatStream, "Helvetica 12.0\n");
  else
    NXPrintf(formatStream, "%s %f\n", [font name], [font pointSize]);
  NXPrintf(formatStream, "Tic mark direction: %d\n",
	   [plotParam provideTicMarkDir]);
  NXPrintf(formatStream, "Minor tic marks on/off: %d\n",
	   [plotParam shouldDrawMinorTicMarks]);

  point = [canvas provideLegendBoxOrigin];
  NXPrintf(formatStream, "Legend box origin: %f %f\n", point.x, point.y);

  [canvas provideWindowFrame:&windowframe];
  NXPrintf(formatStream, "Window origin and size: %f %f %f %f\n",
	   windowframe.origin.x, windowframe.origin.y,
	   windowframe.size.width, windowframe.size.height);

  return self;
}

- readFormatData:(NXStream *)formatStream
{
  char  string[1024];
  float f1, f2, f3;
  int   i, j, ncurves, curveno, linetype, symtype;
  NXPoint point;
  NXRect  windowframe;

  while (NXGetc(formatStream) != ':') ;	/* throw away characters until a colon */
  (void) NXScanf(formatStream, "%f %f %f\n", &f1, &f2, &f3);
  [plotParam resetXmin:f1];
  [plotParam resetXmax:f2];
  [plotParam resetXinc:f3];
  while (NXGetc(formatStream) != ':') ;
  (void) NXScanf(formatStream, "%f %f %f\n", &f1, &f2, &f3);
  [plotParam resetYmin:f1];
  [plotParam resetYmax:f2];
  [plotParam resetYinc:f3];

  while (NXGetc(formatStream) != ':') ;
  (void) NXScanf(formatStream, "%s\n", string);
  if (!strncmp(string, "log", 3))
    [plotParam forceXaxisLog];
  else
    [plotParam forceXaxisLinear];

  while (NXGetc(formatStream) != ':') ;
  (void) NXScanf(formatStream, "%s\n", string);
  if (!strncmp(string, "log", 3))
    [plotParam forceYaxisLog];
  else
    [plotParam forceYaxisLinear];

  // Main title:
  while (NXGetc(formatStream) != ':') ;
  while (NXGetc(formatStream) == ' ') ;	/* throw away spaces */
  NXUngetc(formatStream);	/* but put that non-space back! */
  for (i = 0; i < 1024  && (string[i]=NXGetc(formatStream)) != '\n'; i++)
    ;				/* everything up to newline */
  string[i] = (char) NULL;
  [plotParam makeMainTitle:string];
  while (NXGetc(formatStream) != ':') ;
  while (NXGetc(formatStream) == ' ') ;
  NXUngetc(formatStream);
  (void) NXScanf(formatStream, "%s %f", string, &f1); /* font and size */
  [canvas forceMainTitleFont:string :f1];

  // X title:
  while (NXGetc(formatStream) != ':') ;
  while (NXGetc(formatStream) == ' ') ;
  NXUngetc(formatStream);
  for (i = 0; i < 1024  && (string[i]=NXGetc(formatStream)) != '\n'; i++)
    ;				/* everything up to newline */
  string[i] = (char) NULL;
  [plotParam makeXTitle:string];
  while (NXGetc(formatStream) != ':') ;
  while (NXGetc(formatStream) == ' ') ;
  NXUngetc(formatStream);
  (void) NXScanf(formatStream, "%s %f", string, &f1); /* font and size */
  [canvas forceXTitleFont:string :f1];

  // Y title:
  while (NXGetc(formatStream) != ':') ;
  while (NXGetc(formatStream) == ' ') ;
  NXUngetc(formatStream);
  for (i = 0; i < 1024  && (string[i]=NXGetc(formatStream)) != '\n'; i++)
    ;				/* everything up to newline */
  string[i] = (char) NULL;
  [plotParam makeYTitle:string];
  while (NXGetc(formatStream) != ':') ;
  while (NXGetc(formatStream) == ' ') ;
  NXUngetc(formatStream);
  (void) NXScanf(formatStream, "%s %f", string, &f1); /* font and size */
  [canvas forceYTitleFont:string :f1];

  // Legend on/off:
  while (NXGetc(formatStream) != ':') ;
  NXScanf(formatStream, "%d\n", &i);
  [plotParam maybeDrawLegend:i];

  // Legend Box on/off:
  while (NXGetc(formatStream) != ':') ;
  NXScanf(formatStream, "%d\n", &i);
  [plotParam maybeDrawLegendBox:i];

  // Legend title:
  while (NXGetc(formatStream) != ':') ;
  while (NXGetc(formatStream) == ' ') ;
  NXUngetc(formatStream);
  for (i = 0; i < 1024  && (string[i]=NXGetc(formatStream)) != '\n'; i++)
    ;				/* everything up to newline */
  string[i] = (char) NULL;
  [plotParam makeLegendTitle:string];

  // Legend title font:
  while (NXGetc(formatStream) != ':') ;
  while (NXGetc(formatStream) == ' ') ;
  NXUngetc(formatStream);
  (void) NXScanf(formatStream, "%s %f", string, &f1); /* font and size */
  [canvas forceLegendTitleFont:string :f1];

  // Legend font:
  while (NXGetc(formatStream) != ':') ;
  while (NXGetc(formatStream) == ' ') ;
  NXUngetc(formatStream);
  (void) NXScanf(formatStream, "%s %f", string, &f1); /* font and size */
  [canvas forceLegendFont:string :f1];

  // Curves: No., line type, symbol type, title
    while (NXGetc(formatStream) != ':') ;
  (void) NXScanf(formatStream, "%d\n", &ncurves);
  while (NXGetc(formatStream) != '\n') ;
  for (i = 0; i < ncurves; i++) {
    NXScanf(formatStream, "%d %d %d", &curveno, &linetype, &symtype);
    while (NXGetc(formatStream) == ' ') ;
    NXUngetc(formatStream);
    for (j = 0; j < 1024  && (string[j]=NXGetc(formatStream)) != '\n'; j++)
      ;				/* everything up to newline */
    string[j] = (char) NULL;
    [plotParam makeCurveTitle:i :string];
    [plotParam makeLineStyle:i :linetype];
    [plotParam makeSymbolType:i :symtype];
    [plotParam adjustLineStyleMatrix:i :linetype];
    [plotParam adjustSymbolTypeMatrix:i :symtype];
  }
  [plotParam redisplayLineStyleMatrix];
  [plotParam redisplaySymbolTypeMatrix];

  // Thickness:
  while (NXGetc(formatStream) != ':') ;
  (void) NXScanf(formatStream, "%d\n", &linetype);
  [plotParam makeLineThickness:linetype];

  // Symbol size:
  while (NXGetc(formatStream) != ':') ;
  (void) NXScanf(formatStream, "%d\n", &symtype);
  [plotParam makeSymbolSize:symtype];

  // Grid on/off:
  while (NXGetc(formatStream) != ':') ;
  (void) NXScanf(formatStream, "%d\n", &i);
  [plotParam maybeDrawGrid:i];

  // Border box thickness:
  while (NXGetc(formatStream) != ':') ;
  (void) NXScanf(formatStream, "%f\n", &f1);
  [plotParam forceBorderBoxThickness:f1];

  // Axes on/off:
  while (NXGetc(formatStream) != ':') ;
  (void) NXScanf(formatStream, "%d\n", &i);
  [plotParam maybeDrawAxes:i];

  // Tic label font:
  while (NXGetc(formatStream) != ':') ;
  while (NXGetc(formatStream) == ' ') ;
  NXUngetc(formatStream);
  (void) NXScanf(formatStream, "%s %f", string, &f1); /* font and size */
  [canvas forceTicLabelFont:string :f1];

  // Tic mark direction:
  while (NXGetc(formatStream) != ':') ;
  (void) NXScanf(formatStream, "%d\n", &i);
  if (i == 1)
    [plotParam forceTicMarksOut:self];
  else if (i == 0)
    [plotParam forceNoTicMarks:self];
  else
    [plotParam forceTicMarksIn:self];
  [plotParam changeTicMarksButton:i];

  // Minor tic marks on/off:
  while (NXGetc(formatStream) != ':') ;
  (void) NXScanf(formatStream, "%d\n", &i);
  [plotParam maybeDrawMinorTicMarks:i];

  // Legend Box origin:
  while (NXGetc(formatStream) != ':') ;
  (void) NXScanf(formatStream, "%f %f\n", &point.x, &point.y);
  [canvas forceLegendBoxOrigin:point];

  // Window origin and size:
  while (NXGetc(formatStream) != ':') ;
  (void) NXScanf(formatStream, "%f %f %f %f\n", &windowframe.origin.x,
		 &windowframe.origin.y, &windowframe.size.width,
		 &windowframe.size.height);
  [canvas forceWindowFrame:&windowframe];

  return self;
}

- getOpenFileName:(char *)name
{
  static const char *const fileTypes[2] = {NULL, NULL};
  id    openPanel = [[OpenPanel new] allowMultipleFiles:NO];

  if ([openPanel runModalForTypes:fileTypes]) {
    strncpy(name, [openPanel filename], 1024);
  }
  return self;
}

- getSaveFileName:(char *)name
{
  id    savePanel = [SavePanel new];

  if ([savePanel runModal]) {
    strncpy(name, [savePanel filename], 1024);
  }
  return self;
}

- writeFormatFile:sender
{
  char  fname[1024];
  NXStream *formatStream;

  // Get a filename:
  [self getSaveFileName:fname];
  // Get a stream:
  if ((formatStream = NXOpenMemory(NULL, 0, NX_WRITEONLY)) == NULL)  {
    NXRunAlertPanel("Write Format", "Cannot open memory for %s",
		    "OK", NULL, NULL, fname);
    return self;
  }
  // Write the data:
  [self writeFormatData:formatStream];

  // Save the file which was memory-mapped:
  NXFlush(formatStream);
  NXSaveToFile(formatStream, fname);
  NXClose(formatStream);

  return self;
}

- readFormatFile:sender
{
  char  fname[1024];
  NXStream *formatStream;

  // Get a filename:
  [self getOpenFileName:fname];
  // Get a stream:
  if ((formatStream = NXMapFile(fname, NX_READONLY)) == NULL)  {
    NXRunAlertPanel("Open", "Cannot open %s", "OK", NULL, NULL, fname);
    return self;
  }
  // Read the data:
  [self readFormatData:formatStream];

  // Redraw automatically:
  [plotParam drawPlot:self];
  return self;
}


@end
