
/* Generated by Interface Builder */

#import "defs.h"
#import "PlotView.h"
#import "Plot.h"

/* The following routines are in auxil.c: */
extern void count_labels(int *, float *, float, float, float);
extern void autoformat(float, float, float, int *);
extern void handformat(float, char *, int *);

@implementation PlotView

- provideMainTitleFont   { return newMainTitleFont;}
- provideXTitleFont      { return newXTitleFont;}
- provideYTitleFont      { return newYTitleFont;}
- provideLegendTitleFont { return newLegendTitleFont;}
- provideLegendFont      { return newLegendFont;}
- provideTicLabelFont    { return newTicLabelFont;}
- (NXPoint) provideLegendBoxOrigin { return legendbox.origin;}

- provideWindowFrame:(NXRect *)windowframe
{
  return [[self window] getFrame:windowframe];
}

/* All these method names that start with "force" would more naturally start
 * with "set", but everything malfunctions then; apparently it's a bad idea
 * to have methods whose names begin with "set".  Is it also a bad idea to
 * have methods whose names begin with "init"?
 */
- forceWindowFrame:(NXRect *)windowframe
{
  [[self window] placeWindow:windowframe];
  [self display];
  return self;
}

- forceLegendBoxOrigin: (NXPoint)point
{
  legendbox.origin = point;
  return self;
}

- forceMainTitleFont:(char *)fontname :(float)fontsize
{
  newMainTitleFont =
    [Font newFont:fontname size:fontsize style:0 matrix:NX_IDENTITYMATRIX];
  return self;
}

- forceXTitleFont:(char *)fontname :(float)fontsize;
{
  newXTitleFont =
    [Font newFont:fontname size:fontsize style:0 matrix:NX_IDENTITYMATRIX];
  return self;
}

- forceYTitleFont:(char *)fontname :(float)fontsize;
{
  newYTitleFont =
    [Font newFont:fontname size:fontsize style:0 matrix:NX_IDENTITYMATRIX];
  return self;
}

- forceLegendFont:(char *)fontname :(float)fontsize;
{
  newLegendFont =
    [Font newFont:fontname size:fontsize style:0 matrix:NX_IDENTITYMATRIX];
  return self;
}

- forceLegendTitleFont:(char *)fontname :(float)fontsize;
{
  newLegendTitleFont =
    [Font newFont:fontname size:fontsize style:0 matrix:NX_IDENTITYMATRIX];
  return self;
}

- forceTicLabelFont:(char *)fontname :(float)fontsize;
{
  newTicLabelFont =
    [Font newFont:fontname size:fontsize style:0 matrix:NX_IDENTITYMATRIX];
  return self;
}

- initializeLegendBox
{
  legendbox.origin.x = XOFFSET + 50.0;
  legendbox.origin.y = YOFFSET + 50.0;
  return self;
}

- (NXCoord *)xdata:(int)n	/* we use this in drawing the legend curves */
{
  xlegend[0] = (legendbox.origin.x + 5.0)/ppxunit;
  xlegend[1] = xlegend[0] + 40.0/ppxunit;
  /* curve fragment in legend is 40 pixels in length */
  if (!drawingLegendLines) xlegend[0] = 0.5*(xlegend[0] + xlegend[1]);
  return xlegend;
}

- (NXCoord **)ydata:(int)n	/* we use this in drawing the legend curves */
{
  int ncurves = [plotParam nCurvesTotal];
  int j;
  float yloc, yhgt=12.0;

  yhgt = [newLegendFont pointSize];

  if (yhgt==0) yhgt = 12.0;

  yloc = (legendbox.origin.y - 2.0)/ppyunit;

  ylegend = (NXCoord **)realloc((void *)ylegend, ncurves*sizeof(NXCoord *));
  for (j = 0; j < ncurves; j++) {
    *(ylegend+j) = (NXCoord *)NULL; /* this is necessary */
    *(ylegend+j) = (NXCoord *)realloc((void *)*(ylegend+j), 2*sizeof(NXCoord));
    /* no lines, but check symbols */
    if ( ([plotParam providelinestyle:j] == N_LINE_STYLES-1)  &&
	([plotParam providesymbolstyle:j] == 0) ) continue; /* no symbols */
    yloc = yloc + yhgt/ppyunit;
  }

  for (j=0; j<ncurves; j++) {
    *(*(ylegend+j)+0) = yloc;
    *(*(ylegend+j)+1) = yloc;
    /* no lines, but check symbols */
    if( ([plotParam providelinestyle:j] == N_LINE_STYLES-1)  &&
       ( [plotParam providesymbolstyle:j] == 0) )continue; /* no symbols */
    yloc -= yhgt/ppyunit;
  }
  return ylegend;
}

- (int)nPoints:(int)n
{
  if (drawingLegendLines)  return 2;
  else return 1;
}

- (int)nCurves:(int)n
{
  return [plotParam nCurvesTotal];
}

- (int)nFiles
{
  return 1;
}

- initPlot:sender
{
  const char * xtitle = [plotParam provideXTitle];
  const char * ytitle = [plotParam provideYTitle];
  const char * maintitle = [plotParam provideMainTitle];
  float   xwid, yhgt=12.0;
  id mainTitleFont,axisTitleFont;

  [self clear:self];
  PSsetlinewidth(0.0);
  [self setDrawColor:NX_BLACK];

  /*  get new font from fontmanager */
  if ([plotParam shouldChangeXTitleFont]) {
    newXTitleFont = [theFontManager convertFont:[theFontManager selFont]];
  }

  yhgt = [newXTitleFont pointSize];

  if (yhgt==0) {
    axisTitleFont =
      [Font newFont:"Helvetica" size:12.0 style:0 matrix:NX_IDENTITYMATRIX];
    yhgt = 12.0;
  }
  else {
    axisTitleFont = [Font newFont:[newXTitleFont name] 
		   size:[newXTitleFont pointSize]
		   style:[newXTitleFont style]
		   matrix:NX_IDENTITYMATRIX];
  }

  [axisTitleFont set];

  xwid = [axisTitleFont getWidthOf:xtitle];

  PSmoveto(XOFFSET/4.0 + (bounds.size.width - xwid)/2.0, 
           (bounds.origin.y + 10.0));
  PSshow((char *)xtitle);

  /*  get new font from fontmanager */
  if ([plotParam shouldChangeYTitleFont]) {
    newYTitleFont =
      [theFontManager convertFont:[theFontManager selFont]];
  }
  yhgt = [newYTitleFont pointSize];

  if (yhgt==0) {
    axisTitleFont =
      [Font newFont:"Helvetica" size:12.0 style:0 matrix:NX_IDENTITYMATRIX];
    yhgt = 12.0;
  }
  else {
    axisTitleFont = [Font newFont:[newYTitleFont name] 
		   size:[newYTitleFont pointSize]
		   style:[newYTitleFont style]
		   matrix:NX_IDENTITYMATRIX];
  }

  [axisTitleFont set];

  xwid = [axisTitleFont getWidthOf:ytitle];
  PSmoveto((bounds.origin.x + 6.0 + yhgt), 
           YOFFSET/4.0 + (bounds.size.height - xwid)/2.0);

  PSgsave();
  PSrotate(90.0);
  PSshow((char *)ytitle);
  PSgrestore();
  
  if ([plotParam shouldChangeMainTitleFont]) {
    newMainTitleFont =
      [theFontManager convertFont:[theFontManager selFont]];
  }
  yhgt = [newMainTitleFont pointSize];

  if (yhgt==0) {
    mainTitleFont =
      [Font newFont:"Helvetica" size:14.0 style:0 matrix:NX_IDENTITYMATRIX];
    yhgt = 14.0;
  }
  else {
    mainTitleFont = [Font newFont:[newMainTitleFont name] 
		   size:[newMainTitleFont pointSize]
		   style:[newMainTitleFont style]
		   matrix:NX_IDENTITYMATRIX];
  }

  [mainTitleFont set];

  xwid = [mainTitleFont getWidthOf:maintitle];

  PSmoveto(XOFFSET/4.0 + (bounds.size.width - xwid)/2.0, 
	   bounds.size.height - 2.0 - yhgt);
  PSshow((char *)maintitle);

  // box around it:
  if ([plotParam provideBorderBoxThickness] != 0.0) {
    PSsetlinewidth([plotParam provideBorderBoxThickness]);
    PSmoveto(0.0, 0.0);
    PSlineto(bounds.size.width, 0.0);
    PSlineto(bounds.size.width, bounds.size.height);
    PSlineto(0.0, bounds.size.height);
    PSlineto(0.0, 0.0);
    PSstroke();
    PSsetlinewidth(0.0);
  }
  return self;
}

- setDrawColor:(float) color
{
  PSsetgray(color);
  return self;
}

- drawLines:sender :(BOOL)xaxislog :(BOOL)yaxislog
/*
 * This is coded so that when drawLines is called with plotParam as argument,
 * it draws the data curves; when drawLines is called with self (plotView) as
 * argument, it draws the short line segments in the legend box.
 */
{
  int i, j, jrun, n;
  NXCoord *x;
  NXCoord **y;
  int npoints, ncurves;
  int curveindex = 0;		/* cumulative index */
  int linestyle;
  float thick = 0.0;
  float pattern0[] = {};	/* solid      */
  float pattern1[] = {4.0, 4.0}; /* dash       */
  float pattern2[] = {1.0, 3.0}; /* dot        */
  float pattern3[] = {7.0, 3.0, 3.0, 3.0}; /* chain dash */
  float pattern4[] = {7.0, 4.0, 1.0, 4.0}; /* chain dot  */

  switch([plotParam providelinethickness]) {
  case 0:
    thick = 0.0;		/* thin lines : good for screen */
    break;
  case 1:
    thick = 2.0;		/* medium lines */
    break;
  case 2:
    thick = 3.0;		/* fat lines */
    break;
  }

  for (n=0; n<[sender nFiles]; n++) { /* loop over all active files */
    x  = [sender xdata:n];
    y  = [sender ydata:n];
    ncurves = [sender nCurves:n];
    npoints = [sender nPoints:n];
    PSnewpath();
    PSsetlinewidth(thick);
    for (jrun=curveindex; jrun<curveindex+ncurves; jrun++) {
      linestyle = [plotParam providelinestyle:jrun];
      switch(linestyle) {
      case 0:
	PSsetdash(pattern0, 0, 0.0);
	break;
      case 1:
	PSsetdash(pattern1, 2, 0.0);
	break;
      case 2:
	PSsetdash(pattern2, 2, 0.0);
	break;
      case 3:
	PSsetdash(pattern3, 4, 0.0);
	break;
      case 4:
	PSsetdash(pattern4, 4, 0.0);
	break;
      case 5:			/* no lines */
	continue;
      }
      if (linestyle == N_LINE_STYLES-1) continue; /* no lines, go to next curve */
      j = jrun - curveindex;	/* for indexing into the y array */
      if (!xaxislog && !yaxislog) {
	PSmoveto(x[0]*ppxunit, *(*(y + j)) * ppyunit );
	for (i=1; i<npoints; i++) {
	  if ( (i % 512) == 0 ) {
	    PSstroke();
	    PSnewpath();
	    PSmoveto(x[i-1]*ppxunit, *(*(y+j)+i-1) * ppyunit);
	  }
	  PSlineto(x[i]*ppxunit, *(*(y+j)+i) * ppyunit);
	}
	PSstroke();
      }
      else if (!xaxislog && yaxislog) {
	PSmoveto(x[0]*ppxunit, (float)log10((double)*(*(y + j))) * ppyunit );
	for (i=1; i<npoints; i++) {
	  if ( (i % 512) == 0 ) {
	    PSstroke();
	    PSnewpath();
	    PSmoveto(x[i-1]*ppxunit, 
		     (float)log10((double)*(*(y+j)+i-1)) * ppyunit);
	  }
	  PSlineto(x[i]*ppxunit, (float)log10((double)*(*(y+j)+i)) * ppyunit);
	}
	PSstroke();
      }
      else if (xaxislog && !yaxislog) {
	PSmoveto((float)log10((double)x[0])*ppxunit, *(*(y + j)) * ppyunit );
	for (i=1; i<npoints; i++) {
	  if ( (i % 512) == 0 ) {
	    PSstroke();
	    PSnewpath();
	    PSmoveto((float)log10((double)x[i-1])*ppxunit,
		     *(*(y+j)+i-1) * ppyunit);
	  }
	  PSlineto((float)log10((double)x[i])*ppxunit, *(*(y+j)+i) * ppyunit);
	}
	PSstroke();
      }
      else if (xaxislog && yaxislog) {
	PSmoveto((float)log10((double)x[0])*ppxunit,
		 (float)log10((double)*(*(y + j))) * ppyunit );
	for (i=1; i<npoints; i++) {
	  if ( (i % 512) == 0 ) {
	    PSstroke();
	    PSnewpath();
	    PSmoveto((float)log10((double)x[i-1])*ppxunit,
		     (float)log10((double)*(*(y+j)+i-1)) * ppyunit);
	  }
	  PSlineto((float)log10((double)x[i])*ppxunit,
		   (float)log10((double)*(*(y+j)+i)) * ppyunit);
	}
	PSstroke();
      }
    }
    curveindex += ncurves;
  }
  PSsetdash(pattern0, 0, 0.0);	/* back to solid lines  */
  return self;
}

/*
 * Our first idea for drawing the symbols was: draw each symbol just once
 * in an off-screen window, then composite them in where needed.  This worked
 * fine for screen drawing (modulo a little difficulty in compositing to just
 * the right spot), but was a miserable failure when it came to printing: the
 * print machinery scaled the composite bitmap.  We finally decided to abandon
 * compositing, in the interest of keeping our screen drawing code the same as
 * our printing code.  Should check this again under version 2.0.
 */
- drawSymbols:sender :(BOOL)xaxislog :(BOOL)yaxislog
/*
 * This is coded so that when drawSymbols is called with plotParam as argument,
 * it draws the data curves; when drawSymbols is called with self (plotView) as
 * argument, it draws the symbols in the legend box.
 */
{
/* Our current code in drawSymbols could perhaps be sped up by using wraps
 * or DPSuserpath(). See if it's too slow as it stands before trying to
 * speed it up.
 */
  int i, j, jrun, n;
  float size = 4.0;
  NXCoord *x;
  NXCoord **y;
  int npoints, ncurves;
  int curveindex = 0;
  int symbolstyle;
  register float xtmp, ytmp;

  switch([plotParam providesymbolsize]) {
  case 0:			/* pixel symbols */
    size = 0.0;
    break;
  case 1:			/* small symbols */
    size = 2.0;
    break;
  case 2:			/* medium symbols */
    size = 4.0;
    break;
  case 3:			/* large symbols */
    size = 6.0;
    break;
  }

  PSgsave();
  for (n=0; n<[sender nFiles]; n++) { /* loop over all active files */
    x = [sender xdata:n];
    y = [sender ydata:n];
    ncurves = [sender nCurves:n];
    npoints = [sender nPoints:n];
    PSnewpath();
    PSsetlinewidth(0.0);
    for (jrun=curveindex; jrun<curveindex+ncurves; jrun++) {
      symbolstyle = [plotParam providesymbolstyle:jrun];
      j = jrun - curveindex;	/* for indexing into the y array */
      switch(symbolstyle) {
      case 0:			/* no symbols */
	continue;
	break;
      case 1:
	for (i=0; i<npoints; i++) {
	  /*	  circle_at(x[i], *(*(y+j)+i));      */
	  xtmp = (xaxislog? (float)log10((double)x[i]) : x[i]);
	  ytmp = (yaxislog? (float)log10((double)*(*(y+j)+i)) : *(*(y+j)+i));
	  PSarc(xtmp * ppxunit, ytmp * ppyunit, size, 0.0, 360.0);
	  PSfill();
	}
	break;
      case 2:
	for (i=0; i<npoints; i++) {
	  /*	  x_at(x[i], *(*(y+j)+i));           */
	  xtmp = (xaxislog? (float)log10((double)x[i]) : x[i]);
	  ytmp = (yaxislog? (float)log10((double)*(*(y+j)+i)) : *(*(y+j)+i));
	  PSmoveto(xtmp * ppxunit  - size, ytmp * ppyunit  - size);
	  PSrlineto(2.0*size, 2.0*size);
	  PSmoveto(xtmp * ppxunit  - size, ytmp * ppyunit  + size);
	  PSrlineto(2.0*size, -2.0*size);
	  PSstroke();
	}
	break;
      case 3:
	for (i=0; i<npoints; i++) {
	  /*	  uptriangle_at(x[i], *(*(y+j)+i));    */
	  xtmp = (xaxislog? (float)log10((double)x[i]) : x[i]);
	  ytmp = (yaxislog? (float)log10((double)*(*(y+j)+i)) : *(*(y+j)+i));
	  PSmoveto(xtmp * ppxunit  - size, ytmp * ppyunit  - size/SQRT3);
	  PSrlineto(2.0*size, 0.0);
	  PSrlineto(-size, size*SQRT3);
	  PSclosepath();
	  PSfill();
	}
	break;
      case 4:
	for (i=0; i<npoints; i++) {
	  /*	  downtriangle_at(x[i], *(*(y+j)+i));     */
	  xtmp = (xaxislog? (float)log10((double)x[i]) : x[i]);
	  ytmp = (yaxislog? (float)log10((double)*(*(y+j)+i)) : *(*(y+j)+i));
	  PSmoveto(xtmp * ppxunit  - size, ytmp * ppyunit  + size/SQRT3);
	  PSrlineto(2.0*size, 0.0);
	  PSrlineto(-size, -size*SQRT3);
	  PSclosepath();
	  PSfill();
	}
	break;
      case 5:
	for (i=0; i<npoints; i++) {
	  /*	  diamond_at(x[i], *(*(y+j)+i));          */
	  /* 3 pixels horizontal, 4 pixels vertical */
	  xtmp = (xaxislog? (float)log10((double)x[i]) : x[i]);
	  ytmp = (yaxislog? (float)log10((double)*(*(y+j)+i)) : *(*(y+j)+i));
	  PSmoveto(xtmp * ppxunit, ytmp * ppyunit  - size);
	  PSrlineto(3.0/4.0*size, size);	
	  PSrlineto(-3.0/4.0*size, size); /* gives a pleasing diamond shape */
	  PSrlineto(-3.0/4.0*size, -size);
	  PSclosepath();
	  PSfill();
	}
	break;
      case 6:
	for (i=0; i<npoints; i++) {
	  /*	  square_at(x[i], *(*(y+j)+i));            */
	  xtmp = (xaxislog? (float)log10((double)x[i]) : x[i]);
	  ytmp = (yaxislog? (float)log10((double)*(*(y+j)+i)) : *(*(y+j)+i));
	  PSrectfill(xtmp * ppxunit  - size, ytmp * ppyunit  - size,
		     2.0*size, 2.0*size);
	}
	break;
      case 7:
	for (i=0; i<npoints; i++) {
	  /*	  plus_at(x[i], *(*(y+j)+i));              */
	  xtmp = (xaxislog? (float)log10((double)x[i]) : x[i]);
	  ytmp = (yaxislog? (float)log10((double)*(*(y+j)+i)) : *(*(y+j)+i));
	  PSmoveto(xtmp * ppxunit, ytmp * ppyunit  - size);
	  PSrlineto(0.0, 2.0*size);
	  PSmoveto(xtmp * ppxunit  - size, ytmp * ppyunit);
	  PSrlineto(2.0*size, 0.0);
	  PSstroke();
	}
	break;
      }
    }
    curveindex += ncurves;
  }
  PSgrestore();

  return self;
}

- initLegend:sender
{
  id legendtextfont,legendTitleFont;
  const char * curvetitle;
  const char * legendtitle = [plotParam provideLegendTitle];
  int j;
  int ncurves = [plotParam nCurvesTotal];
  float maxcurvetitlewid = 0;
  float yhgt = 12.0;

  if ([plotParam shouldChangeLegendFont]) {
    newLegendFont = [theFontManager convertFont:[theFontManager selFont]];
  }

  yhgt = [newLegendFont pointSize];	/* height of text */

  /* get legend text font initialized */
  if (yhgt==0) {
    legendtextfont =
      [Font newFont:"Helvetica" size:12.0 style:0 matrix:NX_IDENTITYMATRIX];
    yhgt = 12.0;
  }
  else {
    legendtextfont = [Font newFont:[newLegendFont name] 
		           size:[newLegendFont pointSize]
		           style:[newLegendFont style]
		           matrix:NX_IDENTITYMATRIX];
  }

  [legendtextfont set];

  legendbox.size.height = 10.0;

  for (j=0; j<ncurves; j++) {
    /* no lines, but check symbols */
    if( ([plotParam providelinestyle:j] == N_LINE_STYLES-1)  &&
       ( [plotParam providesymbolstyle:j] == 0) )continue; /* no symbols */
    curvetitle = [plotParam provideCurveTitle:j];
    maxcurvetitlewid = MAX(maxcurvetitlewid,
			   [legendtextfont getWidthOf:curvetitle]);
    legendbox.size.height += yhgt; /* increment by yhgt for every curve */
  }

  /* check on legend title width also */

  if ([plotParam shouldChangeLegendTitleFont]) {
    newLegendTitleFont = [theFontManager convertFont:[theFontManager selFont]];
  }

  yhgt = [newLegendTitleFont pointSize];	/* height of text */

  if (yhgt==0) {
    legendTitleFont =
      [Font newFont:"Helvetica" size:12.0 style:0 matrix:NX_IDENTITYMATRIX];
    yhgt = 12.0;
  }
  else {
    legendTitleFont = [Font newFont:[newLegendTitleFont name] 
		            size:[newLegendTitleFont pointSize]
		            style:[newLegendTitleFont style]
		            matrix:NX_IDENTITYMATRIX];
  }

  [legendTitleFont set];
  maxcurvetitlewid = MAX(maxcurvetitlewid,
			   [legendTitleFont getWidthOf:legendtitle]);

  legendbox.size.width = 5.0 + 40.0 + 5.0 + maxcurvetitlewid + 5.0;
  /* legendboxwidth = L. margin + 40 + space + curve title + R. margin */
  if([legendTitleFont getWidthOf:legendtitle] != 0)
    legendbox.size.height = legendbox.size.height + 2.0*yhgt - 4.0;
  return self;
}

- drawLegend:sender
{
  id legendtextfont,legendTitleFont;
  const char * curvetitle;
  const char * legendtitle = [plotParam provideLegendTitle];
  int j;
  int ncurves = [plotParam nCurvesTotal];
  float yhgt = 12.0;

  if ([plotParam shouldChangeLegendFont]) {
    newLegendFont = [theFontManager convertFont:[theFontManager selFont]];
  }

  yhgt = [newLegendFont pointSize];

  /* get legend text font initialized */
  if (yhgt==0) {
    legendtextfont =
      [Font newFont:"Helvetica" size:12.0 style:0 matrix:NX_IDENTITYMATRIX];
    yhgt = 12.0;
  }
  else {
    legendtextfont = [Font newFont:[newLegendFont name] 
		           size:[newLegendFont pointSize]
		           style:[newLegendFont style]
		           matrix:NX_IDENTITYMATRIX];
  }

  [legendtextfont set];

  for (j=0; j<ncurves; j++) {
      /* no lines, but check symbols */
    if ( ([plotParam providelinestyle:j] == N_LINE_STYLES-1)  &&
	( [plotParam providesymbolstyle:j] == 0) ) continue; /* no symbols */
    curvetitle = [plotParam provideCurveTitle:j];
  }
  drawingLegendLines = YES;
  [self xdata:0];
  [self ydata:0];

  NXEraseRect(&legendbox);	/* clear legend box area */

  [sender drawLines:sender :NO :NO];	/* legend lines, linear axes always */

  for (j=0; j<ncurves; j++) {
    /* no lines, but check symbols */
    if ( ([plotParam providelinestyle:j] == N_LINE_STYLES-1)  &&
	([plotParam providesymbolstyle:j] == 0) ) continue; /* no symbols */
    curvetitle = [plotParam provideCurveTitle:j];
    PSmoveto(xlegend[1]*ppxunit + 5.0, 
	     *(*(ylegend+j)+0) * ppyunit - 0.33*yhgt);
    PSshow((char *)curvetitle);
  }

  if ([plotParam shouldChangeLegendTitleFont]) {
    newLegendTitleFont = [theFontManager convertFont:[theFontManager selFont]];
  }

  yhgt = [newLegendTitleFont pointSize];	/* height of text */
  if (yhgt==0) {
    legendTitleFont =
      [Font newFont:"Helvetica" size:12.0 style:0 matrix:NX_IDENTITYMATRIX];
    yhgt = 12.0;
  }
  else {
    legendTitleFont = [Font newFont:[newLegendTitleFont name] 
		            size:[newLegendTitleFont pointSize]
		            style:[newLegendTitleFont style]
		            matrix:NX_IDENTITYMATRIX];
  }

  [legendTitleFont set];
  PSmoveto(xlegend[0]*ppxunit - 5.0 + legendbox.size.width/2.0
	   - 0.5*[legendTitleFont getWidthOf:legendtitle],
	   *(*(ylegend+0)+0) * ppyunit + yhgt);
  PSshow((char *)legendtitle);
  if([plotParam shouldDrawLegendBox]) {
    PSsetlinewidth(0.0);
    PSrectstroke(legendbox.origin.x, legendbox.origin.y,
		 legendbox.size.width, legendbox.size.height);
  }
  drawingLegendLines = NO;
  [sender drawSymbols:sender :NO :NO];	/* legend symbols, linear axes always */

  return self;
}

- clear:sender
{
  NXEraseRect(&bounds);
  return self;
}

/*
 * This routine assumes it is called with xmin != xmax and ymin != ymax.
 * Bad things may happen if this is not the case.
 * The input parameters are assumed to be in pixel coordinates.
 */
- drawTicMarks:(float)xmin :(float)xmax :(float)ymin :(float)ymax
{
  float pattern0[] = {};	/* solid      */
  float pattern2[] = {1.0, 3.0}; /* dot        */
  float xinc_unscaled = [plotParam provideXinc];
  float yinc_unscaled = [plotParam provideYinc];
  /* It is useful in some fairly extreme cases to have the increments
   * not in pixel coordinates (otherwise can get "bad" labels).
   */
  char ticlabel[32];
  id ticfont, ticfont1;
  float x, y, ticloc_rat;
  BOOL drawGrid = [plotParam shouldDrawGrid];
  BOOL xaxislog = [plotParam xaxisLog];
  BOOL yaxislog = [plotParam yaxisLog];
  BOOL drawMinorTics = [plotParam shouldDrawMinorTicMarks];
  float  ticmarklen = (float)[plotParam provideTicMarkDir];
  int  nmin, nmax, j, i;
  float  ticloc, xwid, yhgt=12.0, yhgt1;
  float  first;
  int    nlabels;
  int    axformat[3];

  if ([plotParam shouldChangeTicLabelFont]) {
    newTicLabelFont = [theFontManager convertFont:[theFontManager selFont]];
  }

  yhgt = [newTicLabelFont pointSize];
  if (yhgt==0) {
    ticfont = [Font newFont:"Helvetica" size:12.0 style:0 matrix:NX_IDENTITYMATRIX];
    ticfont1 =
      [Font newFont:"Helvetica" size:10.0 style:0 matrix:NX_IDENTITYMATRIX];
    yhgt = 12.0;
  }
  else {
    ticfont = [Font newFont:[newTicLabelFont name] 
	            size:[newTicLabelFont pointSize]
	            style:[newTicLabelFont style]
	            matrix:NX_IDENTITYMATRIX];

    yhgt1 = (yhgt >= 10.0? yhgt - 2.0 : 8.0);
    ticfont1 = [Font newFont:[newTicLabelFont name] 
	             size:yhgt1
	             style:[newTicLabelFont style]
	             matrix:NX_IDENTITYMATRIX];
  }

  /* get tic font initialized */
  [ticfont set];

  PSnewpath();
  PSsetlinewidth(0.0);
  if (xaxislog) {		/* x-axis is logarithmic */
    nmin = (int)floor((double)(xmin/ppxunit));
    nmax = (int)ceil((double)(xmax/ppxunit));
    for (j=nmin; j<=nmax; j++) {
      if ( (float)j * ppxunit >= xmin &&  (float)j * ppxunit <= xmax ) {
	if (drawGrid) {
	  PSmoveto((float)j * ppxunit, ymin);
	  PSsetdash(pattern2, 2, 0.0);
	  PSrlineto(0.0, ABS(ymax-ymin));
	  PSstroke();
	}
	PSmoveto((float)j * ppxunit, ymin - ticmarklen*6.0); /* big tic mark */
	PSsetdash(pattern0, 0, 0.0);
	PSrlineto(0.0, ticmarklen*6.0);
	PSstroke();
	ticloc_rat = yhgt/12.0;
	PSmoveto((float)j * ppxunit - ticloc_rat*8.0, ymin - ticloc_rat*24.0);
	PSshow("10");
	[ticfont1 set];
	PSmoveto((float)j * ppxunit + ticloc_rat*4.0, ymin - ticloc_rat*16.0);
	sprintf(ticlabel, "%-5d", j);
	PSshow(ticlabel);
	[ticfont set];
      }
      if (drawMinorTics) {
	for (i=2; i<=9; i++) {
	  ticloc = (float)j * ppxunit + ppxunit*(float)log10((double)i);
	  if ( ticloc>xmin && ticloc<xmax ) {
	    PSmoveto(ticloc, ymin - ticmarklen*4.0); /* small tic mark */
	    PSrlineto(0.0, ticmarklen*4.0);
	    PSstroke();
	  }
	}
      }
    }
  }
  else {			/* x-axis is linear */
    count_labels(&nlabels, &first, xmin/ppxunit, xinc_unscaled, xmax/ppxunit);
    autoformat(xmin/ppxunit, xinc_unscaled, xmax/ppxunit, &axformat[0]);
    for (i=0; i<nlabels; i++) {
      x = (first + (xinc_unscaled)*(float)i) * ppxunit;
      if (drawGrid) {
	PSmoveto(x, ymin);
	PSsetdash(pattern2, 2, 0.0);
	PSrlineto(0.0, ABS(ymax-ymin));
	PSstroke();
      }
      PSmoveto(x, ymin - ticmarklen*4.0);
      PSsetdash(pattern0, 0, 0.0);
      PSrlineto(0.0, ticmarklen*4.0);
      PSstroke();
      handformat(x/ppxunit, ticlabel, &axformat[0]);
      xwid = [ticfont getWidthOf:ticlabel];
      PSmoveto(x - xwid/2.0, ymin - yhgt - 5.0);
      PSshow(ticlabel);
      if (drawMinorTics) {
	if (i < nlabels -1) {
	  for (j=1; j<=9; j++) {
	    PSmoveto(x + ((xinc_unscaled/10.0)*(float)j)*ppxunit,
		     ymin - ticmarklen*2.0);
	    PSrlineto(0.0, ticmarklen*2.0);
	    PSstroke();
	  }
	}
      }
    }
  }
  if (yaxislog) {		/* y-axis is logarithmic */
    nmin = (int)floor((double)(ymin/ppyunit));
    nmax = (int)ceil((double)(ymax/ppyunit));
    for (j=nmin; j<=nmax; j++) {
      if ( (float)j * ppyunit >= ymin &&  (float)j * ppyunit <= ymax ) {
	if (drawGrid) {
	  PSmoveto(xmin, (float)j * ppyunit);
	  PSsetdash(pattern2, 2, 0.0);
	  PSrlineto(ABS(xmax-xmin), 0.0);
	  PSstroke();
	}
	PSmoveto(xmin - ticmarklen*6.0, (float)j * ppyunit); /* big tic mark */
	PSsetdash(pattern0, 0, 0.0);
	PSrlineto(ticmarklen*6.0, 0.0);
	PSstroke();
	ticloc_rat = yhgt/12.0;
	PSmoveto(xmin - ticloc_rat*40.0, (float)j * ppyunit - ticloc_rat*7.0);
	PSshow("10");
	[ticfont1 set];
	PSmoveto(xmin - ticloc_rat*24.0, (float)j * ppyunit - ticloc_rat*1.0);
	sprintf(ticlabel, "%-5d", j);
	PSshow(ticlabel);
	[ticfont set];
      }
      if (drawMinorTics) {
	for (i=2; i<=9; i++) {
	  ticloc = (float)j * ppyunit + ppyunit*(float)log10((double)i);
	  if (ticloc>ymin && ticloc<ymax) {
	    PSmoveto(xmin - ticmarklen*4.0, ticloc); /* small tic mark */
	    PSrlineto(ticmarklen*4.0, 0.0);
	    PSstroke();
	  }
	}
      }
    }
  }
  else {			/* y-axis is linear */
    count_labels(&nlabels, &first, ymin/ppyunit, yinc_unscaled, ymax/ppyunit);
    autoformat(ymin/ppyunit, yinc_unscaled, ymax/ppyunit, &axformat[0]);
    for (i=0; i<nlabels; i++) {
      y = (first + (yinc_unscaled)*(float)i) * ppyunit;
      if (drawGrid) {
	PSmoveto(xmin, y);
	PSsetdash(pattern2, 2, 0.0);
	PSrlineto(ABS(xmax-xmin), 0.0);
	PSstroke();
      }
      PSmoveto(xmin - ticmarklen*4.0, y);
      PSsetdash(pattern0, 0, 0.0);
      PSrlineto(ticmarklen*4.0, 0.0);
      PSstroke();
      handformat(y/ppyunit, ticlabel, &axformat[0]);
      xwid = [ticfont getWidthOf:ticlabel];
      PSmoveto(xmin - xwid - 10.0, y + 2.0 - yhgt/2.0);
      PSshow(ticlabel);
      if (drawMinorTics) {
	if (i < nlabels -1 ) {
	  for (j=1; j<=9; j++) {
	    PSmoveto(xmin - ticmarklen*2.0,
		     y + ((yinc_unscaled/10.0)*(float)j)*ppyunit);
	    PSrlineto(ticmarklen*2.0, 0.0);
	    PSstroke();
	  }
	}
      }
    }
  }
  return self;
}

- drawSelf: (const NXRect *)rects :(int)rectCount
{
  float  xmin = [plotParam provideXmin];
  float  xmax = [plotParam provideXmax];
  float  ymin = [plotParam provideYmin];
  float  ymax = [plotParam provideYmax];

  [self initPlot:self];

  if ([plotParam nFiles] == 0) return self; /* no data */

  PSgsave();

  PStranslate(XOFFSET, YOFFSET);

  if ([plotParam xaxisLog]) {	/* x-axis is logarithmic */
    ppxunit = 0.9*(bounds.size.width-XOFFSET)
      /(float)log10((double)(xmax/xmin));
    xmin = (float)log10((double)xmin) * ppxunit;
    xmax = (float)log10((double)xmax) * ppxunit;
  }
  else {			/* x-axis is linear */
    ppxunit = 0.9*(bounds.size.width-XOFFSET)/(xmax-xmin);
    xmin = xmin*ppxunit;	/* drawing is all in pixel coordinates */
    xmax = xmax*ppxunit;
  }
  if ([plotParam yaxisLog]) {	/* y-axis is logarithmic */
    ppyunit = 0.9*(bounds.size.height-YOFFSET)
      /(float)log10((double)(ymax/ymin));
    ymin = (float)log10((double)ymin) * ppyunit;
    ymax = (float)log10((double)ymax) * ppyunit;
  }
  else {			/* y-axis is linear */
    ppyunit = 0.9*(bounds.size.height-YOFFSET)/(ymax-ymin);
    ymin = ymin*ppyunit;
    ymax = ymax*ppyunit;
  }
  PStranslate(-xmin, -ymin);
  PSnewpath();			/* draw bounding box */
  PSmoveto(xmin, ymin);
  PSlineto(xmax, ymin);
  PSlineto(xmax, ymax);
  PSlineto(xmin, ymax);
  PSclosepath();
  PSstroke();			/* finish bounding box */

  if ([plotParam shouldDrawAxes]) {
    PSnewpath();
    PSmoveto(0.0, ymin);
    PSlineto(0.0, ymax);
    PSstroke();
    PSmoveto(xmin, 0.0);
    PSlineto(xmax, 0.0);
    PSstroke();
  }

  [self drawTicMarks:xmin :xmax :ymin :ymax]; /* do this before clipping */

  /* MIN and MAX below in case xmin > xmax  and/or  ymin > ymax. */
  PSrectclip(MIN(xmin,xmax), MIN(ymin,ymax), ABS(xmax-xmin), ABS(ymax-ymin));

  [self drawLines:plotParam :[plotParam xaxisLog] :[plotParam yaxisLog]];
  [self drawSymbols:plotParam :[plotParam xaxisLog] :[plotParam yaxisLog]];

  PSgrestore();
  if ([plotParam shouldDrawLegend]) {
    [self initLegend:self];
    [self drawLegend:self];
  }
  return self;
}

- doPrinting:sender
{

  [ [NXApp printInfo] setMarginLeft:72.0 right:72.0 top:72.0 bottom:72.0 ];

  if (bounds.size.height > bounds.size.width) { /* portrait mode */
    if (bounds.size.height/bounds.size.width > 9.0/6.5) {
      [ [NXApp printInfo] setScalingFactor: 9.0*72.0/bounds.size.height];
    }
    else {
      [ [NXApp printInfo] setScalingFactor: 6.5*72.0/bounds.size.width];
    }
    [ [NXApp printInfo] setOrientation:NX_PORTRAIT andAdjust:YES ];
  }
  else {			/* landscape mode */
    if (bounds.size.width/bounds.size.height > 9.0/6.5) {
      [ [NXApp printInfo] setScalingFactor: 9.0*72.0/bounds.size.width];
    }
    else {
      [ [NXApp printInfo] setScalingFactor: 6.5*72.0/bounds.size.height];
    }
    [ [NXApp printInfo] setOrientation:NX_LANDSCAPE andAdjust:YES ];
  }

  [self printPSCode:sender];
  return self;
}

- mouseDown:(NXEvent *)e
/*
 * This code taken from the Mandelbrot example in /NextDeveloper (and modified).
 * We implement the mouseDown method so the user can sweep out a section of
 * the view and select that as the current window in which to view the curve(s).
 */
{
  int looping = YES;
  int oldMask;
  NXRect bbox;
  NXPoint startPoint, currPoint;
  float xmin, xmax, ymin, ymax;
  BOOL zooming = [plotParam doZoom];
  BOOL xaxislog = [plotParam xaxisLog];
  BOOL yaxislog = [plotParam yaxisLog];
  
  if (zooming) {

    if (xaxislog) {
      xmin = (float)log10((double)[plotParam provideXmin]) * ppxunit;
      xmax = (float)log10((double)[plotParam provideXmax]) * ppxunit;
    }
    else {
      xmin = [plotParam provideXmin] * ppxunit;
      xmax = [plotParam provideXmax] * ppxunit;
    }
    if (yaxislog) {
      ymin = (float)log10((double)[plotParam provideYmin]) * ppyunit;
      ymax = (float)log10((double)[plotParam provideYmax]) * ppyunit;
    }
    else {
      ymin = [plotParam provideYmin] * ppyunit;
      ymax = [plotParam provideYmax] * ppyunit;
    }
  
    oldMask =  [window addToEventMask:NX_MOUSEDRAGGEDMASK];
    startPoint = e->location;
    [self convertPoint:&startPoint fromView:nil];
    NXSetRect(&bbox,startPoint.x,startPoint.y,0.0,0.0);
    [self lockFocus];
    while (looping) {
      e=[NXApp getNextEvent:NX_MOUSEUPMASK | NX_MOUSEDRAGGEDMASK];
      currPoint = e->location;
      [self convertPoint:&currPoint fromView:nil];
      bbox.size.width = (currPoint.x - startPoint.x);
      bbox.size.height = (currPoint.y - startPoint.y);
      /* Normalize bbox to always have positive width and height */
      if (bbox.size.width < 0) {
	bbox.size.width = -bbox.size.width;
	bbox.origin.x   = startPoint.x - bbox.size.width;
      }
      if (bbox.size.height < 0) {
	bbox.size.height = -bbox.size.height;
	bbox.origin.y    = startPoint.y - bbox.size.height;
      }

      PSnewinstance();
      if (looping = (e->type == NX_MOUSEDRAGGED)) {
	PSsetinstance(YES);
	PSsetgray(NX_BLACK);
	NXFrameRect(&bbox);
	PSsetinstance(NO);
      }
    }
    [self unlockFocus];
    [window setEventMask:oldMask];
    if ((bbox.size.width > 0) && (bbox.size.height > 0)) {
      /* At this point, bbox is in window coordinates.  Convert to curve
       * coordinates based on this view's coordinates and the bounding box.
       */
      xmin = xmin + (bbox.origin.x - XOFFSET);
      xmax = xmin + bbox.size.width;
      ymin = ymin + (bbox.origin.y - YOFFSET);
      ymax = ymin + bbox.size.height;

      if (xaxislog) {
	[plotParam resetXmin:(float)pow((double)10.0, (double)(xmin/ppxunit))];
	[plotParam resetXmax:(float)pow((double)10.0, (double)(xmax/ppxunit))];
      }
      else {
	[plotParam resetXmin:xmin/ppxunit];
	[plotParam resetXmax:xmax/ppxunit];
      }
      if (yaxislog) {
	[plotParam resetYmin:(float)pow((double)10.0, (double)(ymin/ppyunit))];
	[plotParam resetYmax:(float)pow((double)10.0, (double)(ymax/ppyunit))];
      }
      else {
	[plotParam resetYmin:ymin/ppyunit];
	[plotParam resetYmax:ymax/ppyunit];
      }

      /*  Call [self display] to force current values of xmin/xmax/ymin/ymax
       *  to take effect (otherwise xmin, etc., get incremented too many times).
       */
      [plotParam drawPlotButton:1];
      [self display];
      [plotParam drawPlotButton:0];
    }
  }
  else if ([plotParam shouldMoveLegend]) {

    oldMask =  [window addToEventMask:NX_MOUSEDRAGGEDMASK];
    startPoint = e->location;
    [self convertPoint:&startPoint fromView:nil];
    NXSetRect(&bbox,startPoint.x,startPoint.y,
	      legendbox.size.width,legendbox.size.height);
    [self lockFocus];
    while (looping) {
      e=[NXApp getNextEvent:NX_MOUSEUPMASK | NX_MOUSEDRAGGEDMASK];
      currPoint = e->location;
      [self convertPoint:&currPoint fromView:nil];
      bbox.origin.x = currPoint.x;
      bbox.origin.y = currPoint.y;
      PSnewinstance();
      if (looping = (e->type == NX_MOUSEDRAGGED)) {
	PSsetinstance(YES);
	PSsetgray(NX_BLACK);
	NXFrameRect(&bbox);
	PSsetinstance(NO);
      }
    }
    [self unlockFocus];
    [window setEventMask:oldMask];
    /*
     * At this point, bbox is in window coordinates. 
     */
    legendbox.origin.x = bbox.origin.x;
    legendbox.origin.y = bbox.origin.y;

    /*  Call [self display] to give immediate feedback on the legend location  */
    [plotParam drawPlotButton:1];
    [self display];
    [plotParam drawPlotButton:0];

  }

  return self;
}

- savePSCode:(char *)aFile
{
    NXStream	*psStream;

    psStream = NXOpenMemory(NULL, 0, NX_WRITEONLY);
    if (!psStream)  {
      return self;
    }
    [self getBounds:&bounds];
    [self copyPSCodeInside:&bounds to:psStream];
	   
    NXFlush(psStream);
    NXSaveToFile(psStream, aFile);
    NXCloseMemory(psStream, NX_FREEBUFFER);

    return self;
}

@end
