/*
 * Copyright 1990, John G. Myers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#import "InfoDistributor.h"
#import <appkit/Window.h>
#import <appkit/Panel.h>
#import <appkit/ScrollView.h>
#import <appkit/Text.h>
#import <appkit/TextField.h>
#import "EtermApp.h"
#import "EtermView.h"

@implementation InfoDistributor

static int inited = 0;

+ new
{
    self = [super new];
    return self;
}

- setVersionNo:anObject
{
    [anObject setStringValue:"Version 2.1"];
    return self;
}

- showInfo:sender
{
    if (!inited) {
	inited++;
	[NXApp loadNibSection:"infoDistributor.nib" owner:self];
    }
    [infoPanel makeKeyAndOrderFront:sender];
    return self;
}

- showHelp:(const char *)text;
{
    NXStream *stream=NXOpenMemory(text,strlen(text),NX_READONLY);

    if (!inited) {
	inited++;
	[NXApp loadNibSection:"infoDistributor.nib" owner:self];
    }

    [[helpText docView] readRichText:stream];
    [[helpText window] makeKeyAndOrderFront:self];

    NXCloseMemory(stream, NX_SAVEBUFFER);
    return self;
}

- helpBasics:sender
{
    extern const char * const basicshelp;

    [self showHelp:basicshelp];
    return self;
}

- helpBugs:sender
{
    extern const char * const bugshelp;

    [self showHelp:bugshelp];
    return self;
}

- helpDefaults:sender
{
    extern const char * const defaultshelp;

    [self showHelp:defaultshelp];
    return self;
}

- helpMouse:sender
{
    extern const char * const mousehelp;
    extern const char * const mouseinstallhelp;

    if ([[NXApp etermView] eventChannel]) {
	[self showHelp:mousehelp];
    }
    else {
	[self showHelp:mouseinstallhelp];
    }
    return self;
}

- helpCopying:sender
{
    extern const char * const copyinghelp;

    [self showHelp:copyinghelp];
    return self;
}

@end
