/* File: HashFile.h - db(3) to HashTable bridge
 *
 * By: Christopher Lane
 * Symbolic Systems Resources Group
 * Knowledge Systems Laboratory
 * Stanford University
 *
 * Date: 6 August 1990
 *
 * Copyright: 1990 by The Leland Stanford Junior University.  This program
 * may be distributed without restriction for non-commercial use.
 */

#import <stdio.h>
#import <db/db.h>
#import <objc/HashTable.h>

@interface HashFile : HashTable
{
	Database *db;
	Data d;
	char *filename;
	BOOL readOnly;
	NXStream *stream;
	long offset;
}

+ newFromFile:(const char *) name;
+ newFromFile:(const char *) name keyDesc:(const char *) aKeyDesc;
+ newFromFile:(const char *) name keyDesc:(const char *) aKeyDesc valueDesc:(const char *) aValueDesc;

+ (BOOL) isHashFile:(const char *) name;

- free;	
//- freeObjects;
//- freeKeys:(void (*) (void *)) keyFunc values:(void (*) (void *)) valueFunc;  
- empty;
//- copy;

- (unsigned) count;
- (BOOL) isKey:(const void *) aKey;
- (void *) valueForKey:(const void *) aKey;
- (void *) insertKey:(const void *) aKey value:(void *) aValue;
- (void *) removeKey:(const void *) aKey;

- (NXHashState) initState;
- (BOOL) nextState:(NXHashState *) aState key:(const void **) aKey value:(void **) aValue;

//- write:(NXTypedStream *) stream; 
//- read:(NXTypedStream *) stream;

- (void) _keyCvtIn:(const void *) aKey;
- (void) _valueCvtIn:(const void *) aValue;
- (void) _datumCvtIn:(Datum *) aDatum from:(const void *) aBuffer using:(const char *) aDesc;

- (void *) _keyCvtOut;
- (void *) _valueCvtOut;
- (void *) _datumCvtOut:(Datum *) aDatum using:(const char *) aDesc;

@end
