#include <netinfo/ni.h>
#include <stdio.h>
#include "quota.h"

main(argc,argv)
int argc;
char *argv[];
{
	ni_status rc, ni_printdir();
	void *myhandle;
	ni_namelist mynamelist;
	ni_proplist  myproplist;
	ni_property myproperty;
	ni_entrylist myentrylist;
	ni_id myid;
	ni_index myindex;
	char str[256], domain[16], user[16], quota[QSIZE], *getpass();
	int i, j, q;
	int userp, domainp, quotap;

	userp = 0;
	quotap = 0;
	domainp = 0;
	
	for (i = 1; i < argc; i++) {
		if (argv[i][0] == '-') switch(argv[i][1]) {
			case 'd': strcpy(domain,argv[++i]); domainp = 1; break;
			case 'u': strcpy(user,argv[++i]); userp = 1; break;
			case 'q': strcpy(quota,argv[++i]); quotap = 1; break;
			default: usage(argv[0]);
		}
		else {
			if (userp == 0) {
				strcpy(user,argv[i]);
				userp = 1;
			}
			else {
				strcpy(quota,argv[i]);
				quotap = 1;
			}
		}
	}
	
	if (domainp == 0) strcpy(domain,DEFAULTDOMAIN);
	if (userp == 0) usage(argv[0]);
	if (quotap == 0) usage(argv[0]);

	/* open netinfo */
	rc = ni_open(NULL, domain, &myhandle);
	if (rc) errexit("ni_open",rc);
	
	if (getuid() != 0) {
		rc = ni_setpassword(myhandle,getpass("Password: "));
		if (rc) errexit("ni_setpassword",rc);
		rc = ni_setuser(myhandle,"root");
		if (rc) errexit("ni_setuser",rc);
	}
	
	sprintf(str,"/users/%s",user);
	/* open the user's home directory */
	rc = ni_pathsearch(myhandle, &myid, str);
	if (rc) errexit("ni_pathsearch",rc);
	
	/* look up the DQPROP property */
	rc = ni_lookupprop(myhandle,&myid,DQPROP,&mynamelist);
	sprintf(str,"%s",argv[2]);
	
	if (rc == NI_NOPROP) {
		printf("creating new %s property for /users/%s\n",DQPROP,user);
		myindex = NI_INDEX_NULL;
		myproperty.nip_name = malloc(strlen(DQPROP) + 1);
		strcpy(myproperty.nip_name,DQPROP);
		myproperty.nip_val.ni_namelist_len = 1;
		myproperty.nip_val.ni_namelist_val = malloc(sizeof(char *));
		myproperty.nip_val.ni_namelist_val[0] = malloc(QSIZE);
		strcpy(myproperty.nip_val.ni_namelist_val[0],quota);
		rc = ni_createprop(myhandle,&myid,myproperty,myindex);
		if (rc) errexit("ni_createprop",rc);
	}
	else {
		rc = ni_read(myhandle,&myid,&myproplist);
		if (rc) errexit("ni_read",rc);
		myindex = ni_proplist_match(myproplist,DQPROP,NULL);
		mynamelist.ni_namelist_len = 1;
		mynamelist.ni_namelist_val = malloc(sizeof(char *));
		mynamelist.ni_namelist_val[0] = malloc(QSIZE);
		strcpy(mynamelist.ni_namelist_val[0],quota);
		rc = ni_writeprop(myhandle,&myid,myindex,mynamelist);
		if (rc) errexit("ni_writeprop",rc);
	}
	
	ni_free(myhandle);
	exit(0);
}


errexit(s,rc)
char *s;
ni_status rc;
{
	fprintf(stderr,"%s: %s\n",s,ni_error(rc));
	exit(1);
}

usage(n)
char *n;
{
	fprintf(stderr,"usage: %s user %s\n",n,DQPROP);
	exit(1);
}
		
