
/* Generated by Interface Builder */

#import "MonitorView.h"
#import <appkit/Control.h>
#import "Animator.h"
#import <appkit/Application.h>
#import <dpsclient/wraps.h>
#import <appkit/Window.h>
#import <appkit/nextstd.h>
#import <appkit/Panel.h>

#import <sys/file.h>
#import <sys/dk.h>
#import <nlist.h>
#import <syslog.h>

@implementation MonitorView

#define RANDFLOAT() (((float)(random()%1024))/(1024.0))
extern void srandom( int i);
extern int random( void);

static int kmem;			// the kmem file handle.
static struct nlist nl[]={{{"_cp_time"}, 0, 0, 0, 0}, {{""}, 0, 0, 0, 0}};
static long ready=0;			// set to 1 when ready.

int getStats( struct stats *s)		// get current stats to s.
{
  long cp_time[ CPUSTATES];
  if( lseek( kmem, nl[ 0].n_value, L_SET)!=nl[ 0].n_value)		// go find our data.
    {
      syslog( LOG_WARNING, "TimeMon: Unable to seek in /dev/kmem\n");
      return 1;
    }
  if( read( kmem, cp_time, sizeof( cp_time))!=sizeof( cp_time))		// get the data.
    {
      syslog( LOG_WARNING, "TimeMon: Unable to read from /dev/kmem\n");
      return 1;
    }
  s->user=cp_time[ CP_USER];			// store into the structure.
  s->nice=cp_time[ CP_NICE];
  s->sys=cp_time[ CP_SYS];
  s->idle=cp_time[ CP_IDLE];
  s->total=s->user+s->nice+s->sys+s->idle;	// calculate the total.
  return 0;
}
  
int initStats( struct stats *s)		// ready to read stats, and get them to s.
{
  if( ready)				// already inited!
    return getStats( s);
  if( nlist( "/vmunix", nl))		// find _cp_time in the kernel.
    {
      syslog( LOG_WARNING, "TimeMon: Cannot nlist /vmunix\n");
      return 1;
    }
  kmem=open( "/dev/kmem", O_RDONLY);	// try to open kernel memory.
  if( kmem<0)
    {
      syslog( LOG_WARNING, "TimeMon: Cannot open kmem\n");
      return 1;
    }
  return getStats( s);
}

+ newFrame:(NXRect *)r
{
  self = [super newFrame:r];
  if( initStats( &oldTimes))		// set us up!
    {
      NXRunAlertPanel( "Not setuid", "This program has not been installed correctly.  Contact your system administrator.", "Ok", NULL, NULL);
      exit( 1);
    }
  system=0;
  user=0;
  nice=0;
  idle=1.0;
  return self;
}

- setTimeSlider:anObject
{
    timeSlider = anObject;
    return self;
}
- setTimeText:anObject
{
    timeText = anObject;
    return self;
}

- setAnimator:anObject
{
    if( animator==anObject)			// is this the old animator?
      return self;
    animator = anObject;
    [animator setTiming:0.5];
    [animator setThreshold:NX_MODALRESPTHRESHOLD];
    [animator setTarget:self];
    [animator start:self];
    return self;
}

- animator
{
  return animator;
}

- takeTimingFrom:sender
{
    float val=[sender floatValue];
    float value=(int)(val*4);			// set text version in increments of .25
    value/=4;
    [animator setTiming:value];
    [timeSlider setFloatValue:val];
    [timeText setFloatValue:value];
    return self;
}

- drawSelf:(NXRect *)r :(int)count
{
  NXRect rect={{0.0, 0.0}, {system, 1.0}};		// draw the awesome gauge . . .
  [self setDrawSize:1.0 :1.0];
  PSsetgray( NX_WHITE);
  NXRectFill( &bounds);
  PSsetgray( NX_BLACK);
  NXRectFill( &rect);
  rect.origin.x=system;
  rect.size.width=user;
  PSsetgray( NX_DKGRAY);
  NXRectFill( &rect);
  rect.origin.x+=user;
  rect.size.width=nice;
  PSsetgray( NX_LTGRAY);
  NXRectFill( &rect);
  [[self window] flushWindow];
  return self;
}

- animate:sender
{
  oldTimes=newTimes;			// copy the old times,
  if( getStats( &newTimes))		// and get the new.
    exit( 1);
  total=newTimes.total-oldTimes.total;	// get the differences (times are absolute.
  system=newTimes.sys-oldTimes.sys;
  user=newTimes.user-oldTimes.user;
  idle=newTimes.idle-oldTimes.idle;
  nice=newTimes.nice-oldTimes.nice;
  system/=total;			// and scale by total.
  user/=total;
  idle/=total;
  nice/=total;
  [self display];
  return self;
}

- windowWillResize:sender toSize:(NXSize *)f
{
  f->height=52.0;			// we refuse to resize vertically.
  return self;
}
@end
