.\" 
.\" Mach Operating System
.\" Copyright (c) 1991,1990 Carnegie Mellon University
.\" All Rights Reserved.
.\" 
.\" Permission to use, copy, modify and distribute this software and its
.\" documentation is hereby granted, provided that both the copyright
.\" notice and this permission notice appear in all copies of the
.\" software, derivative works or modified versions, and any portions
.\" thereof, and that both notices appear in supporting documentation.
.\" 
.\" CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
.\" CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
.\" ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
.\" 
.\" Carnegie Mellon requests users of this software to return to
.\" 
.\"  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
.\"  School of Computer Science
.\"  Carnegie Mellon University
.\"  Pittsburgh PA 15213-3890
.\" 
.\" any improvements or extensions that they make and grant Carnegie Mellon
.\" the rights to redistribute these changes.
.\" 
.\" 
.\" HISTORY
.\" $Log:	mach_port_deallocate.man,v $
.\" Revision 2.2  93/05/10  19:33:19  rvb
.\" 	updated
.\" 	[93/04/21  16:01:44  lli]
.\" 
.\" Revision 2.5  91/12/11  08:42:46  jsb
.\" 	Changed <mach/mach.h> to <mach.h>.
.\" 	[91/11/25  10:55:16  rpd]
.\" 
.\" Revision 2.4  91/05/14  17:06:00  mrt
.\" 	Correcting copyright
.\" 
.\" Revision 2.3  91/02/14  14:11:04  mrt
.\" 	Changed to new Mach copyright
.\" 	[91/02/12  18:11:15  mrt]
.\" 
.\" Revision 2.2  90/08/07  18:36:10  rpd
.\" 	Created.
.\" 
.TH mach_port_deallocate 2 9/19/86
.CM 4
.SH NAME
.nf
mach_port_deallocate \-  releases a user reference for a right
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

kern_return_t
mach_port_deallocate(task, name)
	mach_port_t task;
	mach_port_t name;
.fi
.ft P
.SH ARGUMENTS
.TP 12
.B
task
The task holding the right.
.TP 12
.B
name
The task's name for the right.
.SH DESCRIPTION
\fBmach_port_deallocate\fR releases a user reference for a right.
It allows a task to release a user reference for a send or send-once
right without failing if the port has died and the right is now
actually a dead name.

If \fBname\fR denotes a dead name, send right, or send-once right,
then the right loses one user reference.  If it only had
one user reference, then the right is destroyed.
.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
The call succeeded.
.TP 25
KERN_INVALID_TASK
\fBtask\fR was invalid.
.TP 25
KERN_INVALID_NAME
\fBname\fR did not denote a right.
.TP 25
KERN_INVALID_RIGHT
\fBname\fR denoted an invalid right.
.PP
The \fBmach_port_deallocate\fR call is actually an RPC to \fBtask\fR,
normally a send right for a task port, but potentially any send right.
In addition to the normal diagnostic
return codes from the call's server (normally the kernel),
the call may return \fBmach_msg(2)\fR return codes.
.SH SEE ALSO
mach_port_mod_refs(2), mach_port_destroy(2).
