.\" 
.\" Mach Operating System
.\" Copyright (c) 1991,1990 Carnegie Mellon University
.\" All Rights Reserved.
.\" 
.\" Permission to use, copy, modify and distribute this software and its
.\" documentation is hereby granted, provided that both the copyright
.\" notice and this permission notice appear in all copies of the
.\" software, derivative works or modified versions, and any portions
.\" thereof, and that both notices appear in supporting documentation.
.\" 
.\" CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
.\" CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
.\" ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
.\" 
.\" Carnegie Mellon requests users of this software to return to
.\" 
.\"  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
.\"  School of Computer Science
.\"  Carnegie Mellon University
.\"  Pittsburgh PA 15213-3890
.\" 
.\" any improvements or extensions that they make and grant Carnegie Mellon
.\" the rights to redistribute these changes.
.\" 
.\" 
.\" HISTORY
.\" $Log:	processor_set_info.man,v $
.\" Revision 2.5  93/03/18  15:14:23  mrt
.\" 	corrected types
.\" 	[93/03/11  12:54:02  lli]
.\" 
.\" Revision 2.4  91/05/14  17:11:39  mrt
.\" 	Correcting copyright
.\" 
.\" Revision 2.3  91/02/14  14:14:03  mrt
.\" 	Changed to new Mach copyright
.\" 	[91/02/12  18:14:51  mrt]
.\" 
.\" Revision 2.2  90/08/07  18:42:42  rpd
.\" 	Created.
.\" 
.TH processor_set_info 2 8/13/89
.CM 4
.SH NAME
.nf
processor_set_info   \-   gets information about a processor set
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

.nf
.ft B
/* the definition of processor_set_info_ from mach/processor_info.h  */

typedef	int	*processor_set_info_t;	/* variable length array of int */

/* one interpretation of info is */

   struct processor_set_basic_info {
	int		processor_count;	/* number of processors */
	int		task_count;		/* number of tasks */
	int		thread_count;		/* number of threads */
	int		load_average;		/* scaled load average */
	int		mach_factor;		/* scaled mach factor */
   };
typedef struct processor_set_basic_info		*processor_set_basic_info_t;

/* another interpretation of info is */

struct processor_set_sched_info {
        int             policies;       /* allowed policies */
        int             max_priority;   /* max priority for new threads */
};

typedef struct processor_set_sched_info *processor_set_sched_info_t;


kern_return_t
processor_set_info(processor_set, flavor, host, processor_set_info,
    processor_set_infoCnt)
	mach_port_t 		processor_set;
	int 			flavor;
	mach_port_t		*host;
	processor_set_info_t 	processor_set_info;	/* in and out */
        mach_msg_type_number_t 	*processor_set_infoCnt;	/* in and out */



.fi
.ft P
.SH ARGUMENTS
.TP 15
.B
processor_set
The processor_set for which information is to be obtained
.TP 15
.B
flavor
The type of information that is wanted.
.TP 15
.B
host
The host on which the processor set resides.  This is the 
non-privileged host port.
.TP 15
.B
processor_set_info
Information about the processor set specified by 
.B processor_set.
.TP 15
.B
processor_set_infoCnt
Size of the info structure. Should be
.B PROCESSOR_SET_BASIC_INFO_COUNT
for flavor 
.B PROCESSOR_SET_BASIC_INFO
, and 
.B PROCESSOR_SET_SCHED_INFO_COUNT
for flavor
.B PROCESSOR_SET_SCHED_INFO.

.SH DESCRIPTION

Returns the selected information array for a processor_set, as specified
by 
.B flavor.

.B processor_set_info

is an array of integers that is supplied
by the caller, and filled with specified information. 
.B processor_set_infoCnt
is supplied as the maximum number of integers in 
.B processor_set_info.
On return,
it contains the actual number of integers in  
.B processor_set_info.

Basic information is defined by 
.B PROCESSOR_SET_BASIC_INFO.
The size of this information is defined by 
.B PROCESSOR_SET_BASIC_INFO_COUNT.
The 
.B load_average
and 
.B mach_factor
arguments are scaled by the constant
.B LOAD_SCALE
(i.e. the integer value returned is the actual value 
multiplied by 
.B LOAD_SCALE.

Scheduling information is defined by 
.B PROCESSOR_SET_SCHED_INFO.
The size of this information is given by 
.B PROCESSOR_SET_SCHED_INFO_COUNT.
Some machines may define machine-dependent information flavors.

.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
The call succeeded.
.TP 25
KERN_INVALID_ARGUMENT
.B processor_set
is not a processor set or
.B flavor
is not recognized.
.TP 25
MIG_ARRAY_TOO_LARGE
Returned info array is too large for
.B processor_set_info.

.B processor_set_info

is filled as much as possible. 
.B processor_set_infoCnt
is set to the number of elements that would
be returned if there were enough room.

.SH BUGS
Availability limited.

.SH SEE ALSO
.B processor_set_create, processor_set_default, processor_assign,
.B task_assign, thread_assign





