/* 
 * Mach Operating System
 * Copyright (c) 1991,1990 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Software Distribution Coordinator   or   Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 * 
 * any improvements or extensions that they made and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */
/*
 * HISTORY
 * $Log:	bsd_special.c,v $
 * Revision 2.4  91/12/19  20:27:50  mrt
 * 	Updated to new copyright
 * 
 * Revision 2.3  90/09/27  13:54:07  rwd
 * 	Declare enxio_special.
 * 	[90/09/08            rwd]
 * 
 * Revision 2.2  90/09/08  00:15:53  rwd
 * 	Spilt out partially to machine dependant.
 * 	[90/07/20            rwd]
 * 
 */
/*
 *	File:	./bsd_special.c
 *	Author:	Joseph S. Barrera III, Randall W. Dean
 *
 *	Copyright (c) 1990 Joseph S. Barrera III, Randall W. Dean
 */

#include <mach.h>
#include <fnode.h>
#include <errno.h>
#include <ux_user.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <bsd_ioctl.h>

extern int tty_special();
extern int mem_special();
extern int log_special();
extern int pty_special();
extern int bdev_special();
extern int cmupty_special();
extern int enxio_special();

log_special(a,b,c)	{ return enxio_special(a,b,c); }
pty_special(a,b,c)	{ return enxio_special(a,b,c); }
cmupty_special(a,b,c)	{ return enxio_special(a,b,c); }

struct special_switch_struct {
	int (*routine)();
	char *name;
};

struct special_switch_struct special_switch[] =
{
#include <machine/conf.h>
};

#define	NSPECIAL	(sizeof(special_switch) / sizeof(*special_switch))

dev_special(fnp, fmt, dev)
	struct fnode **fnp;
	int fmt;
	dev_t dev;
{
	int maj;

	maj = major(dev);
	if (maj < 0 || maj >= NSPECIAL) {
		return enxio_special(fnp, fmt, dev);
	} else {
		register struct special_switch_struct *sw;
		sw = &special_switch[maj];
		return (*(sw->routine))(fnp, fmt, dev, sw->name);
	}
}
