/*
 * HISTORY
 * $Log:	mach3.h,v $
 * Revision 2.2  92/02/15  19:38:45  rpd
 * 	Initial checkin.
 * 	[92/02/15  19:04:00  rpd]
 * 
 */

/*
 * Common definitions for Gdb in Mach 3.0 systems 
 *
 * Included in machine depended mach specific files.
 *
 */

/* Mach globals and hooks */

#include <mach.h>

/* Task port of our debugged inferior. */

extern task_t inferior_task;

/* Thread port of the current thread in the inferior. */

extern thread_t current_thread;

/* Exception port connected to our debugged inferior task. */

extern mach_port_t inferior_exception_port;

/* What used to be our inferior's exception port */

extern mach_port_t inferior_old_exception_port;

/* interface to catch_exception_raise */

extern int stop_exception, stop_code, stop_subcode;

/* Did WE stop all of the other threads before we did the 
   task_resume?.  Used for single-stepping. */

extern boolean_t other_threads_suspended;

/* [un]restrict the exception port we're waiting on.  Used for 
   single-stepping. */

void set_exception_port(), clear_exception_port();

/* Get relevant ports when creating a new inferior */

#define CREATE_INFERIOR_HOOK(pid)	mach_create_inferior_hook(pid)

/* Stop waiting for the inferior to change state */

#define WAIT_HOOK(pid,w)	pid = mach_really_wait(&w);
