.\"
.\" Mach Operating System
.\" Copyright (c) 1991,1990 Carnegie Mellon University
.\" All Rights Reserved.
.\" 
.\" Permission to use, copy, modify and distribute this software and its
.\" documentation is hereby granted, provided that both the copyright
.\" notice and this permission notice appear in all copies of the
.\" software, derivative works or modified versions, and any portions
.\" thereof, and that both notices appear in supporting documentation.
.\" 
.\" CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS 
.\" CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
.\" ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
.\" 
.\" Carnegie Mellon requests users of this software to return to
.\" 
.\"  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
.\"  School of Computer Science
.\"  Carnegie Mellon University
.\"  Pittsburgh PA 15213-3890
.\" 
.\" any improvements or extensions that they make and grant Carnegie the
.\" rights to redistribute these changes.
.\"
.\" HISTORY
.\" $Log:	mcreate.man,v $
.\" Revision 2.2  92/01/22  23:04:38  rpd
.\" 	Moved to a separate directory.
.\" 	[92/01/22            rpd]
.\" 
.\" Revision 2.3  91/03/19  12:31:24  mrt
.\" 	Changed to new copyright
.\" 
.\" Revision 2.2  90/09/12  16:32:28  rpd
.\" 	Created.
.\" 	[90/09/07            rpd]
.\" 
.TH MCREATE 1 6/18/90
.CM 4
.SH NAME
mcreate \- create tasks, threads, and processor sets
.SH SYNOPSIS
\fBmcreate\fP [\fB-host\fP machine] [\fB-inherit\fP] [\fB-pset\fP|\fB-task\fP|\fB-thread\fP] id
.SH DESCRIPTION
\fImcreate(1)\fR creates a task, thread, or processor set and reports
the MachID of the created object.  When creating a task or thread, the
MachID argument specifies the parent task.  When creating a processor
set, the MachID argument specifies the host on which to create the
processor set.
.PP
\fImcreate\fR must run as root or a member of group kmem
to gain access to the target objects.
.PP
\fImcreate\fP interprets the following options:
.TP 8
.B \-host \fImachine\fR
Directs the inquiry to the \fImachid(1)\fR server running
on the specified machine.
.TP 8
.B \-task
Create a task.  The specified id is the task's parent task.
.TP 8
.B \-inherit
When creating a task, inherit memory from the parent task.
.TP 8
.B \-thread
Create a thread.  The specified id is the thread's task.
.TP 8
.B \-pset
Create a processor set.  The specified id is the processor set's host.
.SH "SEE ALSO"
ms(1), massign(1), machid(1), task_create(2), thread_create(2),
processor_set_create(2).
