#include "io.h"
#define EXPORT_BOOLEAN
#include <mach/boolean.h>
#include <mach/kern_return.h>
#include <mach/message.h>
#include <mach/notify.h>
#include <mach/mach_types.h>
#include <mach/mig_errors.h>
#include <mach/msg_type.h>
#ifndef	KERNEL
#include <strings.h>
#endif	KERNEL
/* LINTLIBRARY */

extern mach_port_t mig_get_reply_port();
extern void mig_dealloc_reply_port();

#ifndef	mig_internal
#define	mig_internal	static
#endif

#ifndef	mig_external
#define mig_external
#endif

#ifndef	TypeCheck
#define	TypeCheck 1
#endif

#ifndef	UseExternRCSId
#ifdef	hc
#define	UseExternRCSId		1
#endif
#endif

#ifndef	UseStaticMsgType
#if	!defined(hc) || defined(__STDC__)
#define	UseStaticMsgType	1
#endif
#endif

#define msgh_request_port	msgh_remote_port
#define msgh_reply_port		msgh_local_port


/* Routine io_write */
mig_external kern_return_t rpc_io_write
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	int isctty,
	int pid,
	int pgrp,
	data_t data,
	mach_msg_type_number_t dataCnt,
	int offset,
	int *amount
)
#else
	(io_object, isctty, pid, pgrp, data, dataCnt, offset, amount)
	io_t io_object;
	int isctty;
	int pid;
	int pgrp;
	data_t data;
	mach_msg_type_number_t dataCnt;
	int offset;
	int *amount;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t iscttyType;
		int isctty;
		mach_msg_type_t pidType;
		int pid;
		mach_msg_type_t pgrpType;
		int pgrp;
		mach_msg_type_long_t dataType;
		char data[2048];
		mach_msg_type_t offsetType;
		int offset;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t amountType;
		int amount;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
	boolean_t msgh_simple = TRUE;
	unsigned int msgh_size;
	unsigned int msgh_size_delta;

#if	UseStaticMsgType
	static mach_msg_type_t iscttyType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t pidType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t pgrpType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_long_t dataType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	MACH_MSG_TYPE_CHAR,
		/* msgtl_size = */	8,
		/* msgtl_number = */	2048,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t offsetType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t amountCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->iscttyType = iscttyType;
#else	UseStaticMsgType
	InP->iscttyType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->iscttyType.msgt_size = 32;
	InP->iscttyType.msgt_number = 1;
	InP->iscttyType.msgt_inline = TRUE;
	InP->iscttyType.msgt_longform = FALSE;
	InP->iscttyType.msgt_deallocate = FALSE;
	InP->iscttyType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->isctty = isctty;

#if	UseStaticMsgType
	InP->pidType = pidType;
#else	UseStaticMsgType
	InP->pidType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->pidType.msgt_size = 32;
	InP->pidType.msgt_number = 1;
	InP->pidType.msgt_inline = TRUE;
	InP->pidType.msgt_longform = FALSE;
	InP->pidType.msgt_deallocate = FALSE;
	InP->pidType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->pid = pid;

#if	UseStaticMsgType
	InP->pgrpType = pgrpType;
#else	UseStaticMsgType
	InP->pgrpType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->pgrpType.msgt_size = 32;
	InP->pgrpType.msgt_number = 1;
	InP->pgrpType.msgt_inline = TRUE;
	InP->pgrpType.msgt_longform = FALSE;
	InP->pgrpType.msgt_deallocate = FALSE;
	InP->pgrpType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->pgrp = pgrp;

#if	UseStaticMsgType
	InP->dataType = dataType;
#else	UseStaticMsgType
	InP->dataType.msgtl_name = MACH_MSG_TYPE_CHAR;
	InP->dataType.msgtl_size = 8;
	InP->dataType.msgtl_header.msgt_name = 0;
	InP->dataType.msgtl_header.msgt_size = 0;
	InP->dataType.msgtl_header.msgt_number = 0;
	InP->dataType.msgtl_header.msgt_inline = TRUE;
	InP->dataType.msgtl_header.msgt_longform = TRUE;
	InP->dataType.msgtl_header.msgt_deallocate = FALSE;
	InP->dataType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType

	if (dataCnt > 2048) {
		InP->dataType.msgtl_header.msgt_inline = FALSE;
		*((char **)InP->data) = data;
		msgh_simple = FALSE;
	}
	else {
		bcopy((char *) data, (char *) InP->data, dataCnt);
	}

	InP->dataType.msgtl_number = dataCnt;

	msgh_size_delta = (InP->dataType.msgtl_header.msgt_inline) ? dataCnt + 3 & ~3 : sizeof(char *);
	msgh_size = 68 + msgh_size_delta;
	InP = (Request *) ((char *) InP + msgh_size_delta - 2048);
#if	UseStaticMsgType
	InP->offsetType = offsetType;
#else	UseStaticMsgType
	InP->offsetType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->offsetType.msgt_size = 32;
	InP->offsetType.msgt_number = 1;
	InP->offsetType.msgt_inline = TRUE;
	InP->offsetType.msgt_longform = FALSE;
	InP->offsetType.msgt_deallocate = FALSE;
	InP->offsetType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->offset = offset;

	InP = &Mess.In;
	InP->Head.msgh_bits = msgh_simple ?
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE) :
		(MACH_MSGH_BITS_COMPLEX|
		 MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE));
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = io_object;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 21000;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, msgh_size, sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msgh_id != 21100) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;

	if ((OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX) ||
	    ((msgh_size != 40) &&
	     ((msgh_size != sizeof(mig_reply_header_t)) ||
	      (OutP->RetCode == KERN_SUCCESS))))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->amountType != * (int *) &amountCheck)
#else	UseStaticMsgType
	if ((OutP->amountType.msgt_inline != TRUE) ||
	    (OutP->amountType.msgt_longform != FALSE) ||
	    (OutP->amountType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->amountType.msgt_number != 1) ||
	    (OutP->amountType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*amount = OutP->amount;

	return KERN_SUCCESS;
}

/* Routine io_read */
mig_external kern_return_t rpc_io_read
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	int isctty,
	int pid,
	int pgrp,
	data_t data,
	mach_msg_type_number_t *dataCnt,
	int offset,
	int amount
)
#else
	(io_object, isctty, pid, pgrp, data, dataCnt, offset, amount)
	io_t io_object;
	int isctty;
	int pid;
	int pgrp;
	data_t data;
	mach_msg_type_number_t *dataCnt;
	int offset;
	int amount;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t iscttyType;
		int isctty;
		mach_msg_type_t pidType;
		int pid;
		mach_msg_type_t pgrpType;
		int pgrp;
		mach_msg_type_t offsetType;
		int offset;
		mach_msg_type_t amountType;
		int amount;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_long_t dataType;
		char data[2048];
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
#if	TypeCheck
	unsigned int msgh_size;
#endif	TypeCheck

#if	UseStaticMsgType
	static mach_msg_type_t iscttyType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t pidType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t pgrpType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t offsetType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t amountType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->iscttyType = iscttyType;
#else	UseStaticMsgType
	InP->iscttyType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->iscttyType.msgt_size = 32;
	InP->iscttyType.msgt_number = 1;
	InP->iscttyType.msgt_inline = TRUE;
	InP->iscttyType.msgt_longform = FALSE;
	InP->iscttyType.msgt_deallocate = FALSE;
	InP->iscttyType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->isctty = isctty;

#if	UseStaticMsgType
	InP->pidType = pidType;
#else	UseStaticMsgType
	InP->pidType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->pidType.msgt_size = 32;
	InP->pidType.msgt_number = 1;
	InP->pidType.msgt_inline = TRUE;
	InP->pidType.msgt_longform = FALSE;
	InP->pidType.msgt_deallocate = FALSE;
	InP->pidType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->pid = pid;

#if	UseStaticMsgType
	InP->pgrpType = pgrpType;
#else	UseStaticMsgType
	InP->pgrpType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->pgrpType.msgt_size = 32;
	InP->pgrpType.msgt_number = 1;
	InP->pgrpType.msgt_inline = TRUE;
	InP->pgrpType.msgt_longform = FALSE;
	InP->pgrpType.msgt_deallocate = FALSE;
	InP->pgrpType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->pgrp = pgrp;

#if	UseStaticMsgType
	InP->offsetType = offsetType;
#else	UseStaticMsgType
	InP->offsetType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->offsetType.msgt_size = 32;
	InP->offsetType.msgt_number = 1;
	InP->offsetType.msgt_inline = TRUE;
	InP->offsetType.msgt_longform = FALSE;
	InP->offsetType.msgt_deallocate = FALSE;
	InP->offsetType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->offset = offset;

#if	UseStaticMsgType
	InP->amountType = amountType;
#else	UseStaticMsgType
	InP->amountType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->amountType.msgt_size = 32;
	InP->amountType.msgt_number = 1;
	InP->amountType.msgt_inline = TRUE;
	InP->amountType.msgt_longform = FALSE;
	InP->amountType.msgt_deallocate = FALSE;
	InP->amountType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->amount = amount;

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = io_object;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 21001;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msgh_id != 21101) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);

	if (((msgh_size < 44)) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
	if ((OutP->dataType.msgtl_header.msgt_longform != TRUE) ||
	    (OutP->dataType.msgtl_name != MACH_MSG_TYPE_CHAR) ||
	    (OutP->dataType.msgtl_size != 8))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
	if (msgh_size != 44 + ((OutP->dataType.msgtl_header.msgt_inline) ? OutP->dataType.msgtl_number + 3 & ~3 : sizeof(char *)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->dataType.msgtl_number > *dataCnt) {
		if (OutP->data.msgtl_header.msgt_inline) {
			(void) vm_allocate(mach_task_self(),
				(vm_offset_t *)data,
				OutP->dataType.msgtl_number, TRUE);
			bcopy(*(char **)OutP->data,*(char **)data, OutP->dataType.msgtl_number);
		} else {
			*((char **)data) = *((char **)OutP->data);
		}
	}
	else {
		bcopy((char *) OutP->data, (char *) data, OutP->dataType.msgtl_number);
	}

	*dataCnt = OutP->dataType.msgtl_number;

	return KERN_SUCCESS;
}

/* Routine io_ioctl_x */
mig_external kern_return_t rpc_io_ioctl_x
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	int isctty,
	int pid,
	int pgrp,
	int ioctl_code
)
#else
	(io_object, isctty, pid, pgrp, ioctl_code)
	io_t io_object;
	int isctty;
	int pid;
	int pgrp;
	int ioctl_code;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t iscttyType;
		int isctty;
		mach_msg_type_t pidType;
		int pid;
		mach_msg_type_t pgrpType;
		int pgrp;
		mach_msg_type_t ioctl_codeType;
		int ioctl_code;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;

#if	UseStaticMsgType
	static mach_msg_type_t iscttyType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t pidType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t pgrpType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t ioctl_codeType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->iscttyType = iscttyType;
#else	UseStaticMsgType
	InP->iscttyType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->iscttyType.msgt_size = 32;
	InP->iscttyType.msgt_number = 1;
	InP->iscttyType.msgt_inline = TRUE;
	InP->iscttyType.msgt_longform = FALSE;
	InP->iscttyType.msgt_deallocate = FALSE;
	InP->iscttyType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->isctty = isctty;

#if	UseStaticMsgType
	InP->pidType = pidType;
#else	UseStaticMsgType
	InP->pidType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->pidType.msgt_size = 32;
	InP->pidType.msgt_number = 1;
	InP->pidType.msgt_inline = TRUE;
	InP->pidType.msgt_longform = FALSE;
	InP->pidType.msgt_deallocate = FALSE;
	InP->pidType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->pid = pid;

#if	UseStaticMsgType
	InP->pgrpType = pgrpType;
#else	UseStaticMsgType
	InP->pgrpType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->pgrpType.msgt_size = 32;
	InP->pgrpType.msgt_number = 1;
	InP->pgrpType.msgt_inline = TRUE;
	InP->pgrpType.msgt_longform = FALSE;
	InP->pgrpType.msgt_deallocate = FALSE;
	InP->pgrpType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->pgrp = pgrp;

#if	UseStaticMsgType
	InP->ioctl_codeType = ioctl_codeType;
#else	UseStaticMsgType
	InP->ioctl_codeType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->ioctl_codeType.msgt_size = 32;
	InP->ioctl_codeType.msgt_number = 1;
	InP->ioctl_codeType.msgt_inline = TRUE;
	InP->ioctl_codeType.msgt_longform = FALSE;
	InP->ioctl_codeType.msgt_deallocate = FALSE;
	InP->ioctl_codeType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->ioctl_code = ioctl_code;

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = io_object;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 21002;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msgh_id != 21102) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	if ((OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX) ||
	    (OutP->Head.msgh_size != 32))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	return OutP->RetCode;
}

/* Routine io_ioctl_r */
mig_external kern_return_t rpc_io_ioctl_r
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	int isctty,
	int pid,
	int pgrp,
	int ioctl_code,
	data_t data,
	mach_msg_type_number_t *dataCnt
)
#else
	(io_object, isctty, pid, pgrp, ioctl_code, data, dataCnt)
	io_t io_object;
	int isctty;
	int pid;
	int pgrp;
	int ioctl_code;
	data_t data;
	mach_msg_type_number_t *dataCnt;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t iscttyType;
		int isctty;
		mach_msg_type_t pidType;
		int pid;
		mach_msg_type_t pgrpType;
		int pgrp;
		mach_msg_type_t ioctl_codeType;
		int ioctl_code;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_long_t dataType;
		char data[2048];
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
#if	TypeCheck
	unsigned int msgh_size;
#endif	TypeCheck

#if	UseStaticMsgType
	static mach_msg_type_t iscttyType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t pidType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t pgrpType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t ioctl_codeType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->iscttyType = iscttyType;
#else	UseStaticMsgType
	InP->iscttyType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->iscttyType.msgt_size = 32;
	InP->iscttyType.msgt_number = 1;
	InP->iscttyType.msgt_inline = TRUE;
	InP->iscttyType.msgt_longform = FALSE;
	InP->iscttyType.msgt_deallocate = FALSE;
	InP->iscttyType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->isctty = isctty;

#if	UseStaticMsgType
	InP->pidType = pidType;
#else	UseStaticMsgType
	InP->pidType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->pidType.msgt_size = 32;
	InP->pidType.msgt_number = 1;
	InP->pidType.msgt_inline = TRUE;
	InP->pidType.msgt_longform = FALSE;
	InP->pidType.msgt_deallocate = FALSE;
	InP->pidType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->pid = pid;

#if	UseStaticMsgType
	InP->pgrpType = pgrpType;
#else	UseStaticMsgType
	InP->pgrpType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->pgrpType.msgt_size = 32;
	InP->pgrpType.msgt_number = 1;
	InP->pgrpType.msgt_inline = TRUE;
	InP->pgrpType.msgt_longform = FALSE;
	InP->pgrpType.msgt_deallocate = FALSE;
	InP->pgrpType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->pgrp = pgrp;

#if	UseStaticMsgType
	InP->ioctl_codeType = ioctl_codeType;
#else	UseStaticMsgType
	InP->ioctl_codeType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->ioctl_codeType.msgt_size = 32;
	InP->ioctl_codeType.msgt_number = 1;
	InP->ioctl_codeType.msgt_inline = TRUE;
	InP->ioctl_codeType.msgt_longform = FALSE;
	InP->ioctl_codeType.msgt_deallocate = FALSE;
	InP->ioctl_codeType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->ioctl_code = ioctl_code;

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = io_object;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 21003;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msgh_id != 21103) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);

	if (((msgh_size < 44)) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
	if ((OutP->dataType.msgtl_header.msgt_longform != TRUE) ||
	    (OutP->dataType.msgtl_name != MACH_MSG_TYPE_CHAR) ||
	    (OutP->dataType.msgtl_size != 8))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
	if (msgh_size != 44 + ((OutP->dataType.msgtl_header.msgt_inline) ? OutP->dataType.msgtl_number + 3 & ~3 : sizeof(char *)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->dataType.msgtl_number > *dataCnt) {
		if (OutP->data.msgtl_header.msgt_inline) {
			(void) vm_allocate(mach_task_self(),
				(vm_offset_t *)data,
				OutP->dataType.msgtl_number, TRUE);
			bcopy(*(char **)OutP->data,*(char **)data, OutP->dataType.msgtl_number);
		} else {
			*((char **)data) = *((char **)OutP->data);
		}
	}
	else {
		bcopy((char *) OutP->data, (char *) data, OutP->dataType.msgtl_number);
	}

	*dataCnt = OutP->dataType.msgtl_number;

	return KERN_SUCCESS;
}

/* Routine io_ioctl_w */
mig_external kern_return_t rpc_io_ioctl_w
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	int isctty,
	int pid,
	int pgrp,
	int ioctl_code,
	data_t data,
	mach_msg_type_number_t dataCnt
)
#else
	(io_object, isctty, pid, pgrp, ioctl_code, data, dataCnt)
	io_t io_object;
	int isctty;
	int pid;
	int pgrp;
	int ioctl_code;
	data_t data;
	mach_msg_type_number_t dataCnt;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t iscttyType;
		int isctty;
		mach_msg_type_t pidType;
		int pid;
		mach_msg_type_t pgrpType;
		int pgrp;
		mach_msg_type_t ioctl_codeType;
		int ioctl_code;
		mach_msg_type_long_t dataType;
		char data[2048];
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
	boolean_t msgh_simple = TRUE;
	unsigned int msgh_size;

#if	UseStaticMsgType
	static mach_msg_type_t iscttyType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t pidType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t pgrpType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t ioctl_codeType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_long_t dataType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	MACH_MSG_TYPE_CHAR,
		/* msgtl_size = */	8,
		/* msgtl_number = */	2048,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->iscttyType = iscttyType;
#else	UseStaticMsgType
	InP->iscttyType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->iscttyType.msgt_size = 32;
	InP->iscttyType.msgt_number = 1;
	InP->iscttyType.msgt_inline = TRUE;
	InP->iscttyType.msgt_longform = FALSE;
	InP->iscttyType.msgt_deallocate = FALSE;
	InP->iscttyType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->isctty = isctty;

#if	UseStaticMsgType
	InP->pidType = pidType;
#else	UseStaticMsgType
	InP->pidType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->pidType.msgt_size = 32;
	InP->pidType.msgt_number = 1;
	InP->pidType.msgt_inline = TRUE;
	InP->pidType.msgt_longform = FALSE;
	InP->pidType.msgt_deallocate = FALSE;
	InP->pidType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->pid = pid;

#if	UseStaticMsgType
	InP->pgrpType = pgrpType;
#else	UseStaticMsgType
	InP->pgrpType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->pgrpType.msgt_size = 32;
	InP->pgrpType.msgt_number = 1;
	InP->pgrpType.msgt_inline = TRUE;
	InP->pgrpType.msgt_longform = FALSE;
	InP->pgrpType.msgt_deallocate = FALSE;
	InP->pgrpType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->pgrp = pgrp;

#if	UseStaticMsgType
	InP->ioctl_codeType = ioctl_codeType;
#else	UseStaticMsgType
	InP->ioctl_codeType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->ioctl_codeType.msgt_size = 32;
	InP->ioctl_codeType.msgt_number = 1;
	InP->ioctl_codeType.msgt_inline = TRUE;
	InP->ioctl_codeType.msgt_longform = FALSE;
	InP->ioctl_codeType.msgt_deallocate = FALSE;
	InP->ioctl_codeType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->ioctl_code = ioctl_code;

#if	UseStaticMsgType
	InP->dataType = dataType;
#else	UseStaticMsgType
	InP->dataType.msgtl_name = MACH_MSG_TYPE_CHAR;
	InP->dataType.msgtl_size = 8;
	InP->dataType.msgtl_header.msgt_name = 0;
	InP->dataType.msgtl_header.msgt_size = 0;
	InP->dataType.msgtl_header.msgt_number = 0;
	InP->dataType.msgtl_header.msgt_inline = TRUE;
	InP->dataType.msgtl_header.msgt_longform = TRUE;
	InP->dataType.msgtl_header.msgt_deallocate = FALSE;
	InP->dataType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType

	if (dataCnt > 2048) {
		InP->dataType.msgtl_header.msgt_inline = FALSE;
		*((char **)InP->data) = data;
		msgh_simple = FALSE;
	}
	else {
		bcopy((char *) data, (char *) InP->data, dataCnt);
	}

	InP->dataType.msgtl_number = dataCnt;

	msgh_size = 68 + ((InP->dataType.msgtl_header.msgt_inline) ? dataCnt + 3 & ~3 : sizeof(char *));
	InP->Head.msgh_bits = msgh_simple ?
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE) :
		(MACH_MSGH_BITS_COMPLEX|
		 MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE));
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = io_object;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 21004;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, msgh_size, sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msgh_id != 21104) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	if ((OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX) ||
	    (OutP->Head.msgh_size != 32))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	return OutP->RetCode;
}

/* Routine io_ioctl_rw */
mig_external kern_return_t rpc_io_ioctl_rw
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	int isctty,
	int pid,
	int pgrp,
	int ioctl_code,
	data_t ioctl_data_in,
	mach_msg_type_number_t ioctl_data_inCnt,
	data_t ioctl_data_out,
	mach_msg_type_number_t *ioctl_data_outCnt
)
#else
	(io_object, isctty, pid, pgrp, ioctl_code, ioctl_data_in, ioctl_data_inCnt, ioctl_data_out, ioctl_data_outCnt)
	io_t io_object;
	int isctty;
	int pid;
	int pgrp;
	int ioctl_code;
	data_t ioctl_data_in;
	mach_msg_type_number_t ioctl_data_inCnt;
	data_t ioctl_data_out;
	mach_msg_type_number_t *ioctl_data_outCnt;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t iscttyType;
		int isctty;
		mach_msg_type_t pidType;
		int pid;
		mach_msg_type_t pgrpType;
		int pgrp;
		mach_msg_type_t ioctl_codeType;
		int ioctl_code;
		mach_msg_type_long_t ioctl_data_inType;
		char ioctl_data_in[2048];
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_long_t ioctl_data_outType;
		char ioctl_data_out[2048];
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
	boolean_t msgh_simple = TRUE;
	unsigned int msgh_size;

#if	UseStaticMsgType
	static mach_msg_type_t iscttyType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t pidType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t pgrpType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t ioctl_codeType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_long_t ioctl_data_inType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	MACH_MSG_TYPE_CHAR,
		/* msgtl_size = */	8,
		/* msgtl_number = */	2048,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->iscttyType = iscttyType;
#else	UseStaticMsgType
	InP->iscttyType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->iscttyType.msgt_size = 32;
	InP->iscttyType.msgt_number = 1;
	InP->iscttyType.msgt_inline = TRUE;
	InP->iscttyType.msgt_longform = FALSE;
	InP->iscttyType.msgt_deallocate = FALSE;
	InP->iscttyType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->isctty = isctty;

#if	UseStaticMsgType
	InP->pidType = pidType;
#else	UseStaticMsgType
	InP->pidType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->pidType.msgt_size = 32;
	InP->pidType.msgt_number = 1;
	InP->pidType.msgt_inline = TRUE;
	InP->pidType.msgt_longform = FALSE;
	InP->pidType.msgt_deallocate = FALSE;
	InP->pidType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->pid = pid;

#if	UseStaticMsgType
	InP->pgrpType = pgrpType;
#else	UseStaticMsgType
	InP->pgrpType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->pgrpType.msgt_size = 32;
	InP->pgrpType.msgt_number = 1;
	InP->pgrpType.msgt_inline = TRUE;
	InP->pgrpType.msgt_longform = FALSE;
	InP->pgrpType.msgt_deallocate = FALSE;
	InP->pgrpType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->pgrp = pgrp;

#if	UseStaticMsgType
	InP->ioctl_codeType = ioctl_codeType;
#else	UseStaticMsgType
	InP->ioctl_codeType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->ioctl_codeType.msgt_size = 32;
	InP->ioctl_codeType.msgt_number = 1;
	InP->ioctl_codeType.msgt_inline = TRUE;
	InP->ioctl_codeType.msgt_longform = FALSE;
	InP->ioctl_codeType.msgt_deallocate = FALSE;
	InP->ioctl_codeType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->ioctl_code = ioctl_code;

#if	UseStaticMsgType
	InP->ioctl_data_inType = ioctl_data_inType;
#else	UseStaticMsgType
	InP->ioctl_data_inType.msgtl_name = MACH_MSG_TYPE_CHAR;
	InP->ioctl_data_inType.msgtl_size = 8;
	InP->ioctl_data_inType.msgtl_header.msgt_name = 0;
	InP->ioctl_data_inType.msgtl_header.msgt_size = 0;
	InP->ioctl_data_inType.msgtl_header.msgt_number = 0;
	InP->ioctl_data_inType.msgtl_header.msgt_inline = TRUE;
	InP->ioctl_data_inType.msgtl_header.msgt_longform = TRUE;
	InP->ioctl_data_inType.msgtl_header.msgt_deallocate = FALSE;
	InP->ioctl_data_inType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType

	if (ioctl_data_inCnt > 2048) {
		InP->ioctl_data_inType.msgtl_header.msgt_inline = FALSE;
		*((char **)InP->ioctl_data_in) = ioctl_data_in;
		msgh_simple = FALSE;
	}
	else {
		bcopy((char *) ioctl_data_in, (char *) InP->ioctl_data_in, ioctl_data_inCnt);
	}

	InP->ioctl_data_inType.msgtl_number = ioctl_data_inCnt;

	msgh_size = 68 + ((InP->ioctl_data_inType.msgtl_header.msgt_inline) ? ioctl_data_inCnt + 3 & ~3 : sizeof(char *));
	InP->Head.msgh_bits = msgh_simple ?
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE) :
		(MACH_MSGH_BITS_COMPLEX|
		 MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE));
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = io_object;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 21005;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, msgh_size, sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msgh_id != 21105) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);

	if (((msgh_size < 44)) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
	if ((OutP->ioctl_data_outType.msgtl_header.msgt_longform != TRUE) ||
	    (OutP->ioctl_data_outType.msgtl_name != MACH_MSG_TYPE_CHAR) ||
	    (OutP->ioctl_data_outType.msgtl_size != 8))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
	if (msgh_size != 44 + ((OutP->ioctl_data_outType.msgtl_header.msgt_inline) ? OutP->ioctl_data_outType.msgtl_number + 3 & ~3 : sizeof(char *)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->ioctl_data_outType.msgtl_number > *ioctl_data_outCnt) {
		if (OutP->ioctl_data_out.msgtl_header.msgt_inline) {
			(void) vm_allocate(mach_task_self(),
				(vm_offset_t *)ioctl_data_out,
				OutP->ioctl_data_outType.msgtl_number, TRUE);
			bcopy(*(char **)OutP->ioctl_data_out,*(char **)ioctl_data_out, OutP->ioctl_data_outType.msgtl_number);
		} else {
			*((char **)ioctl_data_out) = *((char **)OutP->ioctl_data_out);
		}
	}
	else {
		bcopy((char *) OutP->ioctl_data_out, (char *) ioctl_data_out, OutP->ioctl_data_outType.msgtl_number);
	}

	*ioctl_data_outCnt = OutP->ioctl_data_outType.msgtl_number;

	return KERN_SUCCESS;
}

/* Routine io_set_flags */
mig_external kern_return_t rpc_io_set_flags
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t own_io,
	int io_flags
)
#else
	(own_io, io_flags)
	io_t own_io;
	int io_flags;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t io_flagsType;
		int io_flags;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;

#if	UseStaticMsgType
	static mach_msg_type_t io_flagsType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->io_flagsType = io_flagsType;
#else	UseStaticMsgType
	InP->io_flagsType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->io_flagsType.msgt_size = 32;
	InP->io_flagsType.msgt_number = 1;
	InP->io_flagsType.msgt_inline = TRUE;
	InP->io_flagsType.msgt_longform = FALSE;
	InP->io_flagsType.msgt_deallocate = FALSE;
	InP->io_flagsType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->io_flags = io_flags;

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = own_io;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 21006;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msgh_id != 21106) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	if ((OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX) ||
	    (OutP->Head.msgh_size != 32))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	return OutP->RetCode;
}

/* Routine io_get_flags */
mig_external kern_return_t rpc_io_get_flags
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t own_io,
	int *io_flags
)
#else
	(own_io, io_flags)
	io_t own_io;
	int *io_flags;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t io_flagsType;
		int io_flags;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	unsigned int msgh_size;
#endif	TypeCheck

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t io_flagsCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = own_io;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 21007;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msgh_id != 21107) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;

	if ((OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX) ||
	    ((msgh_size != 40) &&
	     ((msgh_size != sizeof(mig_reply_header_t)) ||
	      (OutP->RetCode == KERN_SUCCESS))))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->io_flagsType != * (int *) &io_flagsCheck)
#else	UseStaticMsgType
	if ((OutP->io_flagsType.msgt_inline != TRUE) ||
	    (OutP->io_flagsType.msgt_longform != FALSE) ||
	    (OutP->io_flagsType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->io_flagsType.msgt_number != 1) ||
	    (OutP->io_flagsType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*io_flags = OutP->io_flags;

	return KERN_SUCCESS;
}

/* Routine io_select */
mig_external kern_return_t rpc_io_select
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	int select_type,
	mach_port_t return_port,
	int id_tag,
	int *select_result
)
#else
	(io_object, select_type, return_port, id_tag, select_result)
	io_t io_object;
	int select_type;
	mach_port_t return_port;
	int id_tag;
	int *select_result;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t select_typeType;
		int select_type;
		mach_msg_type_t return_portType;
		mach_port_t return_port;
		mach_msg_type_t id_tagType;
		int id_tag;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t select_resultType;
		int select_result;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	unsigned int msgh_size;
#endif	TypeCheck

#if	UseStaticMsgType
	static mach_msg_type_t select_typeType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t return_portType = {
		/* msgt_name = */		MACH_MSG_TYPE_COPY_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t id_tagType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t select_resultCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->select_typeType = select_typeType;
#else	UseStaticMsgType
	InP->select_typeType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->select_typeType.msgt_size = 32;
	InP->select_typeType.msgt_number = 1;
	InP->select_typeType.msgt_inline = TRUE;
	InP->select_typeType.msgt_longform = FALSE;
	InP->select_typeType.msgt_deallocate = FALSE;
	InP->select_typeType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->select_type = select_type;

#if	UseStaticMsgType
	InP->return_portType = return_portType;
#else	UseStaticMsgType
	InP->return_portType.msgt_name = MACH_MSG_TYPE_COPY_SEND;
	InP->return_portType.msgt_size = 32;
	InP->return_portType.msgt_number = 1;
	InP->return_portType.msgt_inline = TRUE;
	InP->return_portType.msgt_longform = FALSE;
	InP->return_portType.msgt_deallocate = FALSE;
	InP->return_portType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->return_port = return_port;

#if	UseStaticMsgType
	InP->id_tagType = id_tagType;
#else	UseStaticMsgType
	InP->id_tagType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->id_tagType.msgt_size = 32;
	InP->id_tagType.msgt_number = 1;
	InP->id_tagType.msgt_inline = TRUE;
	InP->id_tagType.msgt_longform = FALSE;
	InP->id_tagType.msgt_deallocate = FALSE;
	InP->id_tagType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->id_tag = id_tag;

	InP->Head.msgh_bits = MACH_MSGH_BITS_COMPLEX|
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = io_object;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 21008;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msgh_id != 21108) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;

	if ((OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX) ||
	    ((msgh_size != 40) &&
	     ((msgh_size != sizeof(mig_reply_header_t)) ||
	      (OutP->RetCode == KERN_SUCCESS))))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->select_resultType != * (int *) &select_resultCheck)
#else	UseStaticMsgType
	if ((OutP->select_resultType.msgt_inline != TRUE) ||
	    (OutP->select_resultType.msgt_longform != FALSE) ||
	    (OutP->select_resultType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->select_resultType.msgt_number != 1) ||
	    (OutP->select_resultType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*select_result = OutP->select_result;

	return KERN_SUCCESS;
}

/* Routine io_stat */
mig_external kern_return_t rpc_io_stat
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t stat_object,
	io_statbuf_t *stat_info
)
#else
	(stat_object, stat_info)
	io_t stat_object;
	io_statbuf_t *stat_info;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t stat_infoType;
		io_statbuf_t stat_info;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	unsigned int msgh_size;
#endif	TypeCheck

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t stat_infoCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		28,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = stat_object;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 21009;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msgh_id != 21109) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;

	if ((OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX) ||
	    ((msgh_size != 148) &&
	     ((msgh_size != sizeof(mig_reply_header_t)) ||
	      (OutP->RetCode == KERN_SUCCESS))))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->stat_infoType != * (int *) &stat_infoCheck)
#else	UseStaticMsgType
	if ((OutP->stat_infoType.msgt_inline != TRUE) ||
	    (OutP->stat_infoType.msgt_longform != FALSE) ||
	    (OutP->stat_infoType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->stat_infoType.msgt_number != 28) ||
	    (OutP->stat_infoType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*stat_info = OutP->stat_info;

	return KERN_SUCCESS;
}

/* SimpleRoutine io_reauthenticate */
mig_external kern_return_t rpc_io_reauthenticate
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t auth_object
)
#else
	(auth_object)
	io_t auth_object;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	union {
		Request In;
	} Mess;

	register Request *InP = &Mess.In;


	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, 0);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = auth_object;
	InP->Head.msgh_reply_port = MACH_PORT_NULL;
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 21010;

	return mach_msg(&InP->Head, MACH_SEND_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), 0, MACH_PORT_NULL, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
}

/* Routine io_interrupt */
mig_external kern_return_t rpc_io_interrupt
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t intr_object
)
#else
	(intr_object)
	io_t intr_object;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = intr_object;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 21011;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msgh_id != 21111) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	if ((OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX) ||
	    (OutP->Head.msgh_size != 32))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	return OutP->RetCode;
}

/* Routine io_server_version */
mig_external kern_return_t rpc_io_server_version
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t vers_object,
	string_t server_name,
	int *server_major_version,
	int *server_minor_version,
	int *server_edit_level
)
#else
	(vers_object, server_name, server_major_version, server_minor_version, server_edit_level)
	io_t vers_object;
	string_t server_name;
	int *server_major_version;
	int *server_minor_version;
	int *server_edit_level;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t server_nameType;
		string_t server_name;
		mach_msg_type_t server_major_versionType;
		int server_major_version;
		mach_msg_type_t server_minor_versionType;
		int server_minor_version;
		mach_msg_type_t server_edit_levelType;
		int server_edit_level;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	unsigned int msgh_size;
#endif	TypeCheck

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t server_nameCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_STRING_C,
		/* msgt_size = */		8,
		/* msgt_number = */		1024,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t server_major_versionCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t server_minor_versionCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t server_edit_levelCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = vers_object;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 21012;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msgh_id != 21112) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;

	if ((OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX) ||
	    ((msgh_size != 1084) &&
	     ((msgh_size != sizeof(mig_reply_header_t)) ||
	      (OutP->RetCode == KERN_SUCCESS))))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->server_nameType != * (int *) &server_nameCheck)
#else	UseStaticMsgType
	if ((OutP->server_nameType.msgt_inline != TRUE) ||
	    (OutP->server_nameType.msgt_longform != FALSE) ||
	    (OutP->server_nameType.msgt_name != MACH_MSG_TYPE_STRING_C) ||
	    (OutP->server_nameType.msgt_number != 1024) ||
	    (OutP->server_nameType.msgt_size != 8))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	(void) mig_strncpy(server_name, OutP->server_name, 1024);

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->server_major_versionType != * (int *) &server_major_versionCheck)
#else	UseStaticMsgType
	if ((OutP->server_major_versionType.msgt_inline != TRUE) ||
	    (OutP->server_major_versionType.msgt_longform != FALSE) ||
	    (OutP->server_major_versionType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->server_major_versionType.msgt_number != 1) ||
	    (OutP->server_major_versionType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*server_major_version = OutP->server_major_version;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->server_minor_versionType != * (int *) &server_minor_versionCheck)
#else	UseStaticMsgType
	if ((OutP->server_minor_versionType.msgt_inline != TRUE) ||
	    (OutP->server_minor_versionType.msgt_longform != FALSE) ||
	    (OutP->server_minor_versionType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->server_minor_versionType.msgt_number != 1) ||
	    (OutP->server_minor_versionType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*server_minor_version = OutP->server_minor_version;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->server_edit_levelType != * (int *) &server_edit_levelCheck)
#else	UseStaticMsgType
	if ((OutP->server_edit_levelType.msgt_inline != TRUE) ||
	    (OutP->server_edit_levelType.msgt_longform != FALSE) ||
	    (OutP->server_edit_levelType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->server_edit_levelType.msgt_number != 1) ||
	    (OutP->server_edit_levelType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*server_edit_level = OutP->server_edit_level;

	return KERN_SUCCESS;
}

/* Routine io_map */
mig_external kern_return_t rpc_io_map
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	mach_port_t *memobjxx,
	mach_port_t *memobjrd,
	mach_port_t *memobjwt
)
#else
	(io_object, memobjxx, memobjrd, memobjwt)
	io_t io_object;
	mach_port_t *memobjxx;
	mach_port_t *memobjrd;
	mach_port_t *memobjwt;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t memobjxxType;
		mach_port_t memobjxx;
		mach_msg_type_t memobjrdType;
		mach_port_t memobjrd;
		mach_msg_type_t memobjwtType;
		mach_port_t memobjwt;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
#if	TypeCheck
	unsigned int msgh_size;
#endif	TypeCheck

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t memobjxxCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t memobjrdCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t memobjwtCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = io_object;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 21013;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msgh_id != 21113) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);

	if (((msgh_size != 56) || msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->memobjxxType != * (int *) &memobjxxCheck)
#else	UseStaticMsgType
	if ((OutP->memobjxxType.msgt_inline != TRUE) ||
	    (OutP->memobjxxType.msgt_longform != FALSE) ||
	    (OutP->memobjxxType.msgt_name != MACH_MSG_TYPE_PORT_SEND) ||
	    (OutP->memobjxxType.msgt_number != 1) ||
	    (OutP->memobjxxType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*memobjxx = OutP->memobjxx;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->memobjrdType != * (int *) &memobjrdCheck)
#else	UseStaticMsgType
	if ((OutP->memobjrdType.msgt_inline != TRUE) ||
	    (OutP->memobjrdType.msgt_longform != FALSE) ||
	    (OutP->memobjrdType.msgt_name != MACH_MSG_TYPE_PORT_SEND) ||
	    (OutP->memobjrdType.msgt_number != 1) ||
	    (OutP->memobjrdType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*memobjrd = OutP->memobjrd;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->memobjwtType != * (int *) &memobjwtCheck)
#else	UseStaticMsgType
	if ((OutP->memobjwtType.msgt_inline != TRUE) ||
	    (OutP->memobjwtType.msgt_longform != FALSE) ||
	    (OutP->memobjwtType.msgt_name != MACH_MSG_TYPE_PORT_SEND) ||
	    (OutP->memobjwtType.msgt_number != 1) ||
	    (OutP->memobjwtType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*memobjwt = OutP->memobjwt;

	return KERN_SUCCESS;
}

/* Routine io_map_cntl */
mig_external kern_return_t rpc_io_map_cntl
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	mach_port_t *memobjxx,
	mach_port_t *memobjrd,
	mach_port_t *memobjwt
)
#else
	(io_object, memobjxx, memobjrd, memobjwt)
	io_t io_object;
	mach_port_t *memobjxx;
	mach_port_t *memobjrd;
	mach_port_t *memobjwt;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t memobjxxType;
		mach_port_t memobjxx;
		mach_msg_type_t memobjrdType;
		mach_port_t memobjrd;
		mach_msg_type_t memobjwtType;
		mach_port_t memobjwt;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;
#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck
#if	TypeCheck
	unsigned int msgh_size;
#endif	TypeCheck

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t memobjxxCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t memobjrdCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t memobjwtCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = io_object;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 21014;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msgh_id != 21114) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	msgh_size = OutP->Head.msgh_size;
	msgh_simple = !(OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);

	if (((msgh_size != 56) || msgh_simple) &&
	    ((msgh_size != sizeof(mig_reply_header_t)) ||
	     !msgh_simple ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->memobjxxType != * (int *) &memobjxxCheck)
#else	UseStaticMsgType
	if ((OutP->memobjxxType.msgt_inline != TRUE) ||
	    (OutP->memobjxxType.msgt_longform != FALSE) ||
	    (OutP->memobjxxType.msgt_name != MACH_MSG_TYPE_PORT_SEND) ||
	    (OutP->memobjxxType.msgt_number != 1) ||
	    (OutP->memobjxxType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*memobjxx = OutP->memobjxx;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->memobjrdType != * (int *) &memobjrdCheck)
#else	UseStaticMsgType
	if ((OutP->memobjrdType.msgt_inline != TRUE) ||
	    (OutP->memobjrdType.msgt_longform != FALSE) ||
	    (OutP->memobjrdType.msgt_name != MACH_MSG_TYPE_PORT_SEND) ||
	    (OutP->memobjrdType.msgt_number != 1) ||
	    (OutP->memobjrdType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*memobjrd = OutP->memobjrd;

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->memobjwtType != * (int *) &memobjwtCheck)
#else	UseStaticMsgType
	if ((OutP->memobjwtType.msgt_inline != TRUE) ||
	    (OutP->memobjwtType.msgt_longform != FALSE) ||
	    (OutP->memobjwtType.msgt_name != MACH_MSG_TYPE_PORT_SEND) ||
	    (OutP->memobjwtType.msgt_number != 1) ||
	    (OutP->memobjwtType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*memobjwt = OutP->memobjwt;

	return KERN_SUCCESS;
}

/* Routine io_get_it */
mig_external kern_return_t rpc_io_get_it
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	mach_port_t cntl
)
#else
	(io_object, cntl)
	io_t io_object;
	mach_port_t cntl;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t cntlType;
		mach_port_t cntl;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;

#if	UseStaticMsgType
	static mach_msg_type_t cntlType = {
		/* msgt_name = */		MACH_MSG_TYPE_COPY_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->cntlType = cntlType;
#else	UseStaticMsgType
	InP->cntlType.msgt_name = MACH_MSG_TYPE_COPY_SEND;
	InP->cntlType.msgt_size = 32;
	InP->cntlType.msgt_number = 1;
	InP->cntlType.msgt_inline = TRUE;
	InP->cntlType.msgt_longform = FALSE;
	InP->cntlType.msgt_deallocate = FALSE;
	InP->cntlType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->cntl = cntl;

	InP->Head.msgh_bits = MACH_MSGH_BITS_COMPLEX|
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = io_object;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 21015;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msgh_id != 21115) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	if ((OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX) ||
	    (OutP->Head.msgh_size != 32))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	return OutP->RetCode;
}

/* Routine io_release_it */
mig_external kern_return_t rpc_io_release_it
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	mach_port_t cntl
)
#else
	(io_object, cntl)
	io_t io_object;
	mach_port_t cntl;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t cntlType;
		mach_port_t cntl;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;

#if	UseStaticMsgType
	static mach_msg_type_t cntlType = {
		/* msgt_name = */		MACH_MSG_TYPE_COPY_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->cntlType = cntlType;
#else	UseStaticMsgType
	InP->cntlType.msgt_name = MACH_MSG_TYPE_COPY_SEND;
	InP->cntlType.msgt_size = 32;
	InP->cntlType.msgt_number = 1;
	InP->cntlType.msgt_inline = TRUE;
	InP->cntlType.msgt_longform = FALSE;
	InP->cntlType.msgt_deallocate = FALSE;
	InP->cntlType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->cntl = cntl;

	InP->Head.msgh_bits = MACH_MSGH_BITS_COMPLEX|
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = io_object;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 21016;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msgh_id != 21116) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	if ((OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX) ||
	    (OutP->Head.msgh_size != 32))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	return OutP->RetCode;
}

/* Routine io_eofnotify */
mig_external kern_return_t rpc_io_eofnotify
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	mach_port_t cntl
)
#else
	(io_object, cntl)
	io_t io_object;
	mach_port_t cntl;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t cntlType;
		mach_port_t cntl;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;

#if	UseStaticMsgType
	static mach_msg_type_t cntlType = {
		/* msgt_name = */		MACH_MSG_TYPE_COPY_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->cntlType = cntlType;
#else	UseStaticMsgType
	InP->cntlType.msgt_name = MACH_MSG_TYPE_COPY_SEND;
	InP->cntlType.msgt_size = 32;
	InP->cntlType.msgt_number = 1;
	InP->cntlType.msgt_inline = TRUE;
	InP->cntlType.msgt_longform = FALSE;
	InP->cntlType.msgt_deallocate = FALSE;
	InP->cntlType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->cntl = cntl;

	InP->Head.msgh_bits = MACH_MSGH_BITS_COMPLEX|
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = io_object;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 21017;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msgh_id != 21117) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	if ((OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX) ||
	    (OutP->Head.msgh_size != 32))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	return OutP->RetCode;
}

/* Routine io_prenotify */
mig_external kern_return_t rpc_io_prenotify
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	mach_port_t cntl,
	int write_start,
	int write_end
)
#else
	(io_object, cntl, write_start, write_end)
	io_t io_object;
	mach_port_t cntl;
	int write_start;
	int write_end;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t cntlType;
		mach_port_t cntl;
		mach_msg_type_t write_startType;
		int write_start;
		mach_msg_type_t write_endType;
		int write_end;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;

#if	UseStaticMsgType
	static mach_msg_type_t cntlType = {
		/* msgt_name = */		MACH_MSG_TYPE_COPY_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t write_startType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t write_endType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->cntlType = cntlType;
#else	UseStaticMsgType
	InP->cntlType.msgt_name = MACH_MSG_TYPE_COPY_SEND;
	InP->cntlType.msgt_size = 32;
	InP->cntlType.msgt_number = 1;
	InP->cntlType.msgt_inline = TRUE;
	InP->cntlType.msgt_longform = FALSE;
	InP->cntlType.msgt_deallocate = FALSE;
	InP->cntlType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->cntl = cntl;

#if	UseStaticMsgType
	InP->write_startType = write_startType;
#else	UseStaticMsgType
	InP->write_startType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->write_startType.msgt_size = 32;
	InP->write_startType.msgt_number = 1;
	InP->write_startType.msgt_inline = TRUE;
	InP->write_startType.msgt_longform = FALSE;
	InP->write_startType.msgt_deallocate = FALSE;
	InP->write_startType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->write_start = write_start;

#if	UseStaticMsgType
	InP->write_endType = write_endType;
#else	UseStaticMsgType
	InP->write_endType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->write_endType.msgt_size = 32;
	InP->write_endType.msgt_number = 1;
	InP->write_endType.msgt_inline = TRUE;
	InP->write_endType.msgt_longform = FALSE;
	InP->write_endType.msgt_deallocate = FALSE;
	InP->write_endType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->write_end = write_end;

	InP->Head.msgh_bits = MACH_MSGH_BITS_COMPLEX|
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = io_object;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 21018;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msgh_id != 21118) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	if ((OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX) ||
	    (OutP->Head.msgh_size != 32))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	return OutP->RetCode;
}

/* Routine io_postnotify */
mig_external kern_return_t rpc_io_postnotify
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	mach_port_t cntl,
	int write_start,
	int write_end
)
#else
	(io_object, cntl, write_start, write_end)
	io_t io_object;
	mach_port_t cntl;
	int write_start;
	int write_end;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t cntlType;
		mach_port_t cntl;
		mach_msg_type_t write_startType;
		int write_start;
		mach_msg_type_t write_endType;
		int write_end;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;

#if	UseStaticMsgType
	static mach_msg_type_t cntlType = {
		/* msgt_name = */		MACH_MSG_TYPE_COPY_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t write_startType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t write_endType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->cntlType = cntlType;
#else	UseStaticMsgType
	InP->cntlType.msgt_name = MACH_MSG_TYPE_COPY_SEND;
	InP->cntlType.msgt_size = 32;
	InP->cntlType.msgt_number = 1;
	InP->cntlType.msgt_inline = TRUE;
	InP->cntlType.msgt_longform = FALSE;
	InP->cntlType.msgt_deallocate = FALSE;
	InP->cntlType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->cntl = cntl;

#if	UseStaticMsgType
	InP->write_startType = write_startType;
#else	UseStaticMsgType
	InP->write_startType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->write_startType.msgt_size = 32;
	InP->write_startType.msgt_number = 1;
	InP->write_startType.msgt_inline = TRUE;
	InP->write_startType.msgt_longform = FALSE;
	InP->write_startType.msgt_deallocate = FALSE;
	InP->write_startType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->write_start = write_start;

#if	UseStaticMsgType
	InP->write_endType = write_endType;
#else	UseStaticMsgType
	InP->write_endType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->write_endType.msgt_size = 32;
	InP->write_endType.msgt_number = 1;
	InP->write_endType.msgt_inline = TRUE;
	InP->write_endType.msgt_longform = FALSE;
	InP->write_endType.msgt_deallocate = FALSE;
	InP->write_endType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->write_end = write_end;

	InP->Head.msgh_bits = MACH_MSGH_BITS_COMPLEX|
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = io_object;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 21019;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msgh_id != 21119) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	if ((OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX) ||
	    (OutP->Head.msgh_size != 32))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	return OutP->RetCode;
}

/* Routine io_readsleep */
mig_external kern_return_t rpc_io_readsleep
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	mach_port_t cntl
)
#else
	(io_object, cntl)
	io_t io_object;
	mach_port_t cntl;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t cntlType;
		mach_port_t cntl;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;

#if	UseStaticMsgType
	static mach_msg_type_t cntlType = {
		/* msgt_name = */		MACH_MSG_TYPE_COPY_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->cntlType = cntlType;
#else	UseStaticMsgType
	InP->cntlType.msgt_name = MACH_MSG_TYPE_COPY_SEND;
	InP->cntlType.msgt_size = 32;
	InP->cntlType.msgt_number = 1;
	InP->cntlType.msgt_inline = TRUE;
	InP->cntlType.msgt_longform = FALSE;
	InP->cntlType.msgt_deallocate = FALSE;
	InP->cntlType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->cntl = cntl;

	InP->Head.msgh_bits = MACH_MSGH_BITS_COMPLEX|
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = io_object;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 21020;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msgh_id != 21120) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	if ((OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX) ||
	    (OutP->Head.msgh_size != 32))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	return OutP->RetCode;
}

/* Routine io_sigio */
mig_external kern_return_t rpc_io_sigio
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	mach_port_t cntl
)
#else
	(io_object, cntl)
	io_t io_object;
	mach_port_t cntl;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t cntlType;
		mach_port_t cntl;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	mach_msg_return_t msg_result;

#if	UseStaticMsgType
	static mach_msg_type_t cntlType = {
		/* msgt_name = */		MACH_MSG_TYPE_COPY_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->cntlType = cntlType;
#else	UseStaticMsgType
	InP->cntlType.msgt_name = MACH_MSG_TYPE_COPY_SEND;
	InP->cntlType.msgt_size = 32;
	InP->cntlType.msgt_number = 1;
	InP->cntlType.msgt_inline = TRUE;
	InP->cntlType.msgt_longform = FALSE;
	InP->cntlType.msgt_deallocate = FALSE;
	InP->cntlType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->cntl = cntl;

	InP->Head.msgh_bits = MACH_MSGH_BITS_COMPLEX|
		MACH_MSGH_BITS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = io_object;
	InP->Head.msgh_reply_port = mig_get_reply_port();
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 21021;

	msg_result = mach_msg(&InP->Head, MACH_SEND_MSG|MACH_RCV_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), sizeof(Reply), InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
	if (msg_result != MACH_MSG_SUCCESS) {
		if ((msg_result == MACH_SEND_INVALID_REPLY) ||
		    (msg_result == MACH_RCV_INVALID_NAME))
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msgh_id != 21121) {
		if (OutP->Head.msgh_id == MACH_NOTIFY_SEND_ONCE)
		return MIG_SERVER_DIED;
		else
		return MIG_REPLY_MISMATCH;
	}

#if	TypeCheck
	if ((OutP->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX) ||
	    (OutP->Head.msgh_size != 32))
		return MIG_TYPE_ERROR;
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &OutP->RetCodeType != * (int *) &RetCodeCheck)
#else	UseStaticMsgType
	if ((OutP->RetCodeType.msgt_inline != TRUE) ||
	    (OutP->RetCodeType.msgt_longform != FALSE) ||
	    (OutP->RetCodeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (OutP->RetCodeType.msgt_number != 1) ||
	    (OutP->RetCodeType.msgt_size != 32))
#endif	UseStaticMsgType
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	return OutP->RetCode;
}
