#include "process_reply.h"
#define EXPORT_BOOLEAN
#include <mach/boolean.h>
#include <mach/kern_return.h>
#include <mach/message.h>
#include <mach/notify.h>
#include <mach/mach_types.h>
#include <mach/mig_errors.h>
#include <mach/msg_type.h>
#ifndef	KERNEL
#include <strings.h>
#endif	KERNEL
/* LINTLIBRARY */

extern mach_port_t mig_get_reply_port();
extern void mig_dealloc_reply_port();

#ifndef	mig_internal
#define	mig_internal	static
#endif

#ifndef	mig_external
#define mig_external
#endif

#ifndef	TypeCheck
#define	TypeCheck 1
#endif

#ifndef	UseExternRCSId
#ifdef	hc
#define	UseExternRCSId		1
#endif
#endif

#ifndef	UseStaticMsgType
#if	!defined(hc) || defined(__STDC__)
#define	UseStaticMsgType	1
#endif
#endif

#define msgh_request_port	msgh_remote_port
#define msgh_reply_port		msgh_local_port


/* SimpleRoutine proc_wait_reply */
mig_external kern_return_t proc_wait_reply
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t reply_port,
	mach_msg_type_name_t reply_portPoly,
	kern_return_t retcode,
	int status,
	rusage_t rusage,
	pid_t pid_status
)
#else
	(reply_port, reply_portPoly, retcode, status, rusage, pid_status)
	mach_port_t reply_port;
	mach_msg_type_name_t reply_portPoly;
	kern_return_t retcode;
	int status;
	rusage_t rusage;
	pid_t pid_status;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t retcodeType;
		kern_return_t retcode;
		mach_msg_type_t statusType;
		int status;
		mach_msg_type_t rusageType;
		rusage_t rusage;
		mach_msg_type_t pid_statusType;
		pid_t pid_status;
	} Request;

	union {
		Request In;
	} Mess;

	register Request *InP = &Mess.In;


#if	UseStaticMsgType
	static mach_msg_type_t retcodeType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t statusType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t rusageType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		18,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t pid_statusType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->retcodeType = retcodeType;
#else	UseStaticMsgType
	InP->retcodeType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->retcodeType.msgt_size = 32;
	InP->retcodeType.msgt_number = 1;
	InP->retcodeType.msgt_inline = TRUE;
	InP->retcodeType.msgt_longform = FALSE;
	InP->retcodeType.msgt_deallocate = FALSE;
	InP->retcodeType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->retcode = retcode;

#if	UseStaticMsgType
	InP->statusType = statusType;
#else	UseStaticMsgType
	InP->statusType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->statusType.msgt_size = 32;
	InP->statusType.msgt_number = 1;
	InP->statusType.msgt_inline = TRUE;
	InP->statusType.msgt_longform = FALSE;
	InP->statusType.msgt_deallocate = FALSE;
	InP->statusType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->status = status;

#if	UseStaticMsgType
	InP->rusageType = rusageType;
#else	UseStaticMsgType
	InP->rusageType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->rusageType.msgt_size = 32;
	InP->rusageType.msgt_number = 18;
	InP->rusageType.msgt_inline = TRUE;
	InP->rusageType.msgt_longform = FALSE;
	InP->rusageType.msgt_deallocate = FALSE;
	InP->rusageType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->rusage = rusage;

#if	UseStaticMsgType
	InP->pid_statusType = pid_statusType;
#else	UseStaticMsgType
	InP->pid_statusType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	InP->pid_statusType.msgt_size = 32;
	InP->pid_statusType.msgt_number = 1;
	InP->pid_statusType.msgt_inline = TRUE;
	InP->pid_statusType.msgt_longform = FALSE;
	InP->pid_statusType.msgt_deallocate = FALSE;
	InP->pid_statusType.msgt_unused = 0;
#endif	UseStaticMsgType

	InP->pid_status = pid_status;

	InP->Head.msgh_bits =
		MACH_MSGH_BITS(reply_portPoly, 0);
	/* msgh_size passed as argument */
	InP->Head.msgh_request_port = reply_port;
	InP->Head.msgh_reply_port = MACH_PORT_NULL;
	InP->Head.msgh_seqno = 0;
	InP->Head.msgh_id = 24111;

	return mach_msg(&InP->Head, MACH_SEND_MSG|MACH_MSG_OPTION_NONE, sizeof(Request), 0, MACH_PORT_NULL, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
}
