/*
   Copyright (C) 1992 Free Software Foundation

This file is part of the GNU Hurd.

The GNU Hurd is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

The GNU Hurd is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the GNU Hurd; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by Roland McGrath.  */

#include <string.h>
#include <stdlib.h>

extern char *program_invocation_name;

tfs_file_set_translator (mach_port_t file,
			 int flags,
			 int oflags,
			 char *trans, size_t translen,
			 mach_port_t existing)
{
  int err;
  size_t mylen = strlen (program_invocation_name) + 1;
  char realtrans[mylen + 1 + translen];

  if (tfs_translator_cntl != MACH_PORT_NULL)
    {
      if (flags & FS_TRANS_EXCL)
	return EBUSY;
      if (err = fsys_goaway (tfs_translator_cntl, oflags))
	return err;
      mach_port_deallocate (mach_task_self (), tfs_translator_cntl);
      tfs_translator_cntl = MACH_PORT_NULL;
    }

  memcpy (realtrans, program_invocation_name, mylen);
  memcpy (&realtrans[mylen + 1], trans, translen);
  err = file_set_translator (tfs_underlying (file),
			     flags,
			     FSYS_GOAWAY_NOWAIT,
			     realtrans, sizeof (realtrans),
			     MACH_PORT_NULL);
  if (err)
    return err;

  if (existing != MACH_PORT_NULL)
    tfs_translator_cntl = existing;

  return 0;
}
