/* Module io */

#define EXPORT_BOOLEAN
#include <mach/boolean.h>
#include <mach/kern_return.h>
#include <mach/message.h>
#include <mach/mig_errors.h>

#ifndef	mig_internal
#define	mig_internal	static
#endif

#ifndef	mig_external
#define mig_external
#endif

#ifndef	TypeCheck
#define	TypeCheck 1
#endif

#ifndef	UseExternRCSId
#ifdef	hc
#define	UseExternRCSId		1
#endif
#endif

#ifndef	UseStaticMsgType
#if	!defined(hc) || defined(__STDC__)
#define	UseStaticMsgType	1
#endif
#endif

/* Due to pcc compiler bug, cannot use void */
#if	(defined(__STDC__) || defined(c_plusplus)) || defined(hc)
#define novalue void
#else
#define novalue int
#endif

#define msgh_request_port	msgh_local_port
#define MACH_MSGH_BITS_REQUEST(bits)	MACH_MSGH_BITS_LOCAL(bits)
#define msgh_reply_port		msgh_remote_port
#define MACH_MSGH_BITS_REPLY(bits)	MACH_MSGH_BITS_REMOTE(bits)

#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <device/device_types.h>
#include <device/net_status.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <hurd/hurd_types.h>
#include "ufs.h"

/* Routine io_write */
mig_internal novalue _Xio_write
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_long_t dataType;
		char data[2048];
		mach_msg_type_t offsetType;
		int offset;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t amountType;
		int amount;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Request *In1P;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t io_write
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t io_object, data_t data, mach_msg_type_number_t dataCnt, int offset, int *amount);
#else
		();
#endif

#if	TypeCheck
	boolean_t msgh_simple;
#endif	TypeCheck

	unsigned int msgh_size;
	unsigned int msgh_size_delta;

#if	UseStaticMsgType
	static mach_msg_type_t offsetCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t amountType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t io_object;

#if	TypeCheck
	msgh_size = In0P->Head.msgh_size;
	msgh_simple = !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX);
	if ((msgh_size < 44))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
	if ((In0P->dataType.msgtl_header.msgt_longform != TRUE) ||
	    (In0P->dataType.msgtl_name != MACH_MSG_TYPE_CHAR) ||
	    (In0P->dataType.msgtl_size != 8))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	msgh_size_delta = (In0P->dataType.msgtl_header.msgt_inline) ? In0P->dataType.msgtl_number + 3 & ~3 : sizeof(char *);
#if	TypeCheck
	if (msgh_size != 44 + msgh_size_delta)
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	In1P = (Request *) ((char *) In0P + msgh_size_delta - 2048);

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In1P->offsetType != * (int *) &offsetCheck)
#else	UseStaticMsgType
	if ((In1P->offsetType.msgt_inline != TRUE) ||
	    (In1P->offsetType.msgt_longform != FALSE) ||
	    (In1P->offsetType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In1P->offsetType.msgt_number != 1) ||
	    (In1P->offsetType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	io_object = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = io_write(io_object, (In0P->dataType.msgtl_header.msgt_inline) ? In0P->data : *((char **)In0P->data), In0P->dataType.msgtl_number, In1P->offset, &OutP->amount);
	if (!In0P->dataType.msgtl_header.msgt_inline)
		mig_deallocate(*(char **)In0P->data,  In0P->dataType.msgtl_number);
	release_protidport(io_object);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->amountType = amountType;
#else	UseStaticMsgType
	OutP->amountType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->amountType.msgt_size = 32;
	OutP->amountType.msgt_number = 1;
	OutP->amountType.msgt_inline = TRUE;
	OutP->amountType.msgt_longform = FALSE;
	OutP->amountType.msgt_deallocate = FALSE;
	OutP->amountType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine io_read */
mig_internal novalue _Xio_read
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t offsetType;
		int offset;
		mach_msg_type_t amountType;
		int amount;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_long_t dataType;
		char data[2048];
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t io_read
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t io_object, data_t *data, mach_msg_type_number_t *dataCnt, int offset, int amount);
#else
		();
#endif

	boolean_t msgh_simple;
#if	UseStaticMsgType
	static mach_msg_type_t offsetCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t amountCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_long_t dataType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	MACH_MSG_TYPE_CHAR,
		/* msgtl_size = */	8,
		/* msgtl_number = */	2048,
	};
#endif	UseStaticMsgType

	protid_t io_object;
	mach_msg_type_number_t dataCnt;

	char *dataP;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 40) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->offsetType != * (int *) &offsetCheck)
#else	UseStaticMsgType
	if ((In0P->offsetType.msgt_inline != TRUE) ||
	    (In0P->offsetType.msgt_longform != FALSE) ||
	    (In0P->offsetType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->offsetType.msgt_number != 1) ||
	    (In0P->offsetType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->amountType != * (int *) &amountCheck)
#else	UseStaticMsgType
	if ((In0P->amountType.msgt_inline != TRUE) ||
	    (In0P->amountType.msgt_longform != FALSE) ||
	    (In0P->amountType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->amountType.msgt_number != 1) ||
	    (In0P->amountType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	io_object = convert_port_to_protid(In0P->Head.msgh_request_port);

	dataP = OutP->data;
	dataCnt = 2048;

	OutP->RetCode = io_read(io_object, &dataP, &dataCnt, In0P->offset, In0P->amount);
	release_protidport(io_object);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	msgh_simple = TRUE;

#if	UseStaticMsgType
	OutP->dataType = dataType;
#else	UseStaticMsgType
	OutP->dataType.msgtl_name = MACH_MSG_TYPE_CHAR;
	OutP->dataType.msgtl_size = 8;
	OutP->dataType.msgtl_header.msgt_name = 0;
	OutP->dataType.msgtl_header.msgt_size = 0;
	OutP->dataType.msgtl_header.msgt_number = 0;
	OutP->dataType.msgtl_header.msgt_inline = TRUE;
	OutP->dataType.msgtl_header.msgt_longform = TRUE;
	OutP->dataType.msgtl_header.msgt_deallocate = FALSE;
	OutP->dataType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType
	if (dataP != OutP->data) {
		OutP->dataType.msgtl_header.msgt_inline = FALSE;
		*((char **)OutP->data) = dataP;
		msgh_simple = FALSE;
	}

	OutP->dataType.msgtl_number = dataCnt;
	OutP->Head.msgh_size = 44 + ((OutP->dataType.msgtl_header.msgt_inline) ? dataCnt + 3 & ~3 : sizeof(char *));

	if (!msgh_simple)
		OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
}

/* Routine io_readable */
mig_internal novalue _Xio_readable
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t amountType;
		int amount;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t io_readable
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t io_object, int *amount);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t amountType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t io_object;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	io_object = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = io_readable(io_object, &OutP->amount);
	release_protidport(io_object);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->amountType = amountType;
#else	UseStaticMsgType
	OutP->amountType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->amountType.msgt_size = 32;
	OutP->amountType.msgt_number = 1;
	OutP->amountType.msgt_inline = TRUE;
	OutP->amountType.msgt_longform = FALSE;
	OutP->amountType.msgt_deallocate = FALSE;
	OutP->amountType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine io_mod_nonblock */
mig_internal novalue _Xio_mod_nonblock
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t on_or_offType;
		int on_or_off;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t io_mod_nonblock
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t io_object, int on_or_off);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t on_or_offCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t io_object;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->on_or_offType != * (int *) &on_or_offCheck)
#else	UseStaticMsgType
	if ((In0P->on_or_offType.msgt_inline != TRUE) ||
	    (In0P->on_or_offType.msgt_longform != FALSE) ||
	    (In0P->on_or_offType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->on_or_offType.msgt_number != 1) ||
	    (In0P->on_or_offType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	io_object = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = io_mod_nonblock(io_object, In0P->on_or_off);
	release_protidport(io_object);
}

/* Routine io_get_nonblock */
mig_internal novalue _Xio_get_nonblock
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t on_or_offType;
		int on_or_off;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t io_get_nonblock
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t io_object, int *on_or_off);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t on_or_offType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t io_object;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	io_object = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = io_get_nonblock(io_object, &OutP->on_or_off);
	release_protidport(io_object);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->on_or_offType = on_or_offType;
#else	UseStaticMsgType
	OutP->on_or_offType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->on_or_offType.msgt_size = 32;
	OutP->on_or_offType.msgt_number = 1;
	OutP->on_or_offType.msgt_inline = TRUE;
	OutP->on_or_offType.msgt_longform = FALSE;
	OutP->on_or_offType.msgt_deallocate = FALSE;
	OutP->on_or_offType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine io_mod_append */
mig_internal novalue _Xio_mod_append
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t on_or_offType;
		int on_or_off;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t io_mod_append
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t io_object, int on_or_off);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t on_or_offCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t io_object;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->on_or_offType != * (int *) &on_or_offCheck)
#else	UseStaticMsgType
	if ((In0P->on_or_offType.msgt_inline != TRUE) ||
	    (In0P->on_or_offType.msgt_longform != FALSE) ||
	    (In0P->on_or_offType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->on_or_offType.msgt_number != 1) ||
	    (In0P->on_or_offType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	io_object = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = io_mod_append(io_object, In0P->on_or_off);
	release_protidport(io_object);
}

/* Routine io_get_append */
mig_internal novalue _Xio_get_append
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t on_or_offType;
		int on_or_off;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t io_get_append
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t io_object, int *on_or_off);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t on_or_offType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t io_object;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	io_object = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = io_get_append(io_object, &OutP->on_or_off);
	release_protidport(io_object);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->on_or_offType = on_or_offType;
#else	UseStaticMsgType
	OutP->on_or_offType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->on_or_offType.msgt_size = 32;
	OutP->on_or_offType.msgt_number = 1;
	OutP->on_or_offType.msgt_inline = TRUE;
	OutP->on_or_offType.msgt_longform = FALSE;
	OutP->on_or_offType.msgt_deallocate = FALSE;
	OutP->on_or_offType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine io_async */
mig_internal novalue _Xio_async
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t notify_portType;
		mach_port_t notify_port;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t async_id_portType;
		mach_port_t async_id_port;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t io_async
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t io_object, mach_port_t notify_port, mach_port_t *async_id_port);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t notify_portCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t async_id_portType = {
		/* msgt_name = */		MACH_MSG_TYPE_COPY_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t io_object;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->notify_portType != * (int *) &notify_portCheck)
#else	UseStaticMsgType
	if ((In0P->notify_portType.msgt_inline != TRUE) ||
	    (In0P->notify_portType.msgt_longform != FALSE) ||
	    (In0P->notify_portType.msgt_name != MACH_MSG_TYPE_PORT_SEND) ||
	    (In0P->notify_portType.msgt_number != 1) ||
	    (In0P->notify_portType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	io_object = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = io_async(io_object, In0P->notify_port, &OutP->async_id_port);
	release_protidport(io_object);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->async_id_portType = async_id_portType;
#else	UseStaticMsgType
	OutP->async_id_portType.msgt_name = MACH_MSG_TYPE_COPY_SEND;
	OutP->async_id_portType.msgt_size = 32;
	OutP->async_id_portType.msgt_number = 1;
	OutP->async_id_portType.msgt_inline = TRUE;
	OutP->async_id_portType.msgt_longform = FALSE;
	OutP->async_id_portType.msgt_deallocate = FALSE;
	OutP->async_id_portType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine io_mod_owner */
mig_internal novalue _Xio_mod_owner
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t ownerType;
		pid_t owner;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t io_mod_owner
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t io_object, pid_t owner);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t ownerCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t io_object;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->ownerType != * (int *) &ownerCheck)
#else	UseStaticMsgType
	if ((In0P->ownerType.msgt_inline != TRUE) ||
	    (In0P->ownerType.msgt_longform != FALSE) ||
	    (In0P->ownerType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->ownerType.msgt_number != 1) ||
	    (In0P->ownerType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	io_object = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = io_mod_owner(io_object, In0P->owner);
	release_protidport(io_object);
}

/* Routine io_get_owner */
mig_internal novalue _Xio_get_owner
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t ownerType;
		pid_t owner;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t io_get_owner
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t io_object, pid_t *owner);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t ownerType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t io_object;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	io_object = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = io_get_owner(io_object, &OutP->owner);
	release_protidport(io_object);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->ownerType = ownerType;
#else	UseStaticMsgType
	OutP->ownerType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->ownerType.msgt_size = 32;
	OutP->ownerType.msgt_number = 1;
	OutP->ownerType.msgt_inline = TRUE;
	OutP->ownerType.msgt_longform = FALSE;
	OutP->ownerType.msgt_deallocate = FALSE;
	OutP->ownerType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine io_mod_async_icky */
mig_internal novalue _Xio_mod_async_icky
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t on_or_offType;
		int on_or_off;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t icky_async_id_portType;
		mach_port_t icky_async_id_port;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t io_mod_async_icky
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t io_object, int on_or_off, mach_port_t *icky_async_id_port);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t on_or_offCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t icky_async_id_portType = {
		/* msgt_name = */		MACH_MSG_TYPE_COPY_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t io_object;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->on_or_offType != * (int *) &on_or_offCheck)
#else	UseStaticMsgType
	if ((In0P->on_or_offType.msgt_inline != TRUE) ||
	    (In0P->on_or_offType.msgt_longform != FALSE) ||
	    (In0P->on_or_offType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->on_or_offType.msgt_number != 1) ||
	    (In0P->on_or_offType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	io_object = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = io_mod_async_icky(io_object, In0P->on_or_off, &OutP->icky_async_id_port);
	release_protidport(io_object);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->icky_async_id_portType = icky_async_id_portType;
#else	UseStaticMsgType
	OutP->icky_async_id_portType.msgt_name = MACH_MSG_TYPE_COPY_SEND;
	OutP->icky_async_id_portType.msgt_size = 32;
	OutP->icky_async_id_portType.msgt_number = 1;
	OutP->icky_async_id_portType.msgt_inline = TRUE;
	OutP->icky_async_id_portType.msgt_longform = FALSE;
	OutP->icky_async_id_portType.msgt_deallocate = FALSE;
	OutP->icky_async_id_portType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine io_get_icky_async_id */
mig_internal novalue _Xio_get_icky_async_id
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t icky_async_id_portType;
		mach_port_t icky_async_id_port;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t io_get_icky_async_id
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t io_object, mach_port_t *icky_async_id_port);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t icky_async_id_portType = {
		/* msgt_name = */		MACH_MSG_TYPE_COPY_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t io_object;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	io_object = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = io_get_icky_async_id(io_object, &OutP->icky_async_id_port);
	release_protidport(io_object);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->icky_async_id_portType = icky_async_id_portType;
#else	UseStaticMsgType
	OutP->icky_async_id_portType.msgt_name = MACH_MSG_TYPE_COPY_SEND;
	OutP->icky_async_id_portType.msgt_size = 32;
	OutP->icky_async_id_portType.msgt_number = 1;
	OutP->icky_async_id_portType.msgt_inline = TRUE;
	OutP->icky_async_id_portType.msgt_longform = FALSE;
	OutP->icky_async_id_portType.msgt_deallocate = FALSE;
	OutP->icky_async_id_portType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine io_get_async_icky */
mig_internal novalue _Xio_get_async_icky
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t on_or_offType;
		int on_or_off;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t io_get_async_icky
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t io_object, int *on_or_off);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t on_or_offType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t io_object;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	io_object = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = io_get_async_icky(io_object, &OutP->on_or_off);
	release_protidport(io_object);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->on_or_offType = on_or_offType;
#else	UseStaticMsgType
	OutP->on_or_offType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->on_or_offType.msgt_size = 32;
	OutP->on_or_offType.msgt_number = 1;
	OutP->on_or_offType.msgt_inline = TRUE;
	OutP->on_or_offType.msgt_longform = FALSE;
	OutP->on_or_offType.msgt_deallocate = FALSE;
	OutP->on_or_offType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine io_get_openstat */
mig_internal novalue _Xio_get_openstat
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t open_statType;
		int open_stat;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t io_get_openstat
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t io_object, int *open_stat);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t open_statType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t io_object;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	io_object = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = io_get_openstat(io_object, &OutP->open_stat);
	release_protidport(io_object);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->open_statType = open_statType;
#else	UseStaticMsgType
	OutP->open_statType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->open_statType.msgt_size = 32;
	OutP->open_statType.msgt_number = 1;
	OutP->open_statType.msgt_inline = TRUE;
	OutP->open_statType.msgt_longform = FALSE;
	OutP->open_statType.msgt_deallocate = FALSE;
	OutP->open_statType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine io_select */
mig_internal novalue _Xio_select
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t select_typeType;
		int select_type;
		mach_msg_type_t return_portType;
		mach_port_t return_port;
		mach_msg_type_t id_tagType;
		int id_tag;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t select_resultType;
		int select_result;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t io_select
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t io_object, int select_type, mach_port_t return_port, int id_tag, int *select_result);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t select_typeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t return_portCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_SEND_ONCE,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t id_tagCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t select_resultType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t io_object;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 48) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->select_typeType != * (int *) &select_typeCheck)
#else	UseStaticMsgType
	if ((In0P->select_typeType.msgt_inline != TRUE) ||
	    (In0P->select_typeType.msgt_longform != FALSE) ||
	    (In0P->select_typeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->select_typeType.msgt_number != 1) ||
	    (In0P->select_typeType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->return_portType != * (int *) &return_portCheck)
#else	UseStaticMsgType
	if ((In0P->return_portType.msgt_inline != TRUE) ||
	    (In0P->return_portType.msgt_longform != FALSE) ||
	    (In0P->return_portType.msgt_name != MACH_MSG_TYPE_PORT_SEND_ONCE) ||
	    (In0P->return_portType.msgt_number != 1) ||
	    (In0P->return_portType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->id_tagType != * (int *) &id_tagCheck)
#else	UseStaticMsgType
	if ((In0P->id_tagType.msgt_inline != TRUE) ||
	    (In0P->id_tagType.msgt_longform != FALSE) ||
	    (In0P->id_tagType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->id_tagType.msgt_number != 1) ||
	    (In0P->id_tagType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	io_object = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = io_select(io_object, In0P->select_type, In0P->return_port, In0P->id_tag, &OutP->select_result);
	release_protidport(io_object);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->select_resultType = select_resultType;
#else	UseStaticMsgType
	OutP->select_resultType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->select_resultType.msgt_size = 32;
	OutP->select_resultType.msgt_number = 1;
	OutP->select_resultType.msgt_inline = TRUE;
	OutP->select_resultType.msgt_longform = FALSE;
	OutP->select_resultType.msgt_deallocate = FALSE;
	OutP->select_resultType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine io_stat */
mig_internal novalue _Xio_stat
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t stat_infoType;
		io_statbuf_t stat_info;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t io_stat
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t stat_object, io_statbuf_t *stat_info);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t stat_infoType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		28,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t stat_object;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	stat_object = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = io_stat(stat_object, &OutP->stat_info);
	release_protidport(stat_object);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 148;

#if	UseStaticMsgType
	OutP->stat_infoType = stat_infoType;
#else	UseStaticMsgType
	OutP->stat_infoType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->stat_infoType.msgt_size = 32;
	OutP->stat_infoType.msgt_number = 28;
	OutP->stat_infoType.msgt_inline = TRUE;
	OutP->stat_infoType.msgt_longform = FALSE;
	OutP->stat_infoType.msgt_deallocate = FALSE;
	OutP->stat_infoType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* SimpleRoutine io_reauthenticate */
mig_internal novalue _Xio_reauthenticate
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t io_reauthenticate
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t auth_object);
#else
		();
#endif

	protid_t auth_object;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	auth_object = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = io_reauthenticate(auth_object);
	release_protidport(auth_object);
}

/* Routine io_server_version */
mig_internal novalue _Xio_server_version
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t server_nameType;
		string_t server_name;
		mach_msg_type_t server_major_versionType;
		int server_major_version;
		mach_msg_type_t server_minor_versionType;
		int server_minor_version;
		mach_msg_type_t server_edit_levelType;
		int server_edit_level;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t io_server_version
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t vers_object, string_t server_name, int *server_major_version, int *server_minor_version, int *server_edit_level);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t server_nameType = {
		/* msgt_name = */		MACH_MSG_TYPE_STRING_C,
		/* msgt_size = */		8,
		/* msgt_number = */		1024,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t server_major_versionType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t server_minor_versionType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t server_edit_levelType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t vers_object;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	vers_object = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = io_server_version(vers_object, OutP->server_name, &OutP->server_major_version, &OutP->server_minor_version, &OutP->server_edit_level);
	release_protidport(vers_object);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 1084;

#if	UseStaticMsgType
	OutP->server_nameType = server_nameType;
#else	UseStaticMsgType
	OutP->server_nameType.msgt_name = MACH_MSG_TYPE_STRING_C;
	OutP->server_nameType.msgt_size = 8;
	OutP->server_nameType.msgt_number = 1024;
	OutP->server_nameType.msgt_inline = TRUE;
	OutP->server_nameType.msgt_longform = FALSE;
	OutP->server_nameType.msgt_deallocate = FALSE;
	OutP->server_nameType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->server_major_versionType = server_major_versionType;
#else	UseStaticMsgType
	OutP->server_major_versionType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->server_major_versionType.msgt_size = 32;
	OutP->server_major_versionType.msgt_number = 1;
	OutP->server_major_versionType.msgt_inline = TRUE;
	OutP->server_major_versionType.msgt_longform = FALSE;
	OutP->server_major_versionType.msgt_deallocate = FALSE;
	OutP->server_major_versionType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->server_minor_versionType = server_minor_versionType;
#else	UseStaticMsgType
	OutP->server_minor_versionType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->server_minor_versionType.msgt_size = 32;
	OutP->server_minor_versionType.msgt_number = 1;
	OutP->server_minor_versionType.msgt_inline = TRUE;
	OutP->server_minor_versionType.msgt_longform = FALSE;
	OutP->server_minor_versionType.msgt_deallocate = FALSE;
	OutP->server_minor_versionType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->server_edit_levelType = server_edit_levelType;
#else	UseStaticMsgType
	OutP->server_edit_levelType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->server_edit_levelType.msgt_size = 32;
	OutP->server_edit_levelType.msgt_number = 1;
	OutP->server_edit_levelType.msgt_inline = TRUE;
	OutP->server_edit_levelType.msgt_longform = FALSE;
	OutP->server_edit_levelType.msgt_deallocate = FALSE;
	OutP->server_edit_levelType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine io_map */
mig_internal novalue _Xio_map
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t memobjxxType;
		mach_port_t memobjxx;
		mach_msg_type_t memobjrdType;
		mach_port_t memobjrd;
		mach_msg_type_t memobjwtType;
		mach_port_t memobjwt;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t io_map
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t io_object, mach_port_t *memobjxx, mach_port_t *memobjrd, mach_port_t *memobjwt);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t memobjxxType = {
		/* msgt_name = */		MACH_MSG_TYPE_MOVE_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t memobjrdType = {
		/* msgt_name = */		MACH_MSG_TYPE_MOVE_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t memobjwtType = {
		/* msgt_name = */		MACH_MSG_TYPE_MOVE_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t io_object;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	io_object = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = io_map(io_object, &OutP->memobjxx, &OutP->memobjrd, &OutP->memobjwt);
	release_protidport(io_object);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
	OutP->Head.msgh_size = 56;

#if	UseStaticMsgType
	OutP->memobjxxType = memobjxxType;
#else	UseStaticMsgType
	OutP->memobjxxType.msgt_name = MACH_MSG_TYPE_MOVE_SEND;
	OutP->memobjxxType.msgt_size = 32;
	OutP->memobjxxType.msgt_number = 1;
	OutP->memobjxxType.msgt_inline = TRUE;
	OutP->memobjxxType.msgt_longform = FALSE;
	OutP->memobjxxType.msgt_deallocate = FALSE;
	OutP->memobjxxType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->memobjrdType = memobjrdType;
#else	UseStaticMsgType
	OutP->memobjrdType.msgt_name = MACH_MSG_TYPE_MOVE_SEND;
	OutP->memobjrdType.msgt_size = 32;
	OutP->memobjrdType.msgt_number = 1;
	OutP->memobjrdType.msgt_inline = TRUE;
	OutP->memobjrdType.msgt_longform = FALSE;
	OutP->memobjrdType.msgt_deallocate = FALSE;
	OutP->memobjrdType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->memobjwtType = memobjwtType;
#else	UseStaticMsgType
	OutP->memobjwtType.msgt_name = MACH_MSG_TYPE_MOVE_SEND;
	OutP->memobjwtType.msgt_size = 32;
	OutP->memobjwtType.msgt_number = 1;
	OutP->memobjwtType.msgt_inline = TRUE;
	OutP->memobjwtType.msgt_longform = FALSE;
	OutP->memobjwtType.msgt_deallocate = FALSE;
	OutP->memobjwtType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine io_map_cntl */
mig_internal novalue _Xio_map_cntl
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t memobjType;
		mach_port_t memobj;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t io_map_cntl
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t io_object, mach_port_t *memobj);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t memobjType = {
		/* msgt_name = */		MACH_MSG_TYPE_COPY_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t io_object;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	io_object = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = io_map_cntl(io_object, &OutP->memobj);
	release_protidport(io_object);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->memobjType = memobjType;
#else	UseStaticMsgType
	OutP->memobjType.msgt_name = MACH_MSG_TYPE_COPY_SEND;
	OutP->memobjType.msgt_size = 32;
	OutP->memobjType.msgt_number = 1;
	OutP->memobjType.msgt_inline = TRUE;
	OutP->memobjType.msgt_longform = FALSE;
	OutP->memobjType.msgt_deallocate = FALSE;
	OutP->memobjType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine io_get_it */
mig_internal novalue _Xio_get_it
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t cntlType;
		mach_port_t cntl;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t io_get_it
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t io_object, mach_port_t cntl);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t cntlCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t io_object;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->cntlType != * (int *) &cntlCheck)
#else	UseStaticMsgType
	if ((In0P->cntlType.msgt_inline != TRUE) ||
	    (In0P->cntlType.msgt_longform != FALSE) ||
	    (In0P->cntlType.msgt_name != MACH_MSG_TYPE_PORT_SEND) ||
	    (In0P->cntlType.msgt_number != 1) ||
	    (In0P->cntlType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	io_object = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = io_get_it(io_object, In0P->cntl);
	release_protidport(io_object);
}

/* Routine io_release_it */
mig_internal novalue _Xio_release_it
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t cntlType;
		mach_port_t cntl;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t io_release_it
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t io_object, mach_port_t cntl);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t cntlCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t io_object;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->cntlType != * (int *) &cntlCheck)
#else	UseStaticMsgType
	if ((In0P->cntlType.msgt_inline != TRUE) ||
	    (In0P->cntlType.msgt_longform != FALSE) ||
	    (In0P->cntlType.msgt_name != MACH_MSG_TYPE_PORT_SEND) ||
	    (In0P->cntlType.msgt_number != 1) ||
	    (In0P->cntlType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	io_object = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = io_release_it(io_object, In0P->cntl);
	release_protidport(io_object);
}

/* Routine io_eofnotify */
mig_internal novalue _Xio_eofnotify
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t cntlType;
		mach_port_t cntl;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t io_eofnotify
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t io_object, mach_port_t cntl);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t cntlCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t io_object;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->cntlType != * (int *) &cntlCheck)
#else	UseStaticMsgType
	if ((In0P->cntlType.msgt_inline != TRUE) ||
	    (In0P->cntlType.msgt_longform != FALSE) ||
	    (In0P->cntlType.msgt_name != MACH_MSG_TYPE_PORT_SEND) ||
	    (In0P->cntlType.msgt_number != 1) ||
	    (In0P->cntlType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	io_object = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = io_eofnotify(io_object, In0P->cntl);
	release_protidport(io_object);
}

/* Routine io_prenotify */
mig_internal novalue _Xio_prenotify
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t cntlType;
		mach_port_t cntl;
		mach_msg_type_t write_startType;
		int write_start;
		mach_msg_type_t write_endType;
		int write_end;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t io_prenotify
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t io_object, mach_port_t cntl, int write_start, int write_end);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t cntlCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t write_startCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t write_endCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t io_object;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 48) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->cntlType != * (int *) &cntlCheck)
#else	UseStaticMsgType
	if ((In0P->cntlType.msgt_inline != TRUE) ||
	    (In0P->cntlType.msgt_longform != FALSE) ||
	    (In0P->cntlType.msgt_name != MACH_MSG_TYPE_PORT_SEND) ||
	    (In0P->cntlType.msgt_number != 1) ||
	    (In0P->cntlType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->write_startType != * (int *) &write_startCheck)
#else	UseStaticMsgType
	if ((In0P->write_startType.msgt_inline != TRUE) ||
	    (In0P->write_startType.msgt_longform != FALSE) ||
	    (In0P->write_startType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->write_startType.msgt_number != 1) ||
	    (In0P->write_startType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->write_endType != * (int *) &write_endCheck)
#else	UseStaticMsgType
	if ((In0P->write_endType.msgt_inline != TRUE) ||
	    (In0P->write_endType.msgt_longform != FALSE) ||
	    (In0P->write_endType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->write_endType.msgt_number != 1) ||
	    (In0P->write_endType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	io_object = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = io_prenotify(io_object, In0P->cntl, In0P->write_start, In0P->write_end);
	release_protidport(io_object);
}

/* Routine io_postnotify */
mig_internal novalue _Xio_postnotify
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t cntlType;
		mach_port_t cntl;
		mach_msg_type_t write_startType;
		int write_start;
		mach_msg_type_t write_endType;
		int write_end;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t io_postnotify
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t io_object, mach_port_t cntl, int write_start, int write_end);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t cntlCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t write_startCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t write_endCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t io_object;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 48) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->cntlType != * (int *) &cntlCheck)
#else	UseStaticMsgType
	if ((In0P->cntlType.msgt_inline != TRUE) ||
	    (In0P->cntlType.msgt_longform != FALSE) ||
	    (In0P->cntlType.msgt_name != MACH_MSG_TYPE_PORT_SEND) ||
	    (In0P->cntlType.msgt_number != 1) ||
	    (In0P->cntlType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->write_startType != * (int *) &write_startCheck)
#else	UseStaticMsgType
	if ((In0P->write_startType.msgt_inline != TRUE) ||
	    (In0P->write_startType.msgt_longform != FALSE) ||
	    (In0P->write_startType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->write_startType.msgt_number != 1) ||
	    (In0P->write_startType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->write_endType != * (int *) &write_endCheck)
#else	UseStaticMsgType
	if ((In0P->write_endType.msgt_inline != TRUE) ||
	    (In0P->write_endType.msgt_longform != FALSE) ||
	    (In0P->write_endType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->write_endType.msgt_number != 1) ||
	    (In0P->write_endType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	io_object = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = io_postnotify(io_object, In0P->cntl, In0P->write_start, In0P->write_end);
	release_protidport(io_object);
}

/* Routine io_readsleep */
mig_internal novalue _Xio_readsleep
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t cntlType;
		mach_port_t cntl;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t io_readsleep
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t io_object, mach_port_t cntl);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t cntlCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t io_object;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->cntlType != * (int *) &cntlCheck)
#else	UseStaticMsgType
	if ((In0P->cntlType.msgt_inline != TRUE) ||
	    (In0P->cntlType.msgt_longform != FALSE) ||
	    (In0P->cntlType.msgt_name != MACH_MSG_TYPE_PORT_SEND) ||
	    (In0P->cntlType.msgt_number != 1) ||
	    (In0P->cntlType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	io_object = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = io_readsleep(io_object, In0P->cntl);
	release_protidport(io_object);
}

/* Routine io_sigio */
mig_internal novalue _Xio_sigio
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t cntlType;
		mach_port_t cntl;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t io_sigio
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t io_object, mach_port_t cntl);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t cntlCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t io_object;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->cntlType != * (int *) &cntlCheck)
#else	UseStaticMsgType
	if ((In0P->cntlType.msgt_inline != TRUE) ||
	    (In0P->cntlType.msgt_longform != FALSE) ||
	    (In0P->cntlType.msgt_name != MACH_MSG_TYPE_PORT_SEND) ||
	    (In0P->cntlType.msgt_number != 1) ||
	    (In0P->cntlType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	io_object = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = io_sigio(io_object, In0P->cntl);
	release_protidport(io_object);
}

static mig_routine_t io_server_routines[] = {
		_Xio_write,
		_Xio_read,
		_Xio_readable,
		_Xio_mod_nonblock,
		_Xio_get_nonblock,
		_Xio_mod_append,
		_Xio_get_append,
		_Xio_async,
		_Xio_mod_owner,
		_Xio_get_owner,
		_Xio_mod_async_icky,
		_Xio_get_icky_async_id,
		_Xio_get_async_icky,
		_Xio_get_openstat,
		_Xio_select,
		_Xio_stat,
		_Xio_reauthenticate,
		_Xio_server_version,
		_Xio_map,
		_Xio_map_cntl,
		_Xio_get_it,
		_Xio_release_it,
		_Xio_eofnotify,
		_Xio_prenotify,
		_Xio_postnotify,
		_Xio_readsleep,
		_Xio_sigio,
};

mig_external boolean_t io_server
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	register mach_msg_header_t *InP =  InHeadP;
	register mig_reply_header_t *OutP = (mig_reply_header_t *) OutHeadP;

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	register mig_routine_t routine;

	OutP->Head.msgh_bits = MACH_MSGH_BITS(MACH_MSGH_BITS_REPLY(InP->msgh_bits), 0);
	OutP->Head.msgh_size = sizeof *OutP;
	OutP->Head.msgh_remote_port = InP->msgh_reply_port;
	OutP->Head.msgh_local_port = MACH_PORT_NULL;
	OutP->Head.msgh_seqno = 0;
	OutP->Head.msgh_id = InP->msgh_id + 100;

#if	UseStaticMsgType
	OutP->RetCodeType = RetCodeType;
#else	UseStaticMsgType
	OutP->RetCodeType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->RetCodeType.msgt_size = 32;
	OutP->RetCodeType.msgt_number = 1;
	OutP->RetCodeType.msgt_inline = TRUE;
	OutP->RetCodeType.msgt_longform = FALSE;
	OutP->RetCodeType.msgt_deallocate = FALSE;
	OutP->RetCodeType.msgt_unused = 0;
#endif	UseStaticMsgType

	if ((InP->msgh_id > 21026) || (InP->msgh_id < 21000) ||
	    ((routine = io_server_routines[InP->msgh_id - 21000]) == 0)) {
		OutP->RetCode = MIG_BAD_ID;
		return FALSE;
	}
	(*routine) (InP, &OutP->Head);
	return TRUE;
}

mig_external mig_routine_t io_server_routine
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP)
#else
	(InHeadP)
	mach_msg_header_t *InHeadP;
#endif
{
	register int msgh_id;

	msgh_id = InHeadP->msgh_id - 21000;

	if ((msgh_id > 26) || (msgh_id < 0))
		return 0;

	return io_server_routines[msgh_id];
}

