/*	$NetBSD: async.h,v 1.5 2021/12/19 11:39:38 riastradh Exp $	*/

/*-
 * Copyright (c) 2018 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Taylor R. Campbell.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _LINUX_ASYNC_H_
#define _LINUX_ASYNC_H_

typedef unsigned long async_cookie_t;

/*
 * async_schedule(fn, arg)
 *
 *	Schedule the kernel to run fn(arg, cookie) at some point to
 *	avoid slowing down boot, or call it synchronously if memory is
 *	short.  Returns a cookie that can be used to wait for the
 *	function to have been called.
 */
static inline async_cookie_t
async_schedule(void (*fn)(void *, async_cookie_t), void *arg)
{

	(*fn)(arg, 1);
	return 1;
}

/*
 * async_synchronize_full()
 *
 *	Wait for all outstanding asynchronous actions to have completed
 *	before returning.
 */
static inline void
async_synchronize_full(void)
{
}

/*
 * async_synchronize_cookie(cookie)
 *
 *	Wait until the function passed to the async_schedule call that
 *	returned cookie has completed.
 */
static inline void
async_synchronize_cookie(unsigned long cookie)
{
}

#endif /* _LINUX_ASYNC_H_ */
