


     PCLCOMP(1) 					    PCLCOMP(1)



     NAME
	  pclcomp - Compress PCL graphics files.

     SYNOPSIS
	  pclcomp [ -0123drsvz ] [ -n num ] [ inputfile [ outputfile ]]


     DESCRIPTION
	  Pclcomp compresses (or decompresses) HP-PCL (Printer Control
	  Language) graphics data.  The supported compression modes
	  are 0 (uncompressed), 1, 2 and 3.  Pclcomp will read files
	  using any of the modes 0 through 3, and will output using
	  the modes which will give the best compression.  This
	  compressed version of the file may be sent directly to a PCL
	  compatible printer, thus reducing I/O bandwidth.  Pictures
	  may also be saved in compressed form, reducing disk usage.
	  In addition, PCL "imaging" files for the PaintJet XL are
	  also supported.

	  The options to pclcomp control the compression modes.  By
	  default, pclcomp will use all modes it knows about, but the
	  user may restrict which output modes it uses by specifying
	  them on the command line with the -0, -1, -2 and -3 options.
	  To decompress a file, simply specify -0 as the only mode to
	  use for output.  Mode 0 ( -0 ) should always be allowed
	  since modes 1, 2 and 3 cannot be guaranteed to be better
	  than mode 0 for all types of pictures.

	  The -z option disables the zero "strip" feature.  Since most
	  printers do zero "filling", pclcomp, by default, "strips"
	  the trailing zeros of each row (or plane) of data.  Some
	  printers or programs may require that zero "stripping" be
	  disabled.

	  By default, pclcomp expects the input raster width to be
	  2400 pixels (8" at 300 dpi), and if it is different (e.g.
	  PaintJet), then the raster width should be specified by the
	  Source Raster Width escape sequence <esc*r#S>. However, many
	  applications do not set the width and assume a default,
	  therefore, the user may use the -n option to pclcomp to
	  specify a new default raster width.  For PaintJet (8" at 180
	  dpi), the number should be 1440.  If the PCL file contains
	  the Source Raster Width escape sequence, it will override
	  this default.  If pclcomp thinks that more data is coming in
	  than the specified width, it will generate a warning, and
	  continue processing (and perhaps truncating) data.

	  The -r option causes pclcomp to append an <esc>E reset
	  sequence to the end of the job.

	  The DeskJet printer behaves slightly differently then a
	  LaserJet.  To account for this difference, specify the -d



				   - 1 -    Formatted:	April 22, 1991






     PCLCOMP(1) 					    PCLCOMP(1)



	  option to pclcomp.

	  Some applications send <esc>*rB and <esc>*rA sequences
	  between every row of graphics data.  The -s option to
	  pclcomp will "strip" all <esc>*rB sequences, and all
	  <esc>*rA sequences after the first occurrence of this
	  sequence. In addition, text and control characters residing
	  between <esc>*rA and <esc>*rB sequences will be discarded.
	  While this will work well for many jobs, it may have
	  problems on multi-page or complex jobs.

	  The input and output files may be specified on the command
	  line.  This is useful for MS-DOS users because stdin and
	  stdout are not opened in binary mode.

	  The -v option simply gives statistics to stderr about which
	  compression modes were used.

     EXAMPLES
	  To compress a PCL file for the PaintJet (A size page at 180 dpi), use:
	       pclcomp -01n 1440  < infile > outfile

	  To compress a PCL file for LaserJet III, use:
	       pclcomp infile outfile

	  To compress a PCL file for DeskJet, use:
	       pclcomp -d012 infile outfile

	  To fully decompress a PCL file, use:
	       pclcomp -0z < infile > outfile

     WARNINGS
	  If the -z option is specified, and pclcomp thinks the source
	  raster width is larger than the actual data, the output may
	  grow.

	  Be cautious when using the -s option.

	  Do not use stdin or stdout on MS-DOS type systems.

     AUTHOR
	  Tony Parkhurst, Hewlett-Packard, San Diego Division
	  (tony@sdd.hp.com)












				   - 2 -    Formatted:	April 22, 1991



