/*--------------------------*/
#include "sys/param.h"
#include "sys/types.h"
#include "sys/sysmacros.h"
#include "sys/dir.h"
#include "sys/signal.h"
#include "sys/user.h"
#include "sys/errno.h"
#include "sys/inline.h"
/*--------------------------*/
#include <stdio.h>
#include	<fcntl.h>
#include	<sys/mouse.h>

static int _fd = -1;

extern int errno;

/*---------------------------------------------------------------------------*/
int ms_init()
{
   struct mouseinfo pkt;

   if ((_fd = open("/dev/lmouse", O_RDONLY)) == -1) {
      printf("errno = %d\n", errno);
      perror("ms_init: open");
      return -1;
   }
/*
 else if (ioctl(_fd, MOUSEIOCREAD, &pkt) == -1 ) {
      perror("ms_init: ioctl");
      close(_fd );
      return -1;
   }
*/
   return 0;
} /* ms_init */

/*---------------------------------------------------------------------------*/
int ms_ioctl(cmd)
int cmd;
{
   struct mouseinfo pkt;

   if (cmd == 25) {
     if (ioctl(_fd, MOUSEIOCREAD, &pkt) == -1 ) {
         perror("ms_init: ioctl");
/*       close(_fd ); */
         return -1;
      }
      printf("ms_ioctl: status = 0x%x, xmotion = %d, ymotion = %d\n",
             pkt.status, pkt.xmotion, pkt.ymotion);
   }
   else if (ioctl(_fd, cmd, &pkt) == -1 ) {
      perror("ms_ioctl: ioctl");
/*    close(_fd ); */
      return -1;
   }

   return 0;
} /* ms_ioctl */

/*---------------------------------------------------------------------------*/
int ms_close()
{
   int rc = -1;

   if (_fd != -1) {
      rc = close(_fd );
      _fd = -1;
   }
   return rc;
} /* ms_close */

#ifdef NOT_NOW

/*
 * FUNCTION: BMSEMD_READ
 *		a routine to call when mouse data is available
 *
 * INPUT PARAMETERS
 *	none
 * OUTPUT PARAMETERS
 *	none
 */
void	bmsemd_read()
{
	MSEPKT	pkt;

	if	( _fd == -1 || ioctl(_fd,VPC_MOUSE_READ,&pkt) == -1 )
	{
#ifdef	DEBUG
		v86error(VERR_WARNING,"unable to get mouse data");
#endif
		return;
	}

	if	( pkt.status & MOVEMENT )	/* if the mouse moved */
		xy_bmouse( pkt.xmotion, pkt.ymotion );

	if	( pkt.status & BUT1CHNG )	/* if button 1 changed */
		btn_bmouse( 0, (int)(pkt.status & BUT1STAT) );

	if	( pkt.status & BUT2CHNG )	/* if button 2 changed */
		btn_bmouse( 1, (int)(pkt.status & BUT2STAT) );

	if	( pkt.status & BUT3CHNG )	/* if button 3 changed */
		btn_bmouse( 2, (int)(pkt.status & BUT3STAT) );
}
#endif /* NOT_NOW */

main()
{
   char str[80];
   int cmd;

   ms_init();
   for (cmd = 0; 0 <= cmd && cmd <= 25;) {
      printf("cmd? (0-25) > ");
      (void) gets(str);
      cmd = atoi(str);
      printf("mt: cmd = %d\n", cmd);
      if (0 <= cmd && cmd <= 25) ms_ioctl(cmd);
      else                      printf("exiting\n");
   }
   ms_close();
}
