
| This file contains two assembly language routines,
| for changing the colour of the screen border.

| written by Kenneth J. Hendrickson, kjh@usc.edu

| These routines used to be in start.x, which was fine as
| long as Minix-386 was not used.  These routines need to
| be assembled in 32-bit mode, and called in 32-bit mode,
| for Minix-386.

#ifdef WHITE_BORDER
.define		_white_border	| set console overscan (border) to white
.define		_black_border	| set console overscan (border) to black

#define VIDEO	0x10		| used in BIOS methods

	.text

|*===========================================================================*
|*				white_border				     *
|*===========================================================================*

| PUBLIC void white_border();
| Set the border on the console to white.

_white_border:
| The following 2 BIOS methods cannot be used if Minix is to run
| in protected mode.  They are provided here for informational
| purposes only, and are appropriately commented out.

| This method DOESN'T work for EGA/VGA!  It was designed primarily for CGA.
| In fact, this code puts the display into 40x25 mode for OAK VGA!  :-(
| 40x25 mode isn't initiated in Genoa VGA.
|	movb	ah,0x0b
|	movb	bh,0		| select border colour	
|	movb	bl,0x07		| colour 7=white
|	int	VIDEO		| select white border for pagewhite

| Use this method for EGA/VGA.
|	movb	ah,#0x10	| set palette registers, set attributes
|	movb	al,1		| select overscan (border) colour
|	movb	bh,0x07		| colour 7=white
|				|	1=blue, 2=green, 4=red
|	int	VIDEO		| select white border for pagewhite

| Since the BIOS methods don't work, we program the video controller directly.
#ifdef INTEL_32BITS
	mov	edx,#0x03da	| we should check for mono; mono uses 0x03ba
#else
	mov	dx,#0x03da	| we should check for mono; mono uses 0x03ba
#endif
white0:	in
	testb	al,#8
	jnz	white0		| wait here for something?  (BIOS does this.)
white1:	in
	testb	al,#8
	jz	white1
#ifdef INTEL_32BITS
	mov	edx,#0x03c0
#else
	mov	dx,#0x03c0
#endif
	movb	al,#0x11	| select overscan register
	out
	movb	al,#0x07	| colour 7=white
	out
	movb	al,#0x20
	out
	ret


|*===========================================================================*
|*				black_border				     *
|*===========================================================================*

| PUBLIC void black_border();
| Set the border on the console to black to prepare for screen blanking.

_black_border:
| The following 2 BIOS methods cannot be used if Minix is to run
| in protected mode.  They are provided here for informational
| purposes only, and are appropriately commented out.

| This method DOESN'T work for EGA/VGA!  It was designed primarily for CGA.
| In fact, this code puts the display into 40x25 mode for OAK VGA!  :-(
| 40x25 mode isn't initiated in Genoa VGA.
|	movb	ah,0x0b
|	movb	bh,0		| select border colour	
|	movb	bl,0x00		| colour 0=black
|	int	VIDEO		| select black border for screen blanking

| Use this method for EGA/VGA.
|	movb	ah,#0x10	| set palette registers, set attributes
|	movb	al,1		| select overscan (border) colour
|	movb	bh,0x00		| colour 7=white
|				|	1=blue, 2=green, 4=red
|	int	VIDEO		| select white border for pagewhite

| Since the BIOS methods don't work, we program the video controller directly.
#ifdef INTEL_32BITS
	mov	edx,#0x03da	| we should check for mono; mono uses 0x03ba
#else
	mov	dx,#0x03da	| we should check for mono; mono uses 0x03ba
#endif
black0:	in
	testb	al,#8
	jnz	black0		| wait here for something?  (BIOS does this.)
black1:	in
	testb	al,#8
	jz	black1
#ifdef INTEL_32BITS
	mov	edx,#0x03c0
#else
	mov	dx,#0x03c0
#endif
	movb	al,#0x11	| select overscan register
	out
	movb	al,#0x00	| colour 0=black
	out
	movb	al,#0x20
	out
	ret

#endif
