#include <stdio.h>

#include "ttyio.h"

static int mode = 0;

/* values for internal mode word: */

#define NOCANON	1
#define NOECHO	2

tty_init()
{
}

tty_setmode(flags)
int flags;
{
if(!isatty(0))		/* if you don't have isatty(), just delete this test */
	return -1;

if(flags & TTY_ECHO)
	mode &= ~NOECHO;

if(flags & TTY_NOECHO)
	mode |= NOECHO;

if(flags & TTY_CANON)
	mode &= ~NOCANON;

if(flags & TTY_NOCANON)
	mode |= NOCANON;

return 0;
}

tty_getchar()
{
switch(mode)
	{
	case 0:
		return getchar();

	case NOCANON:
		return getche();

	case NOCANON | NOECHO:
	case NOECHO:		/* oh, well, noecho gets you nocanon */
		return getch();
	}
}

tty_navail()
{
if(!(mode & NOCANON))
	return -1;
 
return kbhit() ? 1 : 0;
}

tty_reset()
{
mode = 0;
}

