/* Copyright (c) 1991 David I. Bell
 * Permission is granted to use, distribute, or modify this source,
 * provided that this copyright notice remains intact.
 *
 * mini-X graphics - kernel private definitions
 */

#ifndef	GRAPH_DEV_H
#define	GRAPH_DEV_H

#include <graphics.h>


/* Pixel packings within words. */
#define	GR_BITMAPBITS	(sizeof(GR_BITMAP) * 8)
#define	GR_ZEROBITS	((GR_BITMAP) 0x0000)
#define	GR_ONEBITS	((GR_BITMAP) 0xffff)
#define	GR_FIRSTBIT	((GR_BITMAP) 0x8000)
#define	GR_LASTBIT	((GR_BITMAP) 0x0001)
#define	GR_BITVALUE(n)	((GR_BITMAP) (((GR_BITMAP) 1) << (n)))
#define	GR_SHIFTBIT(m)	((GR_BITMAP) ((m) << 1))
#define	GR_NEXTBIT(m)	((GR_BITMAP) ((m) >> 1))
#define	GR_TESTBIT(m)	(((m) & GR_FIRSTBIT) != 0)


typedef struct {
  int (*init) ();		/* init graphics mode for device */
  void (*term) ();		/* terminate graphics mode for device */
  void (*setmode) ();		/* set drawing mode */
  void (*drawpoint) ();		/* draw point */
  void (*drawline) ();		/* draw line */
  void (*drawrow) ();		/* draw horizontal line */
  void (*drawcol) ();		/* draw vertical line */
  void (*fillrect) ();		/* draw filled in rectangle */
  void (*drawellipse) ();	/* draw ellipse */
  void (*fillellipse) ();	/* fill ellipse */
  void (*drawtext) ();		/* draw text string */
  void (*sizetext) ();		/* return size of text string */
  void (*drawarea8) ();		/* draw area with 8 bit color values */
  void (*drawbitmap) ();	/* draw bitmap */
   GR_COLOR(*readpoint) ();	/* read pixel value */
  void (*setcursor) ();		/* set cursor size and shape */
  void (*movecursor) ();	/* move location of cursor */
  void (*checkcursor) ();	/* check cursor for overlapped io */
  void (*fixcursor) ();		/* fix back cursor after overlaps */
  void (*copyarea) ();		/* copy rectangular area */
  void (*getcharbits) ();	/* return bitmap for character */
  void (*getscreeninfo) ();	/* return screen configuration info */
  void (*getfontinfo) ();	/* return font information */

  /* Data values which are constants of the device. */
  GR_SIZE rows;			/* number of rows in device */
  GR_SIZE cols;			/* number of columns in device */
  long colors;			/* number of colors for device */
  GR_COLOR black;		/* color value for black */
  GR_COLOR white;		/* color value for white */
} GR_DEV;

EXTERN GR_DEV gr_dev;		/* device for drawing */


/* Other useful global symbols. */
EXTERN GR_MODE gr_mode;		/* current drawing mode */
EXTERN GR_COLOR gr_foreground;	/* foreground color */
EXTERN GR_COLOR gr_background;	/* background color */
EXTERN GR_BOOL gr_usebg;	/* TRUE if use background in pixmaps */
EXTERN GR_BOOL gr_error;	/* TRUE if had graphics error */


/* Clip cache rectangle information.
 * After calling clipcheck, this rectangle is guaranteed to contain the
 * specified point (among others), and all points in the rectangle are
 * plottable or not according to the value of clipresult.
 */
EXTERN GR_COORD clipminx;	/* minimum x value of cache rectangle */
EXTERN GR_COORD clipminy;	/* minimum y value of cache rectangle */
EXTERN GR_COORD clipmaxx;	/* maximum x value of cache rectangle */
EXTERN GR_COORD clipmaxy;	/* maximum y value of cache rectangle */
EXTERN GR_BOOL clipresult;	/* whether clip rectangle is plottable */

#define	GR_CLIP_INVISIBLE	0	/* clip area is invisible */
#define	GR_CLIP_VISIBLE		1	/* clip area is visible */
#define	GR_CLIP_PARTIAL		2	/* clip area may be partially visible */


/* Generic routines for drawing which use other primitives. */
extern void gen_drawline();
extern void gen_drawrow();
extern void gen_drawcol();
extern void gen_fillrect();
extern void gen_drawellipse();
extern void gen_fillellipse();
extern void gen_drawtext();
extern void gen_drawarea8();
extern void gen_drawbitmap();
extern void gen_initcursor();
extern void gen_setcursor();
extern void gen_movecursor();
extern void gen_checkcursor();
extern void gen_fixcursor();
extern void gen_copyarea();

extern GR_BOOL clippoint();
extern int cliparea();

#endif

/* END CODE */
