
code	segment
	assume	cs:code, ds:code, ss:code
	org	100h
start:
	mov	dx, cs		; set up registers
	mov	ds, dx
	cli
	mov	ss, dx
	mov	sp, offset stack
	sti
	mov	ax, offset tail ; calculate my size
	add	ax, 0fh 	; round to multiple
	mov	cl, 4		; of 16
	shr	ax, cl
	add	ax, dx		; add to my origin
	mov	loadpos, ax	; is the first load position
	mov	bp, offset k_struct
	call	load		; load kernel
	mov	bp, offset m_struct
	call	load		; load mm
	mov	bp, offset f_struct
	call	load		; load fs
	mov	bp, offset i_struct
	call	load		; load init

	mov	bx, k_struct+4	; kernel data
	mov	es, k_struct+2	; kernel segment

	mov	ax, k_struct+6	; kernel size
	mov	es:[bx+2], ax	; ---> size table of kernel
	mov	ax, m_struct+6	; mm size
	mov	es:[bx+6], ax	; ---> size table of kernel
	mov	ax, f_struct+6	; fs size
	mov	es:[bx+10], ax	; ---> size table of kernel
	mov	ax, i_struct+6	; init size
	mov	es:[bx+14], ax	; ---> size table of kernel

	mov	bx, f_struct+4	; fs data
	mov	es, f_struct+2	; fs segment

	mov	es:[bx+8], ax	; init size ---> fs table
	mov	ax, i_struct+2	; init origin
	mov	es:[bx+4], ax	; ---> fs table

;	mov	bx, 13		; scan code of '='

	xor	ax, ax
	mov	k_struct, ax
	call	dword ptr k_struct
	mov	ax,4c00h
	int	21h
;
load:
	mov	dx, [bp]	; filename
	mov	ax, 3d00h	; open the file
	int	21h
	jc	error_open
	mov	handle, ax	; save for later use

	mov	bx, ax		; read the file
	mov	cx, 0ffffh	; all you can read
	mov	dx, loadpos	; to this segment
	mov	2[bp], dx	; store text origin segment
	push	ds
	mov	ds, dx
	mov	es, dx		; for later use to clear bss
	xor	dx, dx
	mov	ah, 3fh
	int	21h
	mov	bx, ds:[2]	; 2 is begdata
	mov	dx, ds:[4]	; 4 is endbss
	pop	ds
	jc	error_read
	mov	4[bp], bx	; store data origin offset

	mov	cx, dx
	sub	cx, ax		; bss size = endbss - enddata (in AX by READ)
	shr	cx, 1		; words
	inc	cx		; just in case
	mov	di, ax		; starts here
	xor	ax, ax		; use zero
	rep	stosw		; to clear bss

	add	dx, 0fh 	; round to multiple
	mov	cl, 4		; of 16
	shr	dx, cl
	mov	6[bp], dx	; store total size in paragraphs

	add	loadpos, dx	; advance for next load

	mov	bx, handle	; close the file
	mov	ah, 3eh
	int	21h
	ret
;
print:
	lodsb
	and	al, al
	jz	finish
	mov	dl, al
	mov	ah, 2
	int	21h
	jmp	print
finish:
	ret
;
error_open:
	mov	si, offset unable_open
	call	print
	jmp	short error
error_read:
	mov	si, offset unable_read
	call	print
error:
	mov	si, [bp]
	call	print
	mov	ax, 4c01h
	int	21h
;
handle		dw	0
unable_open	db	'Unable to open ', 0
unable_read	db	'Unable to read ', 0
;
loadpos 	dw	0
kernelname	db	'KERNEL.BIN', 0
mmname		db	'MM.BIN',     0
fsname		db	'FS.BIN',     0
initname	db	'INIT.BIN',   0
k_struct	dw	kernelname, 0, 0, 0
m_struct	dw	mmname,     0, 0, 0
f_struct	dw	fsname,     0, 0, 0
i_struct	dw	initname,   0, 0, 0
;
	db	64 dup (0)
stack	label	byte
tail	label	byte
;
code	ends
	end	start
