 /*-----------------------------------------------------------------------
-------------------------------------------------------------------------

   FILE:	SI.h

   PURPOSE:	Describes the global data structures, declare the global
		variables.

   AUTHOR:    	Tan Phan
   DATE:	Spring 1989

   USAGE:	This is an include file.  It is 'included' in every SI_
		source codes files that reference the defined data 
		structures.

   Copyright 1990-1991 North Carolina State University. All Rights Reserved.

-------------------------------------------------------------------------
------------------------------------------------------------------------*/

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/X.h>
#include </usr/sys/h/types.h>


/*-----------------------------------------------------------------------
-------------------------------------------------------------------------
   Global constant definitions:
------------------------------------------------------------------------*/
#define	true			1
#define false			0

#define MAXN_LEN		12	/* DS name length		*/
#define MAXB_LEN		20	/* CB name length		*/
#define MAX_MEM_SIZE		8192	/* 8K words memory size		*/
#define SI_MEMORY_WSIZE		8	/* # of bits in a word		*/
					/* This can be 8, 16, or 32	*/

/* State definitions for DS and CB:					*/
#define SI_SACTIVE		1	/* available			*/
#define SI_SINACTIVE		2	/* not available		*/
#define SI_FOCUSED		3	/* active and cursor on top	*/
#define SI_SELECTED		4	/* focused and button clicked	*/

/* DS type definitions:							*/
#define SI_TDS1			1
#define SI_TDS2			2
#define SI_TDS3			3
#define SI_TDS4			4
#define SI_TDS5			5

/* Maximum DS width definitions:					*/
#define SI_LDS1			10
#define SI_LDS2			3
#define SI_LDS3			10
#define SI_LDS4			10
#define SI_LDS5			10

/* DS border widths:							*/
#define SI_WDS1			1
#define SI_WDS2			1
#define SI_WDS3			1
#define SI_WDS4			1
#define SI_WDS5			1

/* CB type definitions:							*/
#define SI_TCB1			6
#define SI_TCB2			7
#define SI_TCB3			8

/* Maximum CB width definitions:					*/
#define SI_LCB1			16
#define SI_LCB2			16
#define SI_LCB3			16

/* CB border widths:							*/
#define SI_WCB1			4
#define SI_WCB2			4
#define SI_WCB3			4

/* Displayed data format definitions:					*/
#define SI_FHEX			1
#define SI_FDEC			2
#define SI_FOCT			3
#define SI_FBIN			4
#define SI_FCHR			5

/* Font names:								*/
#define SI_NFONT1		"-adobe-helvetica-bold-r-normal--10-100\
-75-75-p-60-iso8859-1"
#define SI_NFONT2		"-adobe-helvetica-bold-r-normal--12-120\
-75-75-p-70-iso8859-1"
#define SI_NFONT3		"6x12"
#define SI_NFONT4		"6x10"
#define SI_NFONT5		"-adobe-helvetica-bold-r-normal--14-140\
-75-75-p-82-iso8859-1"
#define SI_NFONT6		"-adobe-courier-bold-r-normal--10-100\
-75-75-m-60-iso8859-1"

/* SI icon name:							*/
#define	SI_ICON_NAME		"SI"

/* SI setup data file name:						*/
#define SI_FNAME		"/usr/local/lib/SI_data"

/* Trace dump file name:						*/
#define SI_DUMP_FNAME		"SI_dump"


/* Memory window display type definitions:				*/
#define SI_MW_TADDR		0
#define SI_MW_TDATA		1



/*-----------------------------------------------------------------------
-------------------------------------------------------------------------
   Global type definitions:
------------------------------------------------------------------------*/
typedef struct DS_attr_struct	DS_attr;
typedef	struct DS_struct	DS;
typedef struct CB_attr_struct	CB_attr;
typedef	struct CB_struct	CB;
typedef struct SI_mask_struct	SI_mask;
typedef struct memory_struct	memory;
typedef struct mw_struct	mw;


/*-----------------------------------------------------------------------
-------------------------------------------------------------------------
   Structures definitions:
------------------------------------------------------------------------*/
/*----------------------------------------------------------------------
   DS_attr:

   DS attributes contains the information about the physical
   characteristics of each DS.  Some of these physical characteristics 
   are:  actual position of DS within the SI window, and state of DS.

   Except for the state information, the user should not try to alter the
   other information in this data structure.  Improper alterations of
   the other fields may result in scrambled window, core dumps,...

   Each DS can have one of two states:  SI_SACTIVE, or SI_SINACTIVE.  An
   active DS is boldly dislayed while an inactive DS is dimly displayed.
*/
struct	DS_attr_struct
	{  Window	dsw1,		/* child window for DS name	*/
			dsw2;		/* child window for DS value	*/
	   int		x,y;		/* pixel position of DS		*/
	   int		state;		/* display state of DS		*/
	};
   
/*----------------------------------------------------------------------
   DS:

   A DisplaySquare is a rectangular block on the SI window which contains
   some form of information (ie. registers contents).  The kind of
   information that a DS displays depends on the type of the display.  For
   example, one DS displays hex. numbers while another displays bin. 
   numbers while another display ASCII characters.

   Some simulator may not use all the available DS.  The defined field of
   the unused DS must be set to false.

   A DS can be of 5 types:  SI_TDS1, SI_TDS2, SI_TDS3, SI_TDS4, and 
   SI_TDS5.  The type classifies the DS into a specific region in the
   SI window (See SI_mask_struct for more information).  

   Each DS can have a name which is displayed along with the value the DS
   represent.  The name has a predetermined maximum length.  The lenght
   varies based on the DS type (See SI_mask_struct for more information).

   The addr_value field is a pointer to the actual data memory locations.
   The type declarared here for addr_value is only a dummy.  In true
   applications, addr_value can be pointing to other data structure
   depending on the format field.  Below is a list of the data structures
   to which SI expects addr_value to point:

	format		addr_value points to
	------		--------------------
	SI_FHEX		unsigned int
	SI_FDEC		unsigned int
	SI_FBIN		unsigned int
	SI_FOCT		unsigned int
	SI_FCHR		char

*/
struct	DS_struct
	{  int		defined;	/* flag:  true if DS is used	*/
	   int		type;		/* type of DS			*/
	   int		format;		/* type of value to display	*/
	   int		vlen;		/* # of characters in value	*/
	   char		name[MAXN_LEN+1];
					/* name of DS			*/
	   int		center;		/* start x pos for centering txt*/
	   int 		*addr_value;	/* pointer to value of field	*/
	   char		oldval[MAXN_LEN+1];
					/* contains the previous value	*/
	   DS_attr	attr;		/* DS attributes		*/
	};
   
/*----------------------------------------------------------------------
   CB_attr:

   CB attributes contains information about the physical characteristics
   of each CB.  SOme of these characteristics are:
	actual window data structure,
	position of the CB within the SI parent window,

   Except for the state information, the user should not try to alter the
   other information in this data structure.  Improper alterations of
   the other fields may result in scrambled window, core dumps,...

   Each CB can have one of 4 states:  SI_SACTIVE, SI_SINACTIVE, 
   SI_SFOCUSED, and SI_SSELECTED.  An active CB is boldly dislayed while 
   an inactive CB is dimly displayed.  A focused CB has thick border 
   while an active CB has thinner border.  A selected CB has both thick
   border and inverted name while a focused CB only has thick border.

   An inactive CB represents a funtion that is not currently available.
   An active CB represents an available function.
   A focused CB is an active CB with the cursor (mouse pointer) on top.
   A selected CB is a focused CB with the mouse button clicked.
*/
struct	CB_attr_struct
	{  Window	cbw;		/* X window structure		*/
	   int		x,y;		/* pixel position of CB		*/
	   int		state;		/* display state of CB		*/
	};
   
/*----------------------------------------------------------------------
   CB:

   A ControlButton is a rectangular block on the bottom and left side of
   the SI window.  These are actual child windows of the SI window.
   These are used to pass external inputs to the user's program thru.
   an event-driven-loop mechanism.

   Some simulator may not use all the available CB.  The defined field of
   the unused CB must be set to false.

   A CB can be of 3 types:  SI_TCB1, SI_TCB2, and SI_TCB3.
   The type classifies the DS into a specific region in the SI window 
   (See SI_mask_struct for more information).  

   Each CB can have a name which is displayed along with the value the CB
   represent.  The name has a predetermined maximum length.  The lenght
   varies based on the CB type (See SI_mask_struct for more information).

*/
struct	CB_struct
	{  int		defined;	/* flag:  true is CB is used	*/
	   int		type;		/* type of the CB		*/
	   char		name[MAXB_LEN+1];
					/* name of CB			*/
	   int		center;		/* start x pos for centering txt*/
	   CB_attr	attr;		/* CB attributes		*/
	};

/*-----------------------------------------------------------------------
   SI_mask_struct:

   This data structure groups the different regions of the SI window
   into one mass.  Eight regions are defined on each SI window.  The
   regions are predefined to have certain properties.

   The 8 regions are further classified into 2 groups:  the DS group and
   the CB group.  Within group of the same type (either DS or CB),
   there are no restrictions on what kind of information each entity
   (each DS or CB) can represent, as long as the information 'fits' on
   the predefined space in the SI window.

   Logically, the DS group represents the mechanism in which the simulator
   outputs its results to the outside world and the CB group represents
   the mechanism in which the simulator gets its inputs from the
   outside world.  In other words, the DS group displays the 
   simulation results thru. the 'little display squares' while the CB 
   group gets commands from users thru. the 'command buttons.'

   Under the DS group, 5 regions are defined.  They are DS1, DS2, DS3,
   DS4, and DS5.  The recommend usage for each of the above DS region
   are described as followed:

	DS1:	display content of general purpose registers, PC, SP,
		register indexes,...

		The predefined width for each DS in DS1 is 10 characters
		wide.  There are 5 rows of 8 DS.

	DS2:	display status flags (C,Z,V,I,N,...), fields from SR 
		(interrupt mask level, interrupt mask,...),...

		The predefined width for each DS in DS2 is 3 characters
		wide.  There are 1 row of 16 DS.

	DS3:	display simulation statistics (# of clock cycles, # of
		bus access, # of memory reads,...),...

		The predefined width is 10 characters.  There are 1/2 row
		of 4 DS. 

	DS4:	display contents of I/O ports,...

		The predefined width is 10 characters.  There are 1/2 row
		of 4 DS.

	DS5:	display the simulator status flags (trace on, single step
		on, SI screen dump on,...)

		The predefined width is 10 characters.  There are 1 row of 
		8 DS.  These DS do not have to have a value.

   Under the CB group, 3 regions are defined.  They are CB1, CB2, and CB3.
   The recommend usage for each CB region are described as followed:

	CB1:	buttons for the simulator commands (load, execute, display
		memory, display registers, halt,...)

		The predefined width is 16 characters.  There are 2 rows
		of 8 CB.  The rows are arranged horizontally on the bottom
		of the SI window.

	CB2:	buttons for the 'async.' input funtions (I/O input ports,
		generate interrupt requests,...)

		The predefined width is 16 characters.  There are 4 CB
		arranged vertically on the middle right side of the SI
	 	window.

	CB3:	buttons RESERVED for SI.
		These buttons serve internal functions of SI.  The 
		functions are:  start window dump, stop window dump,
		take snap shot, purge dump file.

		The defined width is 16 characters.  There are 4 of these
		arranged vertically on the upper right side of the SI
		window.
*/
struct	SI_mask_struct
	{  DS		DS1[40];
	   DS		DS2[16];
	   DS		DS3[4];
	   DS		DS4[4];
	   DS		DS5[8];
	   CB		CB1[16];
	   CB		CB2[4];
	   CB		CB3[4];
	};

/*-----------------------------------------------------------------------
   memory_struct:

   This is the data structure defined for simulation memory.
   SI operates on this memory structure on operations such as:

	loading programs,
	view and change memory contents,
	user access to memory locations to do simulations,
	set, clear, and check for break points.

   When the memory is accessed by the user, the data that is being
   operated on is masked to the defined size.
------------------------------------------------------------------------*/
struct	memory_struct
	{  unsigned int space[MAX_MEM_SIZE];
					/* memory space			*/
	   int		brkpt[MAX_MEM_SIZE];
					/* corresponding break points	*/
	};


/*-----------------------------------------------------------------------
   mw_struct:

   Data structure associated with a word to be displayed from memory.
------------------------------------------------------------------------*/
struct	mw_struct
        {  int		type;		/* address or data		*/
	   int		x,y;		/* position of the window	*/
	   unsigned int value;		/* memory value			*/
	   int		bp;		/* breakpoint set/clear		*/
	   Window	ds;		/* the actual display window	*/
	};


/*-----------------------------------------------------------------------
-------------------------------------------------------------------------
   Global variable declarations:

   The global variable definitions (the reservation of actual storage
   space) are in file SI_defs.c.  Here, the global variables are only 
   externally declared so that they can be used globally.
------------------------------------------------------------------------*/

extern	SI_mask		SI_window;
extern	XEvent		SI_event;
extern	memory		SI_memory;

extern	Font		SI_font1,
			SI_font2,
			SI_font3,
			SI_font4,
			SI_font5,
			SI_font6;
extern	XFontStruct	*SI_font1_struct,
			*SI_font2_struct,
			*SI_font3_struct,
			*SI_font4_struct,
			*SI_font5_struct,
			*SI_font6_struct;
extern	Display		*SI_display;
extern	Window		SI_toplevel,
			SI_g1_window,
			SI_mw_toplevel;
extern	GC		SI_gc;
extern	Pixmap		SI_bgrd1,
			SI_bgrd2,
			SI_bgrd3,
			SI_bgrd4,
			SI_bgrd5,
			SI_bgrd6;
extern	Cursor		SI_cursor,
			SI_CB_cursor,
			SI_ptr_cursor;
extern	int		SI_high_x,SI_high_y;
extern	int		SI_expose_event;
extern  int		SI_mw_mapped;
extern  int		SI_TraceDumpOn;
extern	FILE		*SI_TD_ofp;
extern	unsigned int	SI_memory_wsize;
			
/*-----------------------------------------------------------------------
-------------------------------------------------------------------------
   Functions declarations:
------------------------------------------------------------------------*/



