DROP TABLE IF EXISTS ac;
CREATE TABLE ac (
  thread_id INTEGER DEFAULT '0' NOT NULL,
  object_id INTEGER NOT NULL,
  nh_id INTEGER NOT NULL,
  object_type TINYINT(3) NOT NULL,
  PRIMARY KEY (nh_id, object_id)
);

DROP TABLE IF EXISTS an;
CREATE TABLE an (
  thread_id INTEGER DEFAULT '0' NOT NULL,
  id INTEGER NOT NULL,
  value VARCHAR(20) NOT NULL,
  PRIMARY KEY(value),
  UNIQUE (id)
);

DROP TABLE IF EXISTS dn;
CREATE TABLE dn (
  thread_id INTEGER DEFAULT '0' NOT NULL,
  id INTEGER NOT NULL,
  value VARCHAR(20) NOT NULL,
  PRIMARY KEY(value),
  UNIQUE (id)
);

DROP TABLE IF EXISTS mb;
CREATE TABLE mb (
  thread_id INTEGER DEFAULT '0' NOT NULL,
  object_id INTEGER NOT NULL,
  mt_id INTEGER NOT NULL,
  object_type TINYINT(3) NOT NULL,
  PRIMARY KEY (mt_id, object_id)
);

DROP TABLE IF EXISTS mt;
CREATE TABLE mt (
  thread_id INTEGER DEFAULT '0' NOT NULL,
  id INTEGER NOT NULL,
  value VARCHAR(20) NOT NULL,
  PRIMARY KEY(value),
  UNIQUE (id)
);

DROP TABLE IF EXISTS nh;
CREATE TABLE nh (
  thread_id INTEGER DEFAULT '0' NOT NULL,
  id INTEGER NOT NULL,
  value VARCHAR(20) NOT NULL,
  object_type TINYINT(3) NOT NULL,
  PRIMARY KEY (value),
  UNIQUE (id)
);

DROP TABLE IF EXISTS tc;
CREATE TABLE tc (
  thread_id INTEGER DEFAULT '0' NOT NULL,
  object_id INTEGER NOT NULL,
  nh_id INTEGER NOT NULL,
  object_type TINYINT(3) NOT NULL,
  PRIMARY KEY (nh_id, object_id)
);

DROP TABLE IF EXISTS zc;
CREATE TABLE zc (
  thread_id INTEGER DEFAULT '0' NOT NULL,
  object_id INTEGER NOT NULL,
  nh_id INTEGER NOT NULL,
  object_type TINYINT(3) NOT NULL,
  PRIMARY KEY (nh_id, object_id)
);

DROP TABLE IF EXISTS object;
CREATE TABLE object (
  thread_id INTEGER DEFAULT '0' NOT NULL,
  id INTEGER AUTO_INCREMENT NOT NULL,
  value LONGBLOB DEFAULT '' NOT NULL,
  PRIMARY KEY (id)
);

DROP TABLE IF EXISTS object_type;
CREATE TABLE object_type (
  id INTEGER AUTO_INCREMENT NOT NULL,
  code VARCHAR(2) NOT NULL,
  PRIMARY KEY (id),
  UNIQUE (code)
);

INSERT object_type SET code='pn';
INSERT object_type SET code='ro';
INSERT object_type SET code='mt';
INSERT object_type SET code='li';
INSERT object_type SET code='dn';
INSERT object_type SET code='kc';
INSERT object_type SET code='in';
INSERT object_type SET code='rt';
INSERT object_type SET code='an';
INSERT object_type SET code='rs';
INSERT object_type SET code='as';
INSERT object_type SET code='i6';

