//  $Id: schedule.hh 1.6 Sat, 05 Sep 1998 03:59:35 -0700 wlee $
//
//  Copyright (c) 1994 by the University of Southern California
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and its
//  documentation in source and binary forms for lawful non-commercial
//  purposes and without fee is hereby granted, provided that the above
//  copyright notice appear in all copies and that both the copyright
//  notice and this permission notice appear in supporting documentation,
//  and that any documentation, advertising materials, and other materials
//  related to such distribution and use acknowledge that the software was
//  developed by the University of Southern California, Information
//  Sciences Institute. The name of the USC may not be used to endorse or
//  promote products derived from this software without specific prior
//  written permission.
//
//  THE UNIVERSITY OF SOUTHERN CALIFORNIA DOES NOT MAKE ANY
//  REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY
//  PURPOSE.  THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
//  IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE,
//  TITLE, AND NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT, TORT,
//  OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE
//  OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  ratoolset@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu <cengiz@ISI.EDU>

#ifndef SCHEDULE_H
#define SCHEDULE_H

#include "config.h"
#include "util/List.hh"

#define OP_ADD     0
#define OP_DEL     1
#define OP_UPD     2

class Transaction : public ListNode {
public:
   Transaction() {
      op_code = OP_UPD;
      source[0] = 0;
      as[0] = 0;
      route[0] = 0;
      mnt_by[0] = 0;
      text[0] = 0;

      display_position = -1;
   }

   int  op_code;
   char source[64];
   char as[64];
   char route[64];
   char mnt_by[64];
   char text[4*1024];

   int display_position;

};

class Schedule : public List<Transaction> {
public:
   void add();
   void select(int index);
   void cancel(int index);
   void add_selected(char *selection);
   void del_selected(char *selection);
   void del_selected_matching_source(char *selection, char *dbase);
   void update_irr();
private:
   void add_internal(char *text);
};

extern Schedule schedule;

#endif // SCHEDULE_H
