%%%%%%%%%%  adesc_findset.m  %%%%%%%%%%
function [fmax]=thesis_findset(error,iext,indx_edges,delta)
% 
% Construct new set fmax of frequency points.  
% fmax: All local maxima including the set "iext".
%       Points with small deviation removed.
%
error = error(:);
indx_edges = indx_edges(:);
Ngrid = length(error);
abs_e = abs(error);
abs_e = [abs_e(2); abs_e; abs_e(Ngrid-1)];
fmax = find( (abs_e(2:Ngrid+1) >= abs_e(1:Ngrid)) & ...
             (abs_e(2:Ngrid+1) >= abs_e(3:Ngrid+2)) ); 
fmax = fmax(:);
fmax = sort([fmax; indx_edges; iext]);
abs_e([1;Ngrid+2]) = [];
fmax(find(~(fmax(1:length(fmax)-1)-fmax(2:length(fmax)))))=[];
fmax(find(abs_e(fmax) < 0.9*abs(delta))) = [];
%%%%%%%%%% End adesc_findset.m %%%%%%%%%% 
