%%%%%%%%%% adesc_linsearch.m %%%%%%%%%%
function [HHt,EEt,emxt,t] = adesc_linsearch(t0,iext,HH_o,d,emx,...
                                            DD,WT,ifgrid)
%  Performs a simple line search for step size. 
%  Efficiency of search can be improved by implementing 
%  method suggested in book "Introduction To Minimax" 
%  by V. F. Demjanov and V. N. Malozemov, pp. 109-112. 
%
t = t0; no_stp = 1; HH_o = HH_o(:); d = d(:);
r_flg = 0; t_flg = 1; h_flg = 0; i_flg = 0;
grtr = 1; c = 2; acc = 1 -  10^(-0.1/10);
while (grtr)
   HHt = HH_o + t*d; 
   EEt = WT .* (DD - HHt(ifgrid));
   emxt = max(abs(EEt(iext)));
   if (emxt <= emx) 
     grtr = 0; 
   else
     t = t/2;
   end; 
end;
tmin = t; HHt_min = HHt; EEt_min = EEt;
emin = emxt; I = 2*t*ones(2,1);
while (no_stp)
  if (~i_flg) t = c*t; end;
  HHt = HH_o + t*d; 
  EEt = WT .* (DD - HHt(ifgrid));
  emxt = max(abs(EEt(iext)));
  R = (emxt <= emin);
  if (R)
    tmin = t; HHt_min = HHt; EEt_min = EEt; emin = emxt;
    t_flg = 0; h_flg = 0;
    if (i_flg)
      I = sort([t;I(2)]);
      t = (t+I(2))/2;
    end;
    r_flg = 1;
  elseif ((~R) & (i_flg))
      I = sort([I(1);t]);
      t = (t+I(1))/2;
  elseif (t_flg)
    t1 = t;
    t_flg = 0;
  elseif (r_flg)
    if (r_flg) t1 = t; end;
    I = sort([tmin,t1]);
    t = (tmin+t1)/2;
    i_flg = 1;
  else
    no_stp = 0;
  end;
  if  ( i_flg & ((I(2) - t) < acc*I(2)) ) no_stp = 0; end;
end;
HHt = HHt_min; EEt = EEt_min; emxt = max(abs(EEt)); t = tmin;
%%%%%%%%%% End adesc_linsearch.m %%%%%%%%%% 