%%%%%%%%%% crmz_adesc.m %%%%%%%%%% 
% crmz_adesc.m
% Two-stage Multiple-exchange Filter Design Algorithm 
%      designs FIR filters with arbitary magnitude and 
%      phase specifications. 
%
% crmz_adesc.m: version 5.0 created on 02/95 
%                   
% (c) 1995 by Lina Karam and James McClellan
%

%main program
clc; disp(' ');
disp('             ***********************************************');
disp('             *****    Design of Optimal FIR Filters    *****');
disp('             *****  by Complex Chebyshev Approximation *****');
disp('             *****  Version 5.0 (Matlab 4.0 or higher) *****');
disp('             ***********************************************');
%%%%%%%%%%%%%%% Read Design Specifications %%%%%%%%%%%%%%%%
J=sqrt(-1);
crmz_datain;
if ~exist('sym'), sym = 0; end;
if ~exist('N1'), N1 = 0; end; 
N2 = N1 + L - 1;   % Last index of impulse response 
is_odd = mod(L,2); 
%%%%%%%%%%%%%%%    Run Design Algorithm    %%%%%%%%%%%%%%%%
crmz;              %%% Complex Remez Stage 
if (not_optimal)   %%% optimality flag set by Complex Remez (crmz.m)  
  adesc;           %%% Ascent-descent Stage 
end; 
%%%%%%%%%%%%%%%    Final result Display    %%%%%%%%%%%%%%%%
clf;
H = HH .* exp(-J*2*pi*tgrid*(N1+N2)/2);
E = EE .* exp(-J*2*pi*grd*(N1+N2)/2);
crmz_plresult;
impfile = crmz_input(' File to save coefficients (0 = none) : ','0');
if ~strcmp(impfile,'0')
  impfile(find(impfile=='.'):length(impfile)) = [];
  eval(['save ' impfile ' h']);
end;
%%%%%%%%%%%%%%%          End Program       %%%%%%%%%%%%%%%%









