%%%%%%%%%% crmz_grid.m %%%%%%%%%%
function  [grid,del_f,vec_edges,inedges] = crmz_grid(edges, L, whole)
% REMGRID    generate grid for remez exchange  [jMc 11/92] [lk 05/93]
% Version 3.0
%   usage:
%        [Grid,Delta_f,Rev_edges] = remgrid( Edges, L, Whole )
%
%     grid:       frequencies on the fine grid
%     del_f:      spacing between grid pts
%     vec_edges:  specified edges as a vector 
%     inedges:    index of specified band-edges on grid 
%     edges:      specified band-edges, [Nbands X 2] array
%     L:          filter Length
%     Whole:      domain for approximation: default is [0,0.5]
%                'whole' means [-0.5,0.5), 
%
if( nargin < 3 )
   whole = 'half ';
end
mf = 25;
Ngrid = 2^(nextpow2( mf*L ));
del_f = 1.0/Ngrid;
vec_edges = edges';
vec_edges = vec_edges(:);
if ( all(whole == 'whole') )
  grid = [-0.5:del_f:0.5-del_f];
  inedges = round((vec_edges+0.5)/del_f)+1; 
elseif( all(whole == 'half ') )
  grid = [0:del_f:0.5];
  inedges = round(vec_edges/del_f)+1; 
else
   error('RMZ_GRID: whole is neither half nor whole')
end
if (inedges(length(inedges)) > length(grid))
  inedges(length(inedges)) = length(grid);
end;
Ng = length(grid);
grid(inedges) = vec_edges;
%%%%%%%%%% End crmz_grid.m %%%%%%%%%% 
