%%%%%%%%%% crmz_input.m %%%%%%%%%% 
function y=crmz_input(str, default);
% Version 3.0
% y = crmz_input(str, default)
%        prompts the user with the string "string" and suggested 
%        default value "default". Waits for input from the 
%        keyboard. Returns the user input (if any) or the default
%        value if only the <return> key is pressed. 
%                                 
if nargin <1
  disp('Error: Function needs at least one argument');
elseif nargin <2
  default = [];
end;
if isstr(default)
        str = [str '( ' default ' ): '];
elseif max(size(default)) >= 1;
        str = [str '( ' num2str(default) ' ): '];
else
        str = [str ': '];
end;
y = default;
strin = input(str, 's');
if max(size(strin))
  if isstr(default)
    y = strin;
  else
    y = eval(strin);
  end;
end;
%%%%%%%%%% End crmz_input.m %%%%%%%%%% 
