%%%%%%%%%% crmz_plresult.m %%%%%%%%%% 
% crmz_plresult
% Version 5.0
%            [lk, 01/95]
% Generates subplots of final result with
%    1. Magnitude response
%    2. Passband Phase 
%    3. Error magnitude and Real rotated error
%    4. Phase error in passband 
% Uses grp_delay.m and crmz_plerror2.m 
% 

%%%% compute EE_pl for plotting error in bands %%%%%%%%%
  EE_pl = []; grd_pl = []; i = 1; l = 0;
  while (i < (length(indx_edges)-1))
    lo = l + 1;
    l = l + length([indx_edges(i):indx_edges(i+1)]);
    grd_pl = [grd_pl;grd(lo:l);nan];
    EE_pl = [EE_pl;EE(lo:l);nan];
    i = i + 2;
  end;
  lo = l + 1;
  l = l + length([indx_edges(i):indx_edges(i+1)]);
  grd_pl = [grd_pl;grd(lo:l)];
  EE_pl = [EE_pl;EE(lo:l)];
  E_pl = EE_pl .* exp(-J*2*pi*grd_pl*(N1+N2)/2);  %% Needed for plot 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clf;
subplot(111)
axis('auto');
subplot(221)
dbMax = 20*log(max(abs(H(:)))); 
%dbMin = 20*log(min(abs(H(:))));
%dbRange = dbMax - dbMin; 
dbRange = 80;
plot(tgrid, db(abs(H(:)),dbRange,dbMax), '-') 
ph = gca;
set(ph,'box','off');
xlabel('normalized frequency'), ylabel('magnitude (log scale)')
subplot(222);
pas_edges = pas_edges';
pas_edges = pas_edges(:);
i = 1; 
grd_pl = [];
aH_pl = [];
aD_pl = []; 
while (i < (length(pas_edges)-1))
   psb = find((grd >= pas_edges(i)) & (grd <= pas_edges(i+1)));
   grd_pl = [grd_pl;grd(psb);nan];
   aH_pl = [aH_pl;angle(H(ifgrid((psb))));nan];
   aD_pl = [aD_pl;angle(Des(psb));nan];
   i = i + 2; 
end; 
psb = find((grd >= pas_edges(i)) & (grd <= pas_edges(i+1)));
grd_pl = [grd_pl;grd(psb)];
aH_pl = [aH_pl;angle(H(ifgrid((psb))))];
aD_pl = [aD_pl;angle(Des(psb))];
plot(grd_pl, aH_pl, '-')
hold on
plot(grd_pl, aD_pl, 'w--')
ph = gca;
set(ph,'box','off');
xlabel('normalized frequency'), ylabel('passband phase (radians)')
V = axis;
V(1) = pas_edges(1);
V(2) = pas_edges(length(pas_edges));
axis([V(1) V(2) V(3) V(4)]);
x = (V(1)+V(2))/(2.0);
text(x,V(4),'( -- ideal )')
hold off
subplot(224)
e_angle = mod(aD_pl,2*pi)-mod(aH_pl,2*pi);
plot(grd_pl,e_angle)
xlabel('normalized frequency'), ylabel('passband phase error')
ph = gca;
set(ph,'box','off');
V = axis;
V(1) = pas_edges(1); 
V(2) = pas_edges(length(pas_edges)); 
axis([V(1) V(2) V(3) V(4)]);
subplot(223)
crmz_plerror2;
ph = gca;
set(ph,'box','off');
axis('off')
text(0.42,-4.5*abs(delta),'0.5')
text(-0.0108,-4.5*abs(delta),'0')
if (~sym)
 text(-0.58,-4.5*abs(delta),'-0.5')
 str = sprintf('%5.4f',abs(delta));
 text(-0.75,abs(delta),str,'fontsize',10); 
 text(-0.75,-2*abs(delta),str,'fontsize',10);
 str = sprintf('%5.4f',-abs(delta));
 text(-0.78,-4*abs(delta),str,'fontsize',10);
 text(-0.22,1.6*abs(delta),'Error magnitude','fontsize',10);
 text(-0.25,-1.5*abs(delta),'Real rotated error','fontsize',10);
else 
 str = sprintf('%5.4f',abs(delta));
 text(-0.14,abs(delta),str,'fontsize',10); 
 text(-0.14,-2*abs(delta),str,'fontsize',10);
 str = sprintf('%5.4f',-abs(delta));
 text(-0.16,-4*abs(delta),str,'fontsize',10);
 text(0.155,1.6*abs(delta),'Error magnitude','fontsize',10);
 text(0.125,-1.5*abs(delta),'Real rotated error','fontsize',10);
end 
xlabel('normalized frequency')
%%%%%%%%%% End crmz_plresult.m %%%%%%%%%% 
