function y = dB( x, dBrange, dBmax )
% DB     convert an array to decibels           [jmc 4/89]
%    usage:
%      Y = dB( X, dbRANGE, dbMAX ) will compute 20 Log(X)
%          and then scale or clip the result so that
%          the minimum dB level is dbMAX-dbRANGE.
%          ex: db(X, 80, 0) gives the range 0 to -80 dB
%      Y = dB( X, dbRANGE ) defaults to dBmax = 0
%  NOTE: on some machines the Log(0) gives an error
%        and aborts this function (esp. microVAX)
%
if dBrange<=0
   error(' min dB is max dB minus dBrange')
end
if nargin == 2
  dBmax = 0;
end
y = abs(x);
ymax = max(y)/10.0^(dBmax/20);
if isrow(x)
   y = y/ymax;
else
   y = mapcol('x/p1(i)',y,ymax);
       % scale all columns, unless x is row vector
end 
thresh = 10.0^((dBmax-dBrange)/20);
y = y.*(y>thresh) + thresh.*(y<=thresh);
y = 20.0*log10(y);

