%%%%%%%%%% SAMPLE INPUT FILE %%%%%%%%%%
% crmz_in.m (exp1.m) 
% Sample input file for crmz.m 
% Input Data File (Reduced delay Linear-phase filter)
% 
% NOTE:
% Only entries having the expression "USER SPECIFIED" 
% next to them need to be changed by the user.
% All the other entries and variables must be left 
% unchanged.  
% Please, make sure to read the paragraphs starting with 
% the word NOTE before you create your own design 
% specifications. 
%  
% [lk, 01/95]

% Designed filter specifications
L = 31;            % USER SPECIFIED 
                   % filter length   

N1 = 0;            % USER SPECIFIED 
                   % Starting index of impulse response 

sym = 0;         % USER SPECIFIED 
                 % 0 = no-symmetry,1 = even-symmetry,2 = odd-symmetry
                 % NOTE: 
                 %  Specifies the symmetry of the function 
                 %  A(w) (NOT the desired Des(w)) which is 
                 %  equal to 
                 %
                 %      A(w) = exp(J*w*(2*N1+L-1)/2)*Des(w) 
                 %
                 %  where Des(w) is the ideal frequency response. 
                 %  sym = 1 => A(w) = A(-w)
                 %  sym = 2 => A(w) = -A(-w)
                 %  Note that A(w) is in general a complex function.
                 %

% Edge band frequencies in [-0.5, 0.5] (USER SPECIFIED)
% NOTE: To ensure that the Haar condition is satisfied the 
%       following rules must be followed: 
%       1) if sym = 1 or sym = 2, only specify band edges which 
%          are greater or equal to 0 (i.e., between 0 and 0.5).
%          Also one of the following rules may apply. 
%       2) if sym = 1 and L even, last element of edges must be 
%          strictly less than 0.5 (i.e., edges(length(edges)) < 0.5). 
%       3) if sym = 2 and L odd, first element of edges must be 
%          strictly greater than zero (i.e., edges(1) > 0), and 
%          last element of edges must be strictly less than 
%          0.5 (i.e., edges(length(edges)) < 0.5). 
%       4) if sym = 2 and L even, first element of edges must be 
%          strictly greater than zero (i.e., edges(1) > 0). 
%
  edges = [-0.5 -0.12; -0.06 0.06; 0.12 0.4995];  % USER SPECIFIED

% Passbands Edge frequencies (USER SPECIFIED)
% Needed for plotting
% NOTE: if sym = 1 or sym = 2, only specify passbands edges which 
%       are greater or equal to 0. 
%
  pas_edges = [-0.06 0.06];                       % USER SPECIFIED

if (sym)
  str = 'half ';      % 'half' = [0,0.5]
else
  str = 'whole';      % 'whole' = [-0.5,0.5)
end;        
           
% Generate frequency grid
[tgrid, delf, vec_edges, indx_edges] = crmz_grid(edges, L, str);
tgrid = tgrid';

% Initialization
Des = [];
WT = [];
grd = [];

% Specify desired frequency response and weighting function 
% here. 
% NOTE: The number of bands must be half the number of 
%       edge frequencies given by "edges" above.
%       User must add bands as needed. This can be done 
%       by:
%       (1). replicating the script corresponding to the 
%            last band. 
%       (2). incrementing by 1 the indices
%            of "indx_edges" in the first line of the script.
%       (3). specifying the values of the desired frequency 
%            response, "bnd_des", and the weighting function,
%            "bnd_wt", in the considered band(s).
%
%%%% All bands are specified in a similar way. 
%%%%
%%%% Band 1 
% USER SPECIFIED: only specify indices (in this case, 1 and 2)
%
  bnd_grid = tgrid(indx_edges(1):indx_edges(2)); 
%
% USER SPECIFIED: desired frequency response in terms of "bnd_grid"; 
%                 "bnd_grid" represent the NORMALIZED frequency 
%                 variable "f", (i.e. f = w/(2*pi) ). 
%                 write the desired function in terms of "bnd_grid".
% 
  bnd_des = 0 * bnd_grid;   
%  
% USER SPECIFIED: weighting function of the form 
%                      bnd_wt = Wt *ones(length(bnd_grid),1);
%                 where "Wt" is a positive real number specified 
%                 by the USER. Only "Wt" needs to be specified. 
  bnd_wt = 10 * ones(length(bnd_grid),1); 
%
Des = [Des; bnd_des];
WT = [WT; bnd_wt];
grd = [grd;bnd_grid];
Des_pl = [bnd_des;nan];

% Band 2
bnd_grid = tgrid(indx_edges(3):indx_edges(4)); % USER SPECIFIED indices
bnd_des = exp(-J*2*pi*bnd_grid*12);           % USER SPECIFIED 
bnd_wt = ones(length(bnd_grid),1);             % USER SPECIFIED 
Des = [Des; bnd_des];
WT = [WT; bnd_wt];
grd = [grd;bnd_grid];
Des_pl = [Des_pl;bnd_des;nan];

%Band 3
bnd_grid = tgrid(indx_edges(5):indx_edges(6)); % USER SPECIFIED indices
bnd_des = 0*bnd_grid;                          % USER SPECIFIED 
bnd_wt = 10 * ones(length(bnd_grid),1);        % USER SPECIFIED 
Des = [Des; bnd_des];
WT = [WT; bnd_wt];
grd = [grd;bnd_grid];
Des_pl = [Des_pl;bnd_des];

%%%%%%%%%% End INPUT FILE %%%%%%%%%%
