% Nearly linear phase: exp2.m 
% Input Data File
% Only entries having the expression "USER SPECIFIED" 
% next to them need to be changed by the user.
% All the other entries and variables must be left 
% unchanged.  
% [lk, 01/95]

% Designed filter specifications
L = 31;            % USER SPECIFIED 
                   % filter length   

N1 = 0;          % USER SPECIFIED 
                   % Starting index of impulse response 

sym = 0;         % USER SPECIFIED 
                 % 0 = no-symmetry,1 = even-symmetry,2 = odd-symmetry
                 % Specifies the symmetry of the Function A(w) which 
                 % is equal to 
                 %    A(w) = exp(J*(2*N1+L-1)/2)*Des(w) 
                 % where Des(w) is the ideal frequency response. 
                 % sym = 1 => A(w) = A(-w)
                 % sym = 2 => A(w) = -A(-w)
                 %

% Edge band frequencies (USER SPECIFIED)
%
edges = [-0.5 -0.33; -0.28 -0.15; -0.1 0.1; 0.15 0.28; 0.33 0.4995]; 

% Passbands Edge frequencies (USER SPECIFIED)
% Note: if sym = 1 or sym = 2, only specify band edges which 
%       are greater or equal to 0. 
% Needed for plotting
%
  pas_edges = [-0.28 -0.15; 0.15 0.28];                       % USER SPECIFIED

if (sym)
  str = 'half ';      % 'half' = [0,0.5]
else
  str = 'whole';      % 'whole' = [-0.5,0.5)
end;        
           
% Generate frequency grid
[tgrid, delf, vec_edges, indx_edges] = crmz_grid(edges, L, str);
tgrid = tgrid';

% Initialization
Des = [];
WT = [];
grd = [];

% Specify desired frequency response and weighting function 
% here. 
% Note: The number of bands must be half the number of 
%       edge frequencies given by "edges" above.
%       User must add bands as needed. This can be done 
%       by:
%       (1). replicating the script corresponding to the 
%            last band. 
%       (2). incrementing by 1 the indices
%            of "indx_edges" in the first line of the script.
%       (3). specifying the values of the desired frequency 
%            response, "bnd_des", and the weighting function,
%            "bnd_wt", in the considered band(s).
%
%%%% All bands are specified in a similar way. 
%%%%

% Band 1
bnd_grid = tgrid(indx_edges(1):indx_edges(2));
bnd_des = 0 * bnd_grid;                        % user specified
bnd_wt = 10 * ones(length(bnd_grid),1);        % user specified
Des = [Des; bnd_des];
WT = [WT; bnd_wt];
grd = [grd;bnd_grid];
Des_pl = [bnd_des;nan];

% Band 2
bnd_grid = tgrid(indx_edges(3):indx_edges(4));
bnd_des = exp( -J*2*pi*bnd_grid*12);           % user specified
bnd_wt = ones(length(bnd_grid),1);             % user specified
Des = [Des; bnd_des];
WT = [WT; bnd_wt];
grd = [grd;bnd_grid];
Des_pl = [Des_pl;bnd_des;nan];

%Band 3
bnd_grid = tgrid(indx_edges(5):indx_edges(6));
bnd_des = 0*bnd_grid;                          % user specified
bnd_wt = 10 * ones(length(bnd_grid),1);        % user specified
Des = [Des; bnd_des];
WT = [WT; bnd_wt];
grd = [grd;bnd_grid];
Des_pl = [Des_pl;bnd_des];

% Band 4
bnd_grid = tgrid(indx_edges(7):indx_edges(8));
bnd_des = exp( -J*2*pi*bnd_grid*12);           % user specified
bnd_wt = ones(length(bnd_grid),1);             % user specified
Des = [Des; bnd_des];
WT = [WT; bnd_wt];
grd = [grd;bnd_grid];
Des_pl = [Des_pl;bnd_des;nan];

%Band 5
bnd_grid = tgrid(indx_edges(9):indx_edges(10));
bnd_des = 0*bnd_grid;                          % user specified
bnd_wt = 10 * ones(length(bnd_grid),1);        % user specified
Des = [Des; bnd_des];
WT = [WT; bnd_wt];
grd = [grd;bnd_grid];
Des_pl = [Des_pl;bnd_des];










