% exp3.m 
% Input Data File
% Seismic Migration Filter 
% 

% Designed filter specifications
L = 35 ;            % filter length   % user specified

N1 = -17;

% Desired filter specifications 
%
sym = 1;           % 0 = no-symmetry,1 = even-symmetry,2 = odd-symmetry
                   % user specified
c = 1.0;
A = 2.0;
theta = 75;
fs = A/(2*pi);
fp = (A*sin(theta*pi/180))/(2*pi);
edges = [0 fp;fs 0.4995]; 
pas_edges = [0 fp]; 

if (sym) 
  str = 'half ';      % 'half' = 0 to 0.5
else
  str = 'whole';     % 'whole' = -0.5 to 0.5
end;                   
% Generate frequency grid
[tgrid, delf, vec_edges, indx_edges] = crmz_grid(edges, L, str);
tgrid = tgrid';

% Initialization
Des = [];
WT = [];
grd = [];
Des_pl = [];

% Band 1
bnd_grid = tgrid(indx_edges(1):indx_edges(2));
bnd_des =  exp(J*c*A*sqrt(1-(2.*pi.*bnd_grid/A).*(2.*pi.*bnd_grid/A))); 
% user specified
bnd_wt = 50 * ones(length(bnd_grid),1);        % user specified
Des = [Des; bnd_des];
WT = [WT; bnd_wt];
grd = [grd;bnd_grid];
Des_pl = [Des_pl;bnd_des;nan];

% Band 2
bnd_grid = tgrid(indx_edges(3):indx_edges(4));
bnd_des = 0 * bnd_grid;                         % user specified
bnd_wt = ones(length(bnd_grid),1);             % user specified
Des = [Des; bnd_des];
WT = [WT; bnd_wt];
grd = [grd;bnd_grid];
Des_pl = [Des_pl;bnd_des];









