/*------------ Telecommunications & Signal Processing Lab --------------
                         McGill University

Routine:
  DFiltFIR.h

Description:
  Declarations for DFiltFIR

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.13 $  $Date: 1996/05/30 01:40:14 $

----------------------------------------------------------------------*/

#ifndef DFiltFIR_h_
#define DFiltFIR_h_

#define PROGRAM "DFiltFIR"
#define VERSION	"v1r5a  1995/11/23"

#ifndef sun
#  include <float.h>
#else
#  include <values.h>
#  define FLT_MAX MAXFLOAT
#endif

#define MAXSPEC		200
#define MAXITER		40
#define GRIDD_DEF	16
#define DEVMAX		FLT_MAX

/* Unconstrained frequency values should have infinite upper and lower limits.
   However to accommodate machines that do not have a representation for
   infinity, the limits are set to large values.  These large values must leave
   some headroom for the modifications to the limits made in MMcanonSpec.  For
   some filter types, the limits are divided by a factor ch.  The minimum value
   for ch is
     chmin = 2 * sin (PI * delf), where delf is the grid spacing.  The value
   delf is equal to Fs/Ngridd, where Fs is the sum of the extents of the
   frequency bands specified and Ngridd is the desired number of grid points.
   Fs can be arbitrarily small and Ngridd can be arbitrarily large.  Assume
   Fs >= 0.05 (corresponding to 90% transition bands) and Ngridd <= 10,000.
   Then
     chmin = 2 * sin (PI * 0.05 / 10000) ~= PI * 1E-5
   Leaving some additional headroom, the limits for unconstrained frequencies
   are set based on chmin = 1.2E-7.

   The actual value used is based on chmin equal to a negative power of 2.
   With the cc compiler under SunOS 4.1, if NOLIMIT_U is assigned to a float
   value, and later the float value is compared to NOLIMIT_U, the comparison
   may be false.  The cc compiler effectively discards the float cast in the
   definition of NOLIMIT_U during comparisons.  Here NOLIMIT_U is defined to be
   a value which is the same as either a float or a double.
*/
#define HRV		1.1920928955078125E-7		/* 2^(-23) */
#define NOLIMIT_U	((float) (HRV * FLT_MAX))
#define NOLIMIT_L	((float) (-HRV * FLT_MAX))

/* File type codes */
#define BPF	1	/* Multiple passband/stopband filter */
#define REC	2	/* Multiple passband/stopband filter (sin(x)/x) */
#define DIF	3	/* Differentiator */
#define HIL	4	/* Hilbert transform filter */

/* Extremum codes */	/* LLIM = -ULIM and LDEV = -UDEV */
#define LLIM	-2	/* Lower constraint limit */
#define LDEV	-1	/* Downward extremum */
#define UDEV	1	/* Upward extremum */
#define ULIM	2	/* Upper constraint limit */

/*
   Band specification structure:  This structure contains the values for each
   band as specified by the user.
*/
struct Bspec {
  int Nbands;		/* Number of bands */
  int Nval[MAXSPEC];	/* Number of values in each band (Nband bands) */
  float f[MAXSPEC];	/* Normalized frequency values (increasing order) */
  float val[MAXSPEC];	/* Desired values */
  float w[MAXSPEC];	/* Weights */
  float liml[MAXSPEC];	/* Lower limits */
  float limu[MAXSPEC];	/* Upper limits */
};

/*
   Grid specification structure: This structure contains the specifications as
   transcribed to the frequency grid.  To start with this structure is used to
   store the user specifications.  Then in stages, the specifications are
   modified or transformed to form a set of specifications for a canonical
   filter
*/
struct Gspec {
  int Ngrid;		/* Number of grid values */
  float *grid;		/* Frequencies, either f [0,0.5] or x [-1,+1] */
  float *des;           /* Desired values */
  float *wt;            /* Weights */
  float *liml;          /* Lower limits */
  float *limu;		/* Upper limits */
};

/* Polynomial evaluation structure */
struct Pcev {
  int N;		/* Number of values */
  double *x;		/* Abscissa values */
  double *y;		/* Ordinate values */
  double *ad;		/* Lagrange interpolation coefficients */
};

#include <stdio.h>	/* defines FILENAME_MAX */

/* For non-ANSI headers */
#ifndef FILENAME_MAX	/* normally in stdio.h */
#  include <sys/param.h>
#  define FILENAME_MAX	MAXPATHLEN
#endif

/* For HPUX */
#ifdef hpux
#  undef FILENAME_MAX	/* defined in stdio.h as 14 */
#  include <sys/param.h>
#  define FILENAME_MAX	MAXPATHLEN
#endif

#include <libtsp.h>			/* p_ and const */

#ifdef __cplusplus
extern "C" {
#endif

/* Prototypes */
void
MMcanonSpec p_((int Fcase, const struct Gspec *G, struct Gspec *Gt));
void
MMcosCof p_((double xs, double xf, const double x[], const double y[],
	     int Next, double alpha[]));
int
MMdesFIR p_((int Ftype, double Gridd, const struct Bspec *S, float h[],
             int Ncof, float *devs));
int
MMdesRemez p_((const struct Gspec *G, double x[], double y[], int Etype[],
	       int Next, float *devs));
int
MMexchExt p_((const struct Pcev *P, const struct Gspec *G, double dev,
	      int Ext[], int Etype[]));
void
MMfiltCof p_((int Fcase, const double alpha[], double h[], int Ncof));
struct Gspec *
MMgridVal p_((int Fcase, int Ngridd, const struct Bspec *S));
void
MMintCof p_((const double x[], double ad[], int N));
double
MMintVal p_((double xarg, const struct Pcev *P));
double
MMmmDev p_((const double ad[], int Next, const struct Gspec *G,
	    const int Ext[], const int Etype[], int *ier));
void
MMmodSpec p_((int Ftype, const struct Gspec *G, struct Gspec *Gt));
void
MMoptions p_((int argc, const char *argv[], int *Ftype, int *Ncof,
	      float *Sfreq, float *Gridd, const char **Fname));
void
MMprintSpec p_((int Ftype, double dev, const struct Bspec *S));
struct Bspec *
MMreadSpec p_((int Ftype, int Ncof, double Sfreq));
void
MMtrCheb p_((const double acof[], int Ncof, double c, double d,
	     double bcof[]));
void
MMwriteCof p_((const char Fname[], int Ftype, const float h[], int Ncof,
	       const struct Bspec *S));

#ifdef __cplusplus
}
#endif

#endif /* DFiltFIR_h_ */
