/* a simple Cmix instrument to demonstrate i/o protocols.  Will mix
two input files to one outputfile */

#include "../H/ugens.h"
#include "../H/sfheader.h"

extern	SFHEADER	sfdesc[NFILES];  /* to access header information */

double r2w1(p,n_args)
float *p;

/* *p is an array of floats containing the arguments passed to this routine
   by Minc, n_args is the number of such args and is useful for error checking*/

{
	int i,j,nsamps,input1,input2,output,nchans;
	float xin1[4],xin2[4],out[4],amp1,amp2;

	input1=0; input2=1; output=2;  /* internal Cmix file numbers */
				       /* match numbers on input() and
					  output() commands */
	
	/* p0=starting time on output file, p1= duration, p2=starting time
	   on inputfile1, p3=starting time on inputfile2 p4=amp of inputfile1
	   p5=amp of inputfile2 */
	
	nsamps=setnote(p[0],p[1],output);  /* position outputfile*/
	setnote(p[2],p[1],input1);	   /* position inputfile1*/
	setnote(p[3],p[1],input2);	   /* position inputfile2*/

	amp1=p[4];
	amp2=p[5];

/* we will assume that all three files have the same number of channels */

	nchans = sfchans(&sfdesc[0]);  /* see sfheader.h for macros desc. */

	for(i=0; i<nsamps; i++) {
		if(!GETIN(xin1,input1))  break;  
		if(!GETIN(xin2,input2))  break;  

		/* we will terminate impolitely for now if we reach an
		eof on either input.  GETIN returns the number of 
		bytes read.  To do this right you should shut off
		a file once you reach its eof, but continue reading
		the other one*/

		for(j=0; j<nchans; j++) {
			out[j] = xin1[j];
			out[j] += xin2[j];
		}

		ADDOUT(out,output);  /* add output to disk*/
	}
	endnote(output);
}

int NBYTES = 32768;
profile()
{
	UG_INTRO("r2w1",r2w1);
}
