/*
 * addfunc()
 *	Function: Introduce a new unit generator to CMIX 
 *	Args:	name of unit generator
 *		pointer to generator
 *	Calls:	nothing
 *	Return:	0 on success, -1 on failure
 *		MX_FEXIST - ugen by that name already exists
 *		MX_EMEM	  - No memory to create ug_item
 *	Side Effects:
 */
#include	"../H/ugens.h"
#include	"mixerr.h"

addfunc(ug_p)
struct ug_item *ug_p;
{
	register struct ug_item *ug_tail;

	/*  Seek end of ug_list	*/
	for (ug_tail=ug_list; ug_tail->ug_next; ug_tail=ug_tail->ug_next)
	{
		if (!strcmp(ug_tail,ug_p->ug_name))	{
			mixerr = MX_FEXIST;
			return (-1);
		}
	}
	ug_tail->ug_next = ug_p;
	ug_p->ug_next = UG_NULL;
	return (0);
}
