/*
 *	dispatch.c: call a routine corresponding to ASCII name of
 *		routine
 *	Args:	ASCII name of function
 *		pointer to array of floating point parameters
 *	Calls:	just about anything with float args, provided it's
 *		in ug_list
 *	Return:	-1 if function was not found
 *		return value from function otherwise
 *		Caveat: -1 could be returned by a valid name
 *	    mixerr values:
 *		MX_FNAME - No function by that name
 */
#include	"../H/ugens.h"
#include	"mixerr.h"
#include	"../Minc/defs.h"

double dispatch(fname, p, n_args)
char *fname;
double *p;
short n_args;
{
	register struct ug_item *ug_p;
	int rv;
	double realrv;
	float pp[MAXDISPARGS];

	/* copy and convert to floats */
	for(rv=0; rv<n_args; rv++) pp[rv] = (float)p[rv];
	for(rv=n_args; rv<MAXDISPARGS; rv++) pp[rv] = p[rv] = 0;

	/*  Clear up old errors	*/
	mixerr = MX_NOERR;

	/*  Find the routine that goes with named function	*/
	for (ug_p=ug_list;; ug_p=ug_p->ug_next) {
		if (!ug_p)	{
			mixerr = MX_FNAME;
		printf("(Note: %s() is an undefined function.)\n",fname);
			return (-1);
		}
                if((rv=strcmp(ug_p->ug_name,fname)) == 0) goto out;
	}
	/*  Call the function	*/
out:	
	realrv = ( *(ug_p->ug_ptr))(pp, n_args, p);

	/*  Clean up???	*/
	return (realrv);
}
