#include "../H/ugens.h"
#define ARRAY_SIZE 256
#define NUM_ARRAYS  32
float minc_array[NUM_ARRAYS][ARRAY_SIZE],minc_array_size[NUM_ARRAYS];

double m_boost(p)
float *p;
{ return(boost(p[0])); }

double m_cpspch(p)
float *p;
{ return(cpspch(p[0])); }

double m_pchcps(p)
float *p;
{ return(pchcps(p[0])); }

double m_cpsoct(p)
float *p;
{ return(cpsoct(p[0])); }

double m_octpch(p)
float *p;
{ return(octpch(p[0])); }

double m_pchoct(p)
float *p;
{ return(pchoct(p[0])); }

double m_octcps(p)
float *p;
{ return(octcps(p[0])); }

double m_rand()
{ float rrand(); return(rrand()); }

double m_random()
{ float rrand(); return(rrand()*.5+.5); }

double m_srand(p)
float *p;
{ srrand(p[0]); }

double m_time_beat(p)
float *p;
{ float time_beat(); return(time_beat(p[0])); }

double m_beat_time(p)
float *p;
{ float beat_time(); return(beat_time(p[0])); }

double m_trunc(p)
float *p;
{ return((int)(p[0])); }

double m_ampdb(p)
float *p;
{ return(ampdb(p[0])); }

double m_load_array(p,n_args)
float *p;
{
	int i,j;
	if(n_args > ARRAY_SIZE) n_args = ARRAY_SIZE+1;
	j = p[0];
	for(i=1; i<n_args; i++) minc_array[j][i-1] = p[i];
	minc_array_size[j] = n_args;
	return(n_args-1);
}

double m_get_array(p,n_args)
float *p;
{
	int i;
	i = p[0];
	if(p[1] >= minc_array_size[i]) return(0);
	else return(minc_array[i][(int)p[1]]);
}

double m_put_array(p,n_args)
float *p;
{ /* to load a single value from minc */
	int i,j;
	i=p[0];
	j=p[1];
	minc_array[i][j] = p[2];
	minc_array_size[i]=minc_array_size[i] > j+1 ? minc_array_size[i] : j+1;
	if(j < ARRAY_SIZE) return(j);
	else return(-1);
}

double m_get_sum(p,n_args)
float *p;
{
	int i,j,k;
	float sum;
	i = p[0];
	if((j=p[1]) >= minc_array_size[i]) return(0);
	for(k=0,sum=0; k<=j; k++) sum += minc_array[i][k];
	return(sum);
}

double m_get_size(p,n_args)
float *p;
{
	/* returns same value as load_array would */
	return((double)minc_array_size[(int)p[0]]-1);
}

double m_mod(p,n_args)
float *p;
{
	int i,j;
	i = (int)p[0] % (int)p[1];
	return((float)i);
}

double m_max(p,n_args)
float *p;
{
	int i;
	float max = -1e+22;
	for(i=0; i<n_args; i++)
		if(p[i] > max) max=p[i];
	return(max);
}
double m_exit(p,n_args)
float *p;
{
	closesf();
}
double m_pow(p,n_args)
float *p;
{
	double pow();
	return(pow(p[0],p[1]));
}
double m_abs(p,n_args)
float *p;
{
	return(ABS(p[0]));
}
