
/* does filepointer point to end or beginning of buffer currently loaded?*/

#include "../H/ugens.h"
#include "../H/sfheader.h"
#include <stdio.h>

extern int NBYTES;           /* size of buffer to allocate */
extern float SR;
extern int  sfd[NFILES];         /* soundfile descriptors */
extern int  pointer[NFILES];     /* to be used as pointer within sound buffer */
extern int  bufsize[NFILES];        /* word length of buffer */
extern long  originalsize[NFILES];  /* to save byte length of file */
extern long  filepointer[NFILES];   /* to save current pointer in file */
extern char wipe_is_off[NFILES];
extern int status[NFILES];

extern SFHEADER      sfdesc[NFILES];
extern int fnums;

resetnote(start,fno)
float start;
{
	int mod, current_loc, desired_loc;

	if(fno >= fnums) {
		fprintf(stderr,"You haven't opened file %d yet!\n",fno);
		closesf();
	}

	current_loc = filepointer[fno] - SIZEOF_HEADER;
	/* filepointer is current byte in file i/o */

	desired_loc = (int)((((start > 0) ? start : -start/SR)
			    * (float)sfclass(&sfdesc[fno]) * SR)
        			* (float)sfchans(&sfdesc[fno]));

	mod = desired_loc % (sfclass(&sfdesc[fno]) * sfchans(&sfdesc[fno]));  
	desired_loc = mod ? desired_loc - mod : desired_loc;
	/* to make sure desired_loc starts on 0 byte of channel group */

	if 
	 (((current_loc-NBYTES) < desired_loc) || 
          (desired_loc >=  (filepointer[fno]) - SIZEOF_HEADER)) {
		if(status[fno] == 2) 
			_writeit(fno);/*write current buffer out*/
	   	if((filepointer[fno] = sflseek(sfd[fno],desired_loc,0)) == -1) {
			fprintf(stderr,"CMIX: bad lseek in setnot\n");
			closesf();
		}
		pointer[fno] = 0;
		if((status[fno] == 0) || (wipe_is_off[fno])) _readit(fno);
	}

	else 
	   pointer[fno] = (desired_loc - current_loc)/sfclass(&sfdesc[fno]);
}
